/*
 * Decompiled with CFR 0.152.
 */
package randoop.operation;

import coveredclass.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import coveredclass.org.checkerframework.dataflow.qual.Pure;
import coveredclass.org.checkerframework.dataflow.qual.SideEffectFree;
import java.util.ArrayList;
import java.util.List;
import randoop.ExceptionalExecution;
import randoop.ExecutionOutcome;
import randoop.NormalExecution;
import randoop.field.AccessibleField;
import randoop.field.FieldParser;
import randoop.main.RandoopBug;
import randoop.operation.CallableOperation;
import randoop.operation.OperationParseException;
import randoop.operation.TypedClassOperation;
import randoop.operation.TypedOperation;
import randoop.reflection.ReflectionPredicate;
import randoop.sequence.SequenceExecutionException;
import randoop.sequence.Variable;
import randoop.types.ClassOrInterfaceType;
import randoop.types.Type;
import randoop.types.TypeTuple;

public class FieldGet
extends CallableOperation {
    private @SignatureUnknown AccessibleField field;

    public FieldGet(@SignatureUnknown AccessibleField field) {
        this.field = field;
    }

    @Override
    public @SignatureUnknown ExecutionOutcome execute(@SignatureUnknown Object @SignatureUnknown [] statementInput) {
        Object input = statementInput.length == 0 ? null : statementInput[0];
        try {
            Object value = this.field.getValue(input);
            return new NormalExecution(value, 0L);
        }
        catch (RandoopBug | SequenceExecutionException e) {
            throw e;
        }
        catch (Throwable thrown) {
            return new ExceptionalExecution(thrown, 0L);
        }
    }

    @Override
    public void appendCode(@SignatureUnknown Type declaringType, @SignatureUnknown TypeTuple inputTypes, @SignatureUnknown Type outputType, @SignatureUnknown List<@SignatureUnknown Variable> inputVars, @SignatureUnknown StringBuilder b) {
        b.append(this.field.toCode(declaringType, inputVars));
    }

    @Override
    public @SignatureUnknown String toParsableString(@SignatureUnknown Type declaringType, @SignatureUnknown TypeTuple inputTypes, @SignatureUnknown Type outputType) {
        return declaringType.getBinaryName() + ".<get>(" + this.field.getName() + ")";
    }

    @SideEffectFree
    public @SignatureUnknown String toString() {
        return this.field.toString();
    }

    @Override
    public @SignatureUnknown String getName() {
        return "<get>(" + this.field.getName() + ")";
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @SignatureUnknown boolean equals(@SignatureUnknown Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FieldGet)) {
            return false;
        }
        FieldGet s2 = (FieldGet)obj;
        return this.field.equals(s2.field);
    }

    @Pure
    public @SignatureUnknown int hashCode() {
        return this.field.hashCode();
    }

    public static @SignatureUnknown TypedOperation parse(@SignatureUnknown String descr) throws @SignatureUnknown OperationParseException {
        String errorPrefix = "Error parsing " + descr + " as description for field getter statement: ";
        int openParPos = descr.indexOf(40);
        int closeParPos = descr.indexOf(41);
        if (openParPos < 0) {
            String msg = errorPrefix + " expecting parentheses.";
            throw new OperationParseException(msg);
        }
        String prefix = descr.substring(0, openParPos);
        int lastDotPos = prefix.lastIndexOf(46);
        assert (lastDotPos > 0) : "should be a period after the classname: " + descr;
        String classname = prefix.substring(0, lastDotPos);
        String opname = prefix.substring(lastDotPos + 1);
        assert (opname.equals("<get>")) : "expecting <get>, saw " + opname;
        if (closeParPos < 0) {
            String msg = errorPrefix + " no closing parentheses found.";
            throw new OperationParseException(msg);
        }
        String fieldname = descr.substring(openParPos + 1, closeParPos);
        AccessibleField accessibleField = FieldParser.parse(descr, classname, fieldname);
        ClassOrInterfaceType classType = accessibleField.getDeclaringType();
        Type fieldType = Type.forType(accessibleField.getRawField().getGenericType());
        ArrayList<Type> getInputTypeList = new ArrayList<Type>();
        if (!accessibleField.isStatic()) {
            getInputTypeList.add(classType);
        }
        return new TypedClassOperation(new FieldGet(accessibleField), classType, new TypeTuple(getInputTypeList), fieldType);
    }

    @Override
    public @SignatureUnknown boolean isStatic() {
        return this.field.isStatic();
    }

    @Override
    public @SignatureUnknown boolean isConstantField() {
        return this.field.isStatic() && this.field.isFinal();
    }

    @Override
    public @SignatureUnknown boolean isMessage() {
        return true;
    }

    @Override
    public @SignatureUnknown boolean satisfies(@SignatureUnknown ReflectionPredicate reflectionPredicate) {
        return this.field.satisfies(reflectionPredicate);
    }
}

