/*
 * Decompiled with CFR 0.152.
 */
package randoop.operation;

import coveredclass.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureBottom;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import coveredclass.org.checkerframework.dataflow.qual.Pure;
import coveredclass.org.checkerframework.dataflow.qual.SideEffectFree;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import randoop.ExceptionalExecution;
import randoop.ExecutionOutcome;
import randoop.operation.CallableOperation;
import randoop.operation.OperationParseException;
import randoop.operation.TypeArguments;
import randoop.operation.TypedClassOperation;
import randoop.reflection.ReflectionPredicate;
import randoop.sequence.Variable;
import randoop.types.ClassOrInterfaceType;
import randoop.types.Type;
import randoop.types.TypeTuple;
import randoop.util.ConstructorReflectionCode;
import randoop.util.ReflectionExecutor;
import randoop.util.Util;

public final class ConstructorCall
extends CallableOperation {
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Constructor<@SignatureUnknown @SignatureBottom ?> constructor;
    private @SignatureUnknown int hashCodeCached = 0;
    private @SignatureUnknown boolean hashCodeComputed = false;

    public ConstructorCall(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Constructor<@SignatureUnknown @SignatureBottom ?> constructor) {
        if (constructor == null) {
            throw new IllegalArgumentException("constructor should not be null.");
        }
        this.constructor = constructor;
        this.constructor.setAccessible(true);
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Constructor<@SignatureUnknown @SignatureBottom ?> getConstructor() {
        return this.constructor;
    }

    @SideEffectFree
    public @SignatureUnknown String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.constructor.getName());
        b.append("(");
        Class<?>[] types = this.constructor.getParameterTypes();
        if (types.length > 0) {
            b.append(types[0].getName());
            for (int i = 1; i < types.length; ++i) {
                b.append(", ").append(types[i].getName());
            }
        }
        b.append(")");
        return b.toString();
    }

    @Override
    public @SignatureUnknown String getName() {
        return "<init>";
    }

    @Override
    public void appendCode(@SignatureUnknown Type declaringType, @SignatureUnknown TypeTuple inputTypes, @SignatureUnknown Type outputType, @SignatureUnknown List<@SignatureUnknown Variable> inputVars, @SignatureUnknown StringBuilder b) {
        int i;
        assert (declaringType instanceof ClassOrInterfaceType) : "constructor must be member of class";
        ClassOrInterfaceType declaringClassType = (ClassOrInterfaceType)declaringType;
        boolean isMemberClass = declaringClassType.isMemberClass();
        assert (Util.implies(isMemberClass, !inputVars.isEmpty()));
        b.append(isMemberClass ? inputVars.get(0) + "." : "").append("new ").append(isMemberClass ? declaringClassType.getSimpleName() : declaringClassType.getFqName()).append("(");
        int n = i = isMemberClass ? 1 : 0;
        while (i < inputVars.size()) {
            if (i > (isMemberClass ? 1 : 0)) {
                b.append(", ");
            }
            if (!inputVars.get(i).getType().equals(inputTypes.get(i))) {
                b.append("(").append(inputTypes.get(i).getFqName()).append(")");
            }
            String param = this.getArgumentString(inputVars.get(i));
            b.append(param);
            ++i;
        }
        b.append(")");
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @SignatureUnknown boolean equals(@SignatureUnknown Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConstructorCall)) {
            return false;
        }
        ConstructorCall other = (ConstructorCall)o;
        return this.constructor.equals(other.constructor);
    }

    @Pure
    public @SignatureUnknown int hashCode() {
        if (!this.hashCodeComputed) {
            this.hashCodeComputed = true;
            this.hashCodeCached = this.constructor.hashCode();
        }
        return this.hashCodeCached;
    }

    @Override
    public @SignatureUnknown ExecutionOutcome execute(@SignatureUnknown Object @SignatureUnknown [] statementInput) {
        if (statementInput.length > 0 && statementInput[0] == null) {
            Class<?> declaringClass = this.constructor.getDeclaringClass();
            int mods = declaringClass.getModifiers() & Modifier.classModifiers();
            if (declaringClass.isMemberClass() && !Modifier.isStatic(mods)) {
                String message = "reflection call to " + this.constructor.getName() + " with null for superclass argument";
                return new ExceptionalExecution(new NullPointerException(message), 0L);
            }
        }
        ConstructorReflectionCode code = new ConstructorReflectionCode(this.constructor, statementInput);
        return ReflectionExecutor.executeReflectionCode(code);
    }

    @Override
    public @SignatureUnknown String toParsableString(@SignatureUnknown Type declaringType, @SignatureUnknown TypeTuple inputTypes, @SignatureUnknown Type outputType) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.constructor.getName()).append(".<init>(");
        Class<?>[] params = this.constructor.getParameterTypes();
        TypeArguments.getTypeArgumentString(sb, params);
        sb.append(")");
        return sb.toString();
    }

    public static @SignatureUnknown TypedClassOperation parse(@SignatureUnknown String signature) throws @SignatureUnknown OperationParseException {
        Constructor<?> con;
        Object[] typeArguments;
        Type classType;
        if (signature == null) {
            throw new IllegalArgumentException("signature may not be null");
        }
        int openParPos = signature.indexOf(40);
        int closeParPos = signature.indexOf(41);
        String prefix = signature.substring(0, openParPos);
        int lastDotPos = prefix.lastIndexOf(46);
        assert (lastDotPos >= 0);
        String classname = prefix.substring(0, lastDotPos);
        String opname = prefix.substring(lastDotPos + 1);
        assert (opname.equals("<init>")) : "expected init, saw " + opname;
        String arguments = signature.substring(openParPos + 1, closeParPos);
        try {
            classType = Type.getTypeforFullyQualifiedName(classname);
        }
        catch (ClassNotFoundException e) {
            String msg = "Class " + classname + " is not on classpath while parsing \"" + signature + "\"";
            throw new OperationParseException(msg);
        }
        try {
            typeArguments = TypeArguments.getTypeArgumentsForString(arguments);
        }
        catch (OperationParseException e) {
            throw new OperationParseException(e.getMessage() + " while parsing \"" + signature + "\"");
        }
        try {
            con = classType.getRuntimeClass().getDeclaredConstructor((Class<?>[])typeArguments);
        }
        catch (NoSuchMethodException e) {
            String msg = "Constructor with arguments " + Arrays.toString(typeArguments) + " does not exist in " + classType + ": " + e;
            throw new OperationParseException(msg);
        }
        return TypedClassOperation.forConstructor(con);
    }

    @Override
    public @SignatureUnknown boolean isConstructorCall() {
        return true;
    }

    @Override
    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Constructor<@SignatureUnknown @SignatureBottom ?> getReflectionObject() {
        return this.constructor;
    }

    @Override
    public @SignatureUnknown boolean satisfies(@SignatureUnknown ReflectionPredicate reflectionPredicate) {
        return reflectionPredicate.test(this.constructor);
    }
}

