/*
 * Decompiled with CFR 0.152.
 */
package randoop.operation;

import coveredclass.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import coveredclass.org.checkerframework.dataflow.qual.Pure;
import coveredclass.org.checkerframework.dataflow.qual.SideEffectFree;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Objects;
import randoop.ExecutionOutcome;
import randoop.NormalExecution;
import randoop.operation.CallableOperation;
import randoop.sequence.Variable;
import randoop.types.ArrayType;
import randoop.types.Type;
import randoop.types.TypeTuple;

public class ArrayCreation
extends CallableOperation {
    private final @SignatureUnknown Type elementType;
    private final @SignatureUnknown Type componentType;
    private @SignatureUnknown int dimensions;

    ArrayCreation(@SignatureUnknown ArrayType arrayType) {
        this.elementType = arrayType.getElementType();
        this.componentType = arrayType.getComponentType();
        this.dimensions = arrayType.getDimensions();
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @SignatureUnknown boolean equals(@SignatureUnknown Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ArrayCreation)) {
            return false;
        }
        ArrayCreation arrayCreation = (ArrayCreation)obj;
        return this.elementType.equals(arrayCreation.elementType) && this.dimensions == arrayCreation.dimensions;
    }

    @Pure
    public @SignatureUnknown int hashCode() {
        return Objects.hash(this.elementType, this.dimensions);
    }

    @SideEffectFree
    public @SignatureUnknown String toString() {
        StringBuilder result = new StringBuilder(this.elementType.getBinaryName());
        for (int i = 0; i < this.dimensions; ++i) {
            result.append("[]");
        }
        return result.toString();
    }

    @Override
    public @SignatureUnknown ExecutionOutcome execute(@SignatureUnknown Object @SignatureUnknown [] input) {
        assert (input.length == 1) : "requires array dimension as input";
        int length = (Integer)input[0];
        long startTime = System.currentTimeMillis();
        Object theArray = Array.newInstance(this.componentType.getRuntimeClass(), length);
        long totalTime = System.currentTimeMillis() - startTime;
        return new NormalExecution(theArray, totalTime);
    }

    @Override
    public void appendCode(@SignatureUnknown Type declaringType, @SignatureUnknown TypeTuple inputTypes, @SignatureUnknown Type outputType, @SignatureUnknown List<@SignatureUnknown Variable> inputVars, @SignatureUnknown StringBuilder b) {
        Variable inputVar = inputVars.get(0);
        b.append("new").append(" ").append(this.elementType.getFqName());
        b.append("[ ");
        String param = this.getArgumentString(inputVar);
        b.append(param).append(" ]");
        for (int i = 1; i < this.dimensions; ++i) {
            b.append("[]");
        }
    }

    @Override
    public @SignatureUnknown String toParsableString(@SignatureUnknown Type declaringType, @SignatureUnknown TypeTuple inputTypes, @SignatureUnknown Type outputType) {
        StringBuilder result = new StringBuilder(this.elementType.getBinaryName() + "[ " + inputTypes.get(0) + " ]");
        for (int i = 1; i < this.dimensions; ++i) {
            result.append("[]");
        }
        return result.toString();
    }

    @Override
    public @SignatureUnknown String getName() {
        return this.toString();
    }
}

