/*
 * Decompiled with CFR 0.152.
 */
package randoop.main;

import coveredclass.org.apache.commons.exec.CommandLine;
import coveredclass.org.apache.commons.exec.DefaultExecuteResultHandler;
import coveredclass.org.apache.commons.exec.DefaultExecutor;
import coveredclass.org.apache.commons.exec.ExecuteWatchdog;
import coveredclass.org.apache.commons.exec.PumpStreamHandler;
import coveredclass.org.apache.commons.io.FilenameUtils;
import coveredclass.org.apache.commons.lang3.StringUtils;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import coveredclass.org.github.javaparser.JavaParser;
import coveredclass.org.github.javaparser.ParseResult;
import coveredclass.org.github.javaparser.Problem;
import coveredclass.org.github.javaparser.ast.CompilationUnit;
import coveredclass.org.github.javaparser.ast.ImportDeclaration;
import coveredclass.org.github.javaparser.ast.Node;
import coveredclass.org.github.javaparser.ast.NodeList;
import coveredclass.org.github.javaparser.ast.PackageDeclaration;
import coveredclass.org.github.javaparser.ast.body.BodyDeclaration;
import coveredclass.org.github.javaparser.ast.body.MethodDeclaration;
import coveredclass.org.github.javaparser.ast.body.TypeDeclaration;
import coveredclass.org.github.javaparser.ast.body.VariableDeclarator;
import coveredclass.org.github.javaparser.ast.comments.Comment;
import coveredclass.org.github.javaparser.ast.expr.AnnotationExpr;
import coveredclass.org.github.javaparser.ast.expr.BinaryExpr;
import coveredclass.org.github.javaparser.ast.expr.BooleanLiteralExpr;
import coveredclass.org.github.javaparser.ast.expr.DoubleLiteralExpr;
import coveredclass.org.github.javaparser.ast.expr.Expression;
import coveredclass.org.github.javaparser.ast.expr.IntegerLiteralExpr;
import coveredclass.org.github.javaparser.ast.expr.LiteralExpr;
import coveredclass.org.github.javaparser.ast.expr.LongLiteralExpr;
import coveredclass.org.github.javaparser.ast.expr.MethodCallExpr;
import coveredclass.org.github.javaparser.ast.expr.NameExpr;
import coveredclass.org.github.javaparser.ast.expr.NullLiteralExpr;
import coveredclass.org.github.javaparser.ast.expr.SimpleName;
import coveredclass.org.github.javaparser.ast.expr.VariableDeclarationExpr;
import coveredclass.org.github.javaparser.ast.stmt.BlockStmt;
import coveredclass.org.github.javaparser.ast.stmt.ExpressionStmt;
import coveredclass.org.github.javaparser.ast.stmt.Statement;
import coveredclass.org.github.javaparser.ast.type.ClassOrInterfaceType;
import coveredclass.org.github.javaparser.ast.type.PrimitiveType;
import coveredclass.org.github.javaparser.ast.type.ReferenceType;
import coveredclass.org.github.javaparser.ast.type.Type;
import coveredclass.org.github.javaparser.ast.visitor.CloneVisitor;
import coveredclass.org.github.javaparser.utils.PositionUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.plumelib.options.Option;
import org.plumelib.options.OptionGroup;
import org.plumelib.options.Options;
import randoop.Globals;
import randoop.main.CommandHandler;
import randoop.main.RandoopBug;
import randoop.main.RandoopCommandError;
import randoop.output.ClassRenamingVisitor;
import randoop.output.ClassTypeNameSimplifyVisitor;
import randoop.output.ClassTypeVisitor;
import randoop.output.FieldAccessTypeNameSimplifyVisitor;
import randoop.output.MethodTypeNameSimplifyVisitor;
import randoop.output.PrimitiveAndWrappedTypeVarNameCollector;

public class Minimize
extends CommandHandler {
    @OptionGroup(value="Test case minimization")
    @Option(value="File containing the JUnit test suite to be minimized")
    public static @SignatureUnknown String suitepath;
    @Option(value="Classpath to compile and run the JUnit test suite")
    public static @SignatureUnknown String suiteclasspath;
    @Option(value="Timeout, in seconds, for the whole minimization process")
    public static @SignatureUnknown int minimizetimeout;
    @Option(value="Timeout, in seconds, for the whole test suite")
    public static @SignatureUnknown int testsuitetimeout;
    @Option(value="Verbose, flag for verbose output")
    public static @SignatureUnknown boolean verboseminimizer;
    private static final @SignatureUnknown JavaParser javaParser;
    private static final @SignatureUnknown String PATH_SEPARATOR;
    private static final @SignatureUnknown String SUFFIX = "Minimized";
    private static @SignatureUnknown ClassOrInterfaceTypeComparator classOrInterfaceTypeComparator;
    private static @SignatureUnknown ImportDeclarationComparator importDeclarationComparator;

    Minimize() {
        super("minimize", "Minimize a failing JUnit test suite.", "minimize", "", "Minimize a failing JUnit test suite.", null, "Path to Java file whose failing tests will be minimized, classpath to compile and run the Java file, maximum time (in seconds) allowed for a single unit test case to run before it times out.", "A minimized JUnit test suite (as one Java file) named \"InputFileMinimized.java\" if \"InputFile.java\" were the name of the input file.", "java randoop.main.Main minimize --suitepath=~/RandoopTests/src/ErrorTestLang.java --suiteclasspath=~/RandoopTests/commons-lang3-3.5.jar --testsuitetimeout=30", new Options(Minimize.class));
    }

    public static @SignatureUnknown String minimizedClassName(@SignatureUnknown Path file) {
        return FilenameUtils.removeExtension(file.getFileName().toString()) + SUFFIX;
    }

    @Override
    public @SignatureUnknown boolean handle(@SignatureUnknown String @SignatureUnknown [] args) {
        try {
            Object[] nonargs = this.foptions.parse(args);
            if (nonargs.length > 0) {
                throw new RandoopCommandError("Unrecognized arguments: " + Arrays.toString(nonargs));
            }
        }
        catch (Options.ArgException ae) {
            throw new RandoopCommandError(ae.getMessage());
        }
        if (suitepath == null) {
            throw new RandoopCommandError("Use --suitepath to specify a file to be minimized.");
        }
        if (!FilenameUtils.getExtension(suitepath).equals("java")) {
            throw new RandoopCommandError("The input file must be a Java file: " + suitepath);
        }
        if (testsuitetimeout <= 0) {
            throw new RandoopCommandError("Timout must be positive, was given as " + testsuitetimeout + ".");
        }
        if (minimizetimeout <= 0) {
            throw new RandoopCommandError("Minimizer timout must be positive, was given as " + minimizetimeout + ".");
        }
        final Path originalFile = Paths.get(suitepath, new String[0]);
        ExecutorService executor = Executors.newFixedThreadPool(1);
        Future<Boolean> future = executor.submit(new Callable<Boolean>(){

            @Override
            public @SignatureUnknown Boolean call() throws @SignatureUnknown IOException {
                return Minimize.mainMinimize(originalFile, suiteclasspath, testsuitetimeout, verboseminimizer);
            }
        });
        executor.shutdown();
        boolean success = false;
        try {
            success = future.get(minimizetimeout, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            System.err.println("Minimization process was interrupted.");
        }
        catch (ExecutionException e) {
            System.err.println("Minimizer exception: " + e.getCause());
        }
        catch (TimeoutException e) {
            future.cancel(true);
            System.err.println("Minimization process timed out.");
        }
        try {
            if (!executor.awaitTermination(5L, TimeUnit.SECONDS)) {
                executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            System.err.println("Minimization process force terminated.");
        }
        return success;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static @SignatureUnknown boolean mainMinimize(@SignatureUnknown Path file, @SignatureUnknown String classPath, @SignatureUnknown int timeoutLimit, @SignatureUnknown boolean verboseOutput) throws @SignatureUnknown IOException {
        String packageName;
        CompilationUnit compilationUnit;
        System.out.println("Minimizing: " + file);
        if (verboseOutput) {
            System.out.println("Reading and parsing file.");
        }
        try (FileInputStream inputStream = new FileInputStream(file.toFile());){
            ParseResult<CompilationUnit> parseCompilationUnit = javaParser.parse(inputStream);
            if (!parseCompilationUnit.isSuccessful()) {
                System.err.println("Error parsing Java file: " + file);
                for (Problem problem : parseCompilationUnit.getProblems()) {
                    System.out.println(problem);
                }
                boolean bl = false;
                return bl;
            }
            compilationUnit = parseCompilationUnit.getResult().get();
        }
        catch (IOException e) {
            System.err.println("Error reading Java file: " + file);
            e.printStackTrace(System.err);
            return false;
        }
        if (verboseOutput) {
            System.out.println("Getting expected output.");
        }
        try {
            Optional<PackageDeclaration> oClassPackage = compilationUnit.getPackageDeclaration();
            packageName = oClassPackage.isPresent() ? oClassPackage.get().getName().toString() : null;
        }
        catch (NoSuchElementException e) {
            packageName = null;
        }
        String oldClassName = FilenameUtils.removeExtension(file.getFileName().toString());
        String newClassName = oldClassName + SUFFIX;
        Path minimizedFile = ClassRenamingVisitor.copyAndRename(file, compilationUnit, oldClassName, newClassName);
        Outputs compilationOutput = Minimize.compileJavaFile(minimizedFile, classPath, packageName, timeoutLimit);
        if (compilationOutput.isFailure()) {
            System.err.println("Error when compiling file " + file + ". Aborting.");
            System.err.println(compilationOutput.diagnostics());
            return false;
        }
        String runResult = Minimize.runJavaFile(minimizedFile, classPath, packageName, timeoutLimit);
        Map<String, String> expectedOutput = Minimize.normalizeJUnitOutput(runResult);
        Minimize.minimizeTestSuite(compilationUnit, packageName, minimizedFile, classPath, expectedOutput, timeoutLimit);
        compilationUnit = Minimize.simplifyTypeNames(compilationUnit, packageName, minimizedFile, classPath, expectedOutput, timeoutLimit, verboseOutput);
        Minimize.writeToFile(compilationUnit, minimizedFile);
        Minimize.cleanUp(minimizedFile, verboseOutput);
        System.out.println("Original file length: " + Minimize.getFileLength(file) + " lines.");
        System.out.println("Minimized file length: " + Minimize.getFileLength(minimizedFile) + " lines.");
        return true;
    }

    private static void minimizeTestSuite(@SignatureUnknown CompilationUnit compilationUnit, @SignatureUnknown String packageName, @SignatureUnknown Path file, @SignatureUnknown String classpath, @SignatureUnknown Map<@SignatureUnknown String, @SignatureUnknown String> expectedOutput, @SignatureUnknown int timeoutLimit) throws @SignatureUnknown IOException {
        System.out.println("Minimizing test suite.");
        int numberOfTestMethods = Minimize.getNumberOfTestMethods(compilationUnit);
        int numberOfMinimizedTests = 0;
        for (TypeDeclaration<?> type : compilationUnit.getTypes()) {
            for (BodyDeclaration<?> member : type.getMembers()) {
                MethodDeclaration method;
                if (!(member instanceof MethodDeclaration) || !Minimize.isTestMethod(method = (MethodDeclaration)member)) continue;
                Minimize.minimizeMethod(method, compilationUnit, packageName, file, classpath, expectedOutput, timeoutLimit);
                Minimize.printProgress(++numberOfMinimizedTests, numberOfTestMethods, method.getName());
            }
        }
    }

    private static @SignatureUnknown boolean isTestMethod(@SignatureUnknown MethodDeclaration methodDeclaration) {
        for (AnnotationExpr annotationExpr : methodDeclaration.getAnnotations()) {
            if (!annotationExpr.toString().equals("@Test")) continue;
            return true;
        }
        return false;
    }

    private static void minimizeMethod(@SignatureUnknown MethodDeclaration method, @SignatureUnknown CompilationUnit compilationUnit, @SignatureUnknown String packageName, @SignatureUnknown Path file, @SignatureUnknown String classpath, @SignatureUnknown Map<@SignatureUnknown String, @SignatureUnknown String> expectedOutput, @SignatureUnknown int timeoutLimit) throws @SignatureUnknown IOException {
        Optional<BlockStmt> oBlockStmt = method.getBody();
        if (!oBlockStmt.isPresent()) {
            return;
        }
        BlockStmt body = oBlockStmt.get();
        NodeList<Statement> statements = body.getStatements();
        HashMap<String, String> primitiveValues = new HashMap<String, String>();
        HashSet<String> primitiveAndWrappedTypes = new HashSet<String>();
        new PrimitiveAndWrappedTypeVarNameCollector().visit(compilationUnit, primitiveAndWrappedTypes);
        for (int i = statements.size() - 1; i >= 0; --i) {
            Statement currStmt = (Statement)statements.get(i);
            ArrayList<Comment> orphanComments = new ArrayList<Comment>(1);
            Minimize.getOrphanCommentsBeforeThisChildNode(currStmt, orphanComments);
            Node parent = currStmt.getParentNode().get();
            statements.remove(i);
            List<Statement> replacements = Minimize.getStatementReplacements(currStmt, primitiveValues);
            boolean replacementFound = false;
            boolean replacementIsNull = false;
            for (Statement stmt : replacements) {
                if (stmt != null) {
                    statements.add(i, stmt);
                }
                Minimize.writeToFile(compilationUnit, file);
                if (Minimize.checkCorrectlyMinimized(file, classpath, packageName, expectedOutput, timeoutLimit)) {
                    replacementFound = true;
                    replacementIsNull = stmt == null;
                    Minimize.storeValueFromAssertion(currStmt, primitiveValues, primitiveAndWrappedTypes);
                    break;
                }
                if (stmt == null) continue;
                statements.remove(i);
            }
            if (!replacementFound) {
                statements.add(i, currStmt);
                continue;
            }
            if (!replacementIsNull) continue;
            for (Comment oc : orphanComments) {
                parent.removeOrphanComment(oc);
            }
        }
    }

    private static void storeValueFromAssertion(@SignatureUnknown Statement currStmt, @SignatureUnknown Map<@SignatureUnknown String, @SignatureUnknown String> primitiveValues, @SignatureUnknown Set<@SignatureUnknown String> primitiveAndWrappedTypeVars) {
        Expression exp;
        if (currStmt instanceof ExpressionStmt && (exp = ((ExpressionStmt)currStmt).getExpression()) instanceof MethodCallExpr) {
            MethodCallExpr mCall = (MethodCallExpr)exp;
            if (mCall.getName().toString().equals("assertTrue")) {
                BinaryExpr binaryExp;
                Expression mExp;
                NodeList<Expression> mArgs = mCall.getArguments();
                if (mArgs.size() == 1) {
                    mExp = (Expression)mArgs.get(0);
                } else if (mArgs.size() == 1) {
                    mExp = (Expression)mArgs.get(1);
                } else {
                    return;
                }
                if (mExp instanceof BinaryExpr && (binaryExp = (BinaryExpr)mExp).getOperator().equals(BinaryExpr.Operator.EQUALS)) {
                    Minimize.primitiveVarEquality(binaryExp.getLeft(), binaryExp.getRight(), primitiveValues, primitiveAndWrappedTypeVars);
                }
            } else if (mCall.getName().toString().equals("assertEquals")) {
                NodeList<Expression> mArgs = mCall.getArguments();
                if (mArgs.size() == 2) {
                    Minimize.primitiveVarEquality((Expression)mArgs.get(0), (Expression)mArgs.get(1), primitiveValues, primitiveAndWrappedTypeVars);
                } else if (mArgs.size() == 3) {
                    Minimize.primitiveVarEquality((Expression)mArgs.get(1), (Expression)mArgs.get(2), primitiveValues, primitiveAndWrappedTypeVars);
                } else {
                    return;
                }
            }
        }
    }

    private static void primitiveVarEquality(@SignatureUnknown Expression exp1, @SignatureUnknown Expression exp2, @SignatureUnknown Map<@SignatureUnknown String, @SignatureUnknown String> primitiveValues, @SignatureUnknown Set<@SignatureUnknown String> primitiveAndWrappedTypeVars) {
        Expression val;
        NameExpr name;
        if (exp1 instanceof NameExpr && exp2 instanceof LiteralExpr) {
            name = (NameExpr)exp1;
            val = exp2;
        } else if (exp2 instanceof NameExpr && exp1 instanceof LiteralExpr) {
            name = (NameExpr)exp2;
            val = exp1;
        } else {
            return;
        }
        if (primitiveAndWrappedTypeVars.contains(name.getName().toString())) {
            primitiveValues.put(name.toString(), val.toString());
        }
    }

    private static @SignatureUnknown List<@SignatureUnknown Statement> getStatementReplacements(@SignatureUnknown Statement currStmt, @SignatureUnknown Map<@SignatureUnknown String, @SignatureUnknown String> primitiveValues) {
        Expression exp;
        ArrayList<Statement> replacements = new ArrayList<Statement>();
        replacements.add(null);
        if (currStmt instanceof ExpressionStmt && (exp = ((ExpressionStmt)currStmt).getExpression()) instanceof VariableDeclarationExpr) {
            Statement lhsRemovalStmt;
            VariableDeclarationExpr vdExpr = (VariableDeclarationExpr)exp;
            replacements.addAll(Minimize.rhsAssignZeroValue(vdExpr));
            Statement rhsAssertValStmt = Minimize.rhsAssignValueFromPassingAssertion(vdExpr, primitiveValues);
            if (rhsAssertValStmt != null) {
                replacements.add(rhsAssertValStmt);
            }
            if ((lhsRemovalStmt = Minimize.removeLeftHandSideSimplification(vdExpr)) != null) {
                replacements.add(lhsRemovalStmt);
            }
        }
        return replacements;
    }

    private static @SignatureUnknown List<@SignatureUnknown Statement> rhsAssignZeroValue(@SignatureUnknown VariableDeclarationExpr vdExpr) {
        ArrayList<Statement> resultList = new ArrayList<Statement>();
        if (vdExpr.getVariables().size() != 1) {
            return resultList;
        }
        Type type = ((VariableDeclarator)vdExpr.getVariables().get(0)).getType();
        if (type instanceof PrimitiveType) {
            resultList.add(Minimize.rhsAssignWithValue(vdExpr, type, null));
        } else {
            ClassOrInterfaceType classType;
            resultList.add(Minimize.rhsAssignWithValue(vdExpr, type, null));
            ReferenceType rType = (ReferenceType)type;
            if (rType instanceof ClassOrInterfaceType && (classType = (ClassOrInterfaceType)rType).isBoxedType()) {
                resultList.add(Minimize.rhsAssignWithValue(vdExpr, classType.toUnboxedType(), null));
            }
        }
        return resultList;
    }

    private static @SignatureUnknown Statement rhsAssignValueFromPassingAssertion(@SignatureUnknown VariableDeclarationExpr vdExpr, @SignatureUnknown Map<@SignatureUnknown String, @SignatureUnknown String> primitiveValues) {
        if (vdExpr.getVariables().size() != 1) {
            return null;
        }
        VariableDeclarator vDecl = (VariableDeclarator)vdExpr.getVariables().get(0);
        String varName = vDecl.getName().toString();
        if (primitiveValues.containsKey(varName)) {
            String value = primitiveValues.get(varName);
            return Minimize.rhsAssignWithValue(vdExpr, vDecl.getType(), value);
        }
        return null;
    }

    private static @SignatureUnknown Statement rhsAssignWithValue(@SignatureUnknown VariableDeclarationExpr vdExpr, @SignatureUnknown Type exprType, @SignatureUnknown String value) {
        if (vdExpr.getVariables().size() != 1) {
            return null;
        }
        VariableDeclarationExpr resultExpr = vdExpr.clone();
        VariableDeclarator vd = (VariableDeclarator)resultExpr.getVariables().get(0);
        if (exprType instanceof PrimitiveType) {
            vd.setInitializer(Minimize.getLiteralExpression(value, ((PrimitiveType)exprType).getType()));
        } else {
            vd.setInitializer(new NullLiteralExpr());
        }
        return new ExpressionStmt(resultExpr);
    }

    private static @SignatureUnknown LiteralExpr getLiteralExpression(@SignatureUnknown String value, @SignatureUnknown PrimitiveType.Primitive type) {
        switch (type) {
            case BOOLEAN: {
                if (value == null) {
                    return new BooleanLiteralExpr(Boolean.parseBoolean("false"));
                }
                return new BooleanLiteralExpr(Boolean.parseBoolean(value));
            }
            case CHAR: 
            case BYTE: 
            case SHORT: 
            case INT: {
                if (value == null) {
                    return new IntegerLiteralExpr("0");
                }
                return new IntegerLiteralExpr(value);
            }
            case FLOAT: {
                if (value == null) {
                    return new DoubleLiteralExpr("0f");
                }
                return new DoubleLiteralExpr(value);
            }
            case DOUBLE: {
                if (value == null) {
                    return new DoubleLiteralExpr("0.0");
                }
                return new DoubleLiteralExpr(value);
            }
            case LONG: {
                if (value == null) {
                    return new LongLiteralExpr("0L");
                }
                return new LongLiteralExpr(value);
            }
        }
        throw new IllegalArgumentException("Type passed to get a literal expression was not a primitive type.");
    }

    private static @SignatureUnknown Statement removeLeftHandSideSimplification(@SignatureUnknown VariableDeclarationExpr vdExpr) {
        if (vdExpr.getVariables().size() > 1) {
            return null;
        }
        VariableDeclarationExpr resultExpr = vdExpr.clone();
        NodeList<VariableDeclarator> vars = resultExpr.getVariables();
        VariableDeclarator vd = (VariableDeclarator)vars.get(0);
        Optional<Expression> initializer = vd.getInitializer();
        if (initializer.isPresent()) {
            return new ExpressionStmt(initializer.get());
        }
        return null;
    }

    private static @SignatureUnknown CompilationUnit simplifyTypeNames(@SignatureUnknown CompilationUnit compilationUnit, @SignatureUnknown String packageName, @SignatureUnknown Path file, @SignatureUnknown String classpath, @SignatureUnknown Map<@SignatureUnknown String, @SignatureUnknown String> expectedOutput, @SignatureUnknown int timeoutLimit, @SignatureUnknown boolean verboseOutput) throws @SignatureUnknown IOException {
        if (verboseOutput) {
            System.out.println("Adding imports and simplifying type names.");
        }
        TreeSet<ClassOrInterfaceType> types = new TreeSet<ClassOrInterfaceType>(classOrInterfaceTypeComparator);
        new ClassTypeVisitor().visit(compilationUnit, types);
        CompilationUnit result = compilationUnit;
        for (ClassOrInterfaceType type : types) {
            String scopeString;
            CompilationUnit compUnitWithSimpleTypeNames = (CompilationUnit)result.accept(new CloneVisitor(), null);
            Optional<ClassOrInterfaceType> scope = type.getScope();
            String string = scopeString = scope.isPresent() ? scope.get() + "." : "";
            if (!scopeString.equals("java.lang.")) {
                Minimize.addImport(compUnitWithSimpleTypeNames, scopeString + type.getName());
            }
            new ClassTypeNameSimplifyVisitor().visit(compUnitWithSimpleTypeNames, type);
            new MethodTypeNameSimplifyVisitor().visit(compUnitWithSimpleTypeNames, type);
            new FieldAccessTypeNameSimplifyVisitor().visit(compUnitWithSimpleTypeNames, type);
            Minimize.writeToFile(compUnitWithSimpleTypeNames, file);
            if (!Minimize.checkCorrectlyMinimized(file, classpath, packageName, expectedOutput, timeoutLimit)) continue;
            result = compUnitWithSimpleTypeNames;
        }
        Minimize.sortImports(result);
        return result;
    }

    private static @SignatureUnknown boolean checkCorrectlyMinimized(@SignatureUnknown Path file, @SignatureUnknown String classpath, @SignatureUnknown String packageName, @SignatureUnknown Map<@SignatureUnknown String, @SignatureUnknown String> expectedOutput, @SignatureUnknown int timeoutLimit) {
        Outputs compilationOutput = Minimize.compileJavaFile(file, classpath, packageName, timeoutLimit);
        if (compilationOutput.isFailure()) {
            return false;
        }
        String runResult = Minimize.runJavaFile(file, classpath, packageName, timeoutLimit);
        return expectedOutput.equals(Minimize.normalizeJUnitOutput(runResult));
    }

    private static @SignatureUnknown Outputs compileJavaFile(@SignatureUnknown Path file, @SignatureUnknown String classpath, @SignatureUnknown String packageName, @SignatureUnknown int timeoutLimit) {
        Path executionDir = Minimize.getExecutionDirectory(file, packageName);
        String command = "javac -classpath .";
        if (classpath != null) {
            command = command + PATH_SEPARATOR + classpath;
        }
        command = command + " " + file.toAbsolutePath().toString();
        return Minimize.runProcess(command, executionDir, timeoutLimit);
    }

    private static @SignatureUnknown String runJavaFile(@SignatureUnknown Path file, @SignatureUnknown String userClassPath, @SignatureUnknown String packageName, @SignatureUnknown int timeoutLimit) {
        Path executionDir = Minimize.getExecutionDirectory(file, packageName);
        String dirPath = ".";
        if (file.getParent() != null) {
            dirPath = dirPath + PATH_SEPARATOR + file.getParent();
        }
        String classpath = dirPath;
        if (userClassPath != null) {
            classpath = classpath + PATH_SEPARATOR + userClassPath;
        }
        String fqClassName = FilenameUtils.getBaseName(file.toString());
        if (packageName != null) {
            fqClassName = packageName + "." + fqClassName;
        }
        String command = "java -classpath " + classpath + " org.junit.runner.JUnitCore " + fqClassName;
        return Minimize.runProcess((String)command, (Path)executionDir, (int)timeoutLimit).stdout;
    }

    private static @SignatureUnknown Path getExecutionDirectory(@SignatureUnknown Path file, @SignatureUnknown String packageName) {
        if (packageName == null) {
            return null;
        }
        int foldersAbove = StringUtils.countMatches((CharSequence)packageName, ".") + 2;
        for (int i = 0; i < foldersAbove; ++i) {
            file = file.getParent();
        }
        return file;
    }

    public static @SignatureUnknown Outputs runProcess(@SignatureUnknown String command, @SignatureUnknown Path executionDir, @SignatureUnknown int timeoutLimit) {
        String errOutputString;
        String stdOutputString;
        int exitValue;
        ByteArrayOutputStream errStream;
        ByteArrayOutputStream outStream;
        ExecuteWatchdog watchdog;
        DefaultExecutor executor;
        CommandLine cmdLine;
        block11: {
            if (executionDir != null && executionDir.toString().isEmpty()) {
                executionDir = null;
            }
            String[] args = command.split(" ");
            cmdLine = new CommandLine(args[0]);
            cmdLine.addArguments(Arrays.copyOfRange(args, 1, args.length));
            DefaultExecuteResultHandler resultHandler = new DefaultExecuteResultHandler();
            executor = new DefaultExecutor();
            if (executionDir != null) {
                executor.setWorkingDirectory(executionDir.toFile());
            }
            watchdog = new ExecuteWatchdog(timeoutLimit * 1000);
            executor.setWatchdog(watchdog);
            outStream = new ByteArrayOutputStream();
            errStream = new ByteArrayOutputStream();
            PumpStreamHandler streamHandler = new PumpStreamHandler(outStream, errStream);
            executor.setStreamHandler(streamHandler);
            try {
                executor.execute(cmdLine, resultHandler);
            }
            catch (IOException e) {
                return Outputs.failure(cmdLine, "Exception starting process");
            }
            exitValue = -1;
            try {
                resultHandler.waitFor();
                exitValue = resultHandler.getExitValue();
            }
            catch (InterruptedException e) {
                if (watchdog.killedProcess()) break block11;
                return Outputs.failure(cmdLine, "Process was interrupted while waiting.");
            }
        }
        boolean timedOut = executor.isFailure(exitValue) && watchdog.killedProcess();
        try {
            stdOutputString = outStream.toString();
        }
        catch (RuntimeException e) {
            return Outputs.failure(cmdLine, "Exception getting process standard output");
        }
        try {
            errOutputString = errStream.toString();
        }
        catch (RuntimeException e) {
            return Outputs.failure(cmdLine, "Exception getting process error output");
        }
        if (timedOut) {
            return Outputs.failure(cmdLine, "Process timed out after " + timeoutLimit + " seconds.");
        }
        return new Outputs(cmdLine, exitValue, stdOutputString, errOutputString);
    }

    private static @SignatureUnknown Map<@SignatureUnknown String, @SignatureUnknown String> normalizeJUnitOutput(@SignatureUnknown String input) {
        BufferedReader bufReader = new BufferedReader(new StringReader(input));
        String methodName = null;
        HashMap<String, String> resultMap = new HashMap<String, String>();
        StringBuilder result = new StringBuilder();
        int index = 1;
        try {
            String line;
            while ((line = bufReader.readLine()) != null) {
                String indexStr = index + ") ";
                if (line.startsWith(indexStr)) {
                    if (methodName != null) {
                        resultMap.put(methodName, result.toString());
                        result.setLength(0);
                    }
                    methodName = line;
                    ++index;
                    continue;
                }
                if (line.isEmpty()) {
                    resultMap.put(methodName, result.toString());
                    break;
                }
                if (methodName == null) continue;
                int lParenIndex = line.indexOf(40);
                if (lParenIndex >= 0) {
                    line = line.substring(0, lParenIndex);
                }
                result.append(line).append(Globals.lineSep);
            }
            bufReader.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return resultMap;
    }

    public static void writeToFile(@SignatureUnknown CompilationUnit compilationUnit, @SignatureUnknown Path file) throws @SignatureUnknown IOException {
        try (BufferedWriter bw = Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]);){
            bw.write(compilationUnit.toString());
        }
    }

    private static void addImport(@SignatureUnknown CompilationUnit compilationUnit, @SignatureUnknown String importName) {
        String importStr = "import " + importName + ";";
        ParseResult<ImportDeclaration> parseImportDeclaration = javaParser.parseImport(importStr);
        if (!parseImportDeclaration.isSuccessful()) {
            throw new RandoopBug("Error parsing import: " + importName);
        }
        ImportDeclaration importDeclaration = parseImportDeclaration.getResult().get();
        NodeList<ImportDeclaration> importDeclarations = compilationUnit.getImports();
        for (ImportDeclaration im : importDeclarations) {
            String currImportStr = im.toString().trim();
            if (importStr.equals(currImportStr)) {
                return;
            }
            int lastSeparator = importName.lastIndexOf(46);
            if (lastSeparator < 0) continue;
            String wildcardName = importName.substring(0, lastSeparator);
            String wildcardImportStr = "import " + wildcardName + ".*;";
            if (!wildcardImportStr.equals(currImportStr)) continue;
            return;
        }
        importDeclarations.add(importDeclaration);
        compilationUnit.setImports(importDeclarations);
    }

    private static void sortImports(@SignatureUnknown CompilationUnit compilationUnit) {
        NodeList<ImportDeclaration> imports = compilationUnit.getImports();
        Collections.sort(imports, importDeclarationComparator);
        compilationUnit.setImports(imports);
    }

    private static @SignatureUnknown int getFileLength(@SignatureUnknown Path file) throws @SignatureUnknown IOException {
        int lines = 0;
        try (BufferedReader reader = Files.newBufferedReader(file, StandardCharsets.UTF_8);){
            while (reader.readLine() != null) {
                ++lines;
            }
        }
        return lines;
    }

    private static void cleanUp(@SignatureUnknown Path outputFile, @SignatureUnknown boolean verboseOutput) {
        System.out.println("Minimizing complete.");
        String outputClassFileStr = FilenameUtils.removeExtension(outputFile.toAbsolutePath().toString()).concat(".class");
        Path outputClassFile = Paths.get(outputClassFileStr, new String[0]);
        try {
            boolean success = Files.deleteIfExists(outputClassFile);
            if (verboseOutput && success) {
                System.out.println("Minimizer cleanup: Removed .class file.");
            }
        }
        catch (IOException e) {
            System.err.println("IOException when cleaning up .class file.");
        }
    }

    private static @SignatureUnknown int getNumberOfTestMethods(@SignatureUnknown CompilationUnit compilationUnit) {
        int numberOfTestMethods = 0;
        for (TypeDeclaration<?> type : compilationUnit.getTypes()) {
            for (BodyDeclaration<?> member : type.getMembers()) {
                MethodDeclaration method;
                if (!(member instanceof MethodDeclaration) || !Minimize.isTestMethod(method = (MethodDeclaration)member)) continue;
                ++numberOfTestMethods;
            }
        }
        return numberOfTestMethods;
    }

    private static void printProgress(@SignatureUnknown int currentTestIndex, @SignatureUnknown int totalTests, @SignatureUnknown SimpleName testName) {
        System.out.println(currentTestIndex + "/" + totalTests + " tests minimized, Minimized method: " + testName);
    }

    private static void getOrphanCommentsBeforeThisChildNode(@SignatureUnknown Node node, @SignatureUnknown List<@SignatureUnknown Comment> result) {
        int i;
        if (node instanceof Comment) {
            return;
        }
        Node parent = node.getParentNode().orElse(null);
        if (parent == null) {
            return;
        }
        LinkedList<Node> everything = new LinkedList<Node>(parent.getChildNodes());
        PositionUtils.sortByBeginPosition(everything);
        int positionOfTheChild = -1;
        for (int i2 = 0; i2 < everything.size(); ++i2) {
            if (everything.get(i2) != node) continue;
            positionOfTheChild = i2;
        }
        if (positionOfTheChild == -1) {
            throw new AssertionError((Object)"I am not a child of my parent.");
        }
        int positionOfPreviousChild = -1;
        for (i = positionOfTheChild - 1; i >= 0 && positionOfPreviousChild == -1; --i) {
            if (everything.get(i) instanceof Comment) continue;
            positionOfPreviousChild = i;
        }
        for (i = positionOfPreviousChild + 1; i < positionOfTheChild; ++i) {
            Node nodeToPrint = (Node)everything.get(i);
            if (!(nodeToPrint instanceof Comment)) {
                throw new RuntimeException("Expected comment, instead " + nodeToPrint.getClass() + ". Position of previous child: " + positionOfPreviousChild + ", position of child " + positionOfTheChild);
            }
            result.add((Comment)nodeToPrint);
        }
    }

    static {
        minimizetimeout = 600;
        testsuitetimeout = 30;
        verboseminimizer = false;
        javaParser = new JavaParser();
        PATH_SEPARATOR = System.getProperty("path.separator");
        classOrInterfaceTypeComparator = new ClassOrInterfaceTypeComparator();
        importDeclarationComparator = new ImportDeclarationComparator();
    }

    public static class Outputs {
        public final @SignatureUnknown String command;
        public final @SignatureUnknown int exitValue;
        public final @SignatureUnknown String stdout;
        public final @SignatureUnknown String errout;

        Outputs(@SignatureUnknown String command, @SignatureUnknown int exitValue, @SignatureUnknown String stdout, @SignatureUnknown String errout) {
            this.command = command;
            this.exitValue = exitValue;
            this.stdout = stdout;
            this.errout = errout;
        }

        Outputs(@SignatureUnknown CommandLine command, @SignatureUnknown int exitValue, @SignatureUnknown String stdout, @SignatureUnknown String errout) {
            this(command.toString(), exitValue, stdout, errout);
        }

        static @SignatureUnknown Outputs failure(@SignatureUnknown CommandLine command, @SignatureUnknown String errout) {
            return new Outputs(command.toString(), 1, "", errout);
        }

        public @SignatureUnknown boolean isSuccess() {
            return this.exitValue == 0;
        }

        public @SignatureUnknown boolean isFailure() {
            return !this.isSuccess();
        }

        public @SignatureUnknown String diagnostics() {
            return String.join((CharSequence)Globals.lineSep, "command: " + this.command, "exit status: " + this.exitValue + "  " + (this.isSuccess() ? "(success)" : "(failure)"), "standard output: ", this.stdout, "error output: ", this.errout);
        }
    }

    private static class ImportDeclarationComparator
    implements Comparator<ImportDeclaration> {
        private ImportDeclarationComparator() {
        }

        @Override
        public @SignatureUnknown int compare(@SignatureUnknown ImportDeclaration o1, @SignatureUnknown ImportDeclaration o2) {
            return o1.getName().toString().compareTo(o2.getName().toString());
        }
    }

    private static class ClassOrInterfaceTypeComparator
    implements Comparator<ClassOrInterfaceType> {
        private ClassOrInterfaceTypeComparator() {
        }

        @Override
        public @SignatureUnknown int compare(@SignatureUnknown ClassOrInterfaceType o1, @SignatureUnknown ClassOrInterfaceType o2) {
            return o1.toString().compareTo(o2.toString());
        }
    }
}

