/*
 * Decompiled with CFR 0.152.
 */
package randoop.main;

import coveredclass.org.checkerframework.checker.nullness.qual.Nullable;
import coveredclass.org.checkerframework.checker.signature.qual.BinaryName;
import coveredclass.org.checkerframework.checker.signature.qual.ClassGetName;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.plumelib.options.Option;
import org.plumelib.options.OptionGroup;
import org.plumelib.options.Options;
import org.plumelib.options.Unpublicized;
import org.plumelib.reflection.ReflectionPlume;
import org.plumelib.reflection.Signatures;
import org.plumelib.util.EntryReader;
import org.plumelib.util.FileWriterWithName;
import randoop.Globals;
import randoop.main.CommandHandler;
import randoop.main.RandoopUsageError;
import randoop.reflection.VisibilityPredicate;
import randoop.util.ReflectionExecutor;

public abstract class GenInputsAbstract
extends CommandHandler {
    @OptionGroup(value="Code under test:  which classes and members may be used by a test")
    @Option(value="A jarfile, all of whose classes should be tested")
    public static @SignatureUnknown List<@SignatureUnknown Path> testjar = new ArrayList<Path>();
    @Option(value="File that lists classes under test")
    public static @SignatureUnknown Path classlist = null;
    @Option(value="Do not test classes that match regular expression <string>")
    public static @SignatureUnknown List<@SignatureUnknown Pattern> omit_classes = new ArrayList<Pattern>();
    @Option(value="File containing regular expressions for methods to omit")
    public static @SignatureUnknown List<@SignatureUnknown Path> omit_classes_file = null;
    @Option(value="The binary name of a class under test")
    public static @SignatureUnknown List<@BinaryName String> testclass = new ArrayList<String>();
    @Option(value="File that lists methods under test")
    public static @SignatureUnknown Path methodlist = null;
    @Option(value="Do not call methods that match regular expression <string>")
    public static @SignatureUnknown List<@SignatureUnknown Pattern> omit_methods = new ArrayList<Pattern>();
    @Unpublicized
    @Option(value="Do not call methods that match regular expression <string>")
    public static @SignatureUnknown List<@SignatureUnknown Pattern> omitmethods = null;
    @Option(value="File containing regular expressions for methods to omit")
    public static @SignatureUnknown List<@SignatureUnknown Path> omit_methods_file = null;
    @Unpublicized
    @Option(value="File containing regular expressions for methods to omit")
    public static @SignatureUnknown List<@SignatureUnknown Path> omitmethods_file = null;
    @Unpublicized
    @Option(value="Don't use the default omit-methods value")
    public static @SignatureUnknown boolean omit_methods_no_defaults = false;
    @Unpublicized
    @Option(value="Don't use the default omit-classes value")
    public static @SignatureUnknown boolean omit_classes_no_defaults = false;
    @Unpublicized
    @Option(value="Don't omit methods that are replaced by the replacecall agent")
    public static @SignatureUnknown boolean dont_omit_replaced_methods = false;
    @Option(value="Omit field from generated tests")
    public static @SignatureUnknown List<@SignatureUnknown String> omit_field = null;
    @Option(value="File containing field names to omit from generated tests")
    public static @SignatureUnknown Path omit_field_file = null;
    @Unpublicized
    @Option(value="File containing field names to omit from generated tests")
    public static @SignatureUnknown Path omit_field_list = null;
    @Option(value="Only use public members in tests")
    public static @SignatureUnknown boolean only_test_public_members = false;
    @Option(value="Ignore class names specified by user that cannot be found")
    public static @SignatureUnknown boolean silently_ignore_bad_class_names = false;
    @Unpublicized
    @Option(value="Allow Randoop to fail on any error during test generation")
    public static @SignatureUnknown boolean fail_on_generation_error = false;
    @Option(value="What to do if a flaky test is generated")
    public static @SignatureUnknown FlakyTestAction flaky_test_behavior = FlakyTestAction.OUTPUT;
    @Option(value="Number of suspected nondeterministic methods to print")
    public static @SignatureUnknown int nondeterministic_methods_to_output = 10;
    @OptionGroup(value="Which tests to output")
    @Option(value="Whether to output error-revealing tests")
    public static @SignatureUnknown boolean no_error_revealing_tests = false;
    @Option(value="Whether to output regression tests")
    public static @SignatureUnknown boolean no_regression_tests = false;
    @Option(value="Whether to include assertions in regression tests")
    public static @SignatureUnknown boolean no_regression_assertions = false;
    @Option(value="Whether to check if test sequences are compilable")
    public static @SignatureUnknown boolean check_compilable = true;
    @Option(value="Classes that must occur in a test")
    public static @SignatureUnknown Pattern require_classname_in_test = null;
    @Option(value="File containing class names that tests must cover")
    public static @SignatureUnknown Path require_covered_classes = null;
    @Option(value="<boolean> to indicate automatic minimization of error-revealing tests")
    public static @SignatureUnknown boolean minimize_error_test = false;
    @OptionGroup(value="Test classification")
    @Option(value="Whether checked exception is an ERROR, EXPECTED or INVALID")
    public static @SignatureUnknown BehaviorType checked_exception = BehaviorType.EXPECTED;
    @Option(value="Whether unchecked exception is an ERROR, EXPECTED or INVALID")
    public static @SignatureUnknown BehaviorType unchecked_exception = BehaviorType.EXPECTED;
    @Option(value="Whether ConcurrentModificationException is an ERROR, EXPECTED or INVALID")
    public static @SignatureUnknown BehaviorType cm_exception = BehaviorType.INVALID;
    @Option(value="Whether NoClassDefFoundError is an ERROR, EXPECTED or INVALID")
    public static @SignatureUnknown BehaviorType ncdf_exception = BehaviorType.INVALID;
    @Option(value="Whether NullPointerException on null inputs is an ERROR, EXPECTED or INVALID")
    public static @SignatureUnknown BehaviorType npe_on_null_input = BehaviorType.EXPECTED;
    @Option(value="Whether NullPointerException on non-null inputs is an ERROR, EXPECTED or INVALID")
    public static @SignatureUnknown BehaviorType npe_on_non_null_input = BehaviorType.ERROR;
    @Option(value="Whether OutOfMemoryError is an ERROR, EXPECTED or INVALID")
    public static @SignatureUnknown BehaviorType oom_exception = BehaviorType.INVALID;
    @Option(value="Whether StackOverflowError is an ERROR, EXPECTED or INVALID")
    public static @SignatureUnknown BehaviorType sof_exception = BehaviorType.INVALID;
    @Option(value="JSON specifications for methods/constructors")
    public static @SignatureUnknown List<@SignatureUnknown Path> specifications = null;
    @Option(value="Use specifications for JDK classes to classify behaviors for methods/constructors")
    public static @SignatureUnknown boolean use_jdk_specifications = true;
    @Option(value="Terminate Randoop if specification condition is uncompilable")
    public static @SignatureUnknown boolean ignore_condition_compilation_error = false;
    @Option(value="Terminate Randoop if specification condition throws an exception")
    public static @SignatureUnknown boolean ignore_condition_exception = false;
    @Unpublicized
    @Option(value="Terminate Randoop if specification condition throws an exception")
    public static @SignatureUnknown boolean ignore_condition_exception_quiet = false;
    @OptionGroup(value="Side-effect-free methods")
    @Option(value="File containing side-effect-free methods")
    public static @SignatureUnknown Path side_effect_free_methods = null;
    @OptionGroup(value="Limiting test generation")
    @Option(value="Maximum number of seconds to spend generating tests")
    public static @SignatureUnknown int time_limit = 100;
    private static @SignatureUnknown int LIMIT_DEFAULT;
    @Option(value="Maximum number of attempts to generate a candidate test")
    public static @SignatureUnknown int attempted_limit;
    @Option(value="Maximum number of candidate tests generated")
    public static @SignatureUnknown int generated_limit;
    @Option(value="Maximum number of tests to ouput")
    public static @SignatureUnknown int output_limit;
    @Option(value="Do not generate tests with more than this many statements")
    public static @SignatureUnknown int maxsize;
    @Option(value="Stop after generating any error-revealing test")
    public static @SignatureUnknown boolean stop_on_error_test;
    @OptionGroup(value="Values used in tests")
    @Option(value="Use null as an input with the given frequency")
    public static @SignatureUnknown double null_ratio;
    @Option(value="Never use null as input to methods or constructors")
    public static @SignatureUnknown boolean forbid_null;
    @Option(value="A file containing literal values to be used as inputs to methods under test")
    public static @SignatureUnknown List<@SignatureUnknown String> literals_file;
    @Option(value="How to use literal values specified via --literals-file: ALL, PACKAGE, CLASS, or NONE")
    public static @SignatureUnknown ClassLiteralsMode literals_level;
    @Option(value="How to choose the next method to test")
    public static @SignatureUnknown MethodSelectionMode method_selection;
    @Unpublicized
    @Option(value="Output Bloodhound-related information such as method weights and coverage ratios")
    public static @SignatureUnknown boolean bloodhound_logging;
    @Unpublicized
    @Option(value="Specify how Bloodhound decides when to update coverage information")
    public static @SignatureUnknown BloodhoundCoverageUpdateMode bloodhound_update_mode;
    @Option(value="Maximum length of Strings in generated tests")
    public static @SignatureUnknown int string_maxlen;
    @OptionGroup(value="Varying the nature of generated tests")
    @Option(value="Reuse values with the given frequency")
    public static @SignatureUnknown double alias_ratio;
    @Option(value="How to choose tests for Randoop to extend")
    public static @SignatureUnknown InputSelectionMode input_selection;
    @Option(value="Clear the component set when it gets this big")
    public static @SignatureUnknown int clear;
    @Option(value="Clear the component set when Randoop uses this much memory")
    public static @SignatureUnknown long clear_memory;
    @OptionGroup(value="Outputting the JUnit tests")
    @Option(value="Maximum number of tests to write to each JUnit file")
    public static @SignatureUnknown int testsperfile;
    @Option(value="Base name of the JUnit file(s) containing error-revealing tests")
    public static @SignatureUnknown String error_test_basename;
    @Option(value="Base name of the JUnit file(s) containing regression tests")
    public static @SignatureUnknown String regression_test_basename;
    @Option(value="Name of the package for the generated JUnit files (optional)")
    public static @SignatureUnknown String junit_package_name;
    @Option(value="Filename for code to include in Before-annotated method of test classes")
    public static @SignatureUnknown String junit_before_each;
    @Option(value="Filename for code to include in After-annotated method of test classes")
    public static @SignatureUnknown String junit_after_each;
    @Option(value="Filename for code to include in BeforeClass-annotated method of test classes")
    public static @SignatureUnknown String junit_before_all;
    @Option(value="Filename for code to include in AfterClass-annotated method of test classes")
    public static @SignatureUnknown String junit_after_all;
    @Option(value="Name of the directory to which JUnit files should be written")
    public static @SignatureUnknown String junit_output_dir;
    @Option(value="Run Randoop but do not output JUnit tests")
    public static @SignatureUnknown boolean dont_output_tests;
    @Option(value="If true, use JUnit's reflective invocation; if false, use direct method calls")
    public static @SignatureUnknown boolean junit_reflection_allowed;
    @OptionGroup(value="Runtime environment")
    @Option(value="-D Specify system properties to be set; similar to <code>java -Dx=y</code>.")
    public static @SignatureUnknown List<@SignatureUnknown String> system_props;
    @Option(value="Maximum memory for JVM; will be passed with <code>-Xmx</code>.")
    public static @SignatureUnknown String jvm_max_memory;
    @Unpublicized
    @Option(value="Store all output to stdout and stderr in the ExecutionOutcome.")
    public static @SignatureUnknown boolean capture_output;
    @OptionGroup(value="Controlling randomness")
    @Option(value="The random seed to use in the generation process")
    public static @SignatureUnknown int randomseed;
    @Option(value="If true, Randoop is deterministic")
    public static @SignatureUnknown boolean deterministic;
    @OptionGroup(value="Logging, notifications, and troubleshooting Randoop")
    @Option(value="Run noisily: display information such as progress updates.")
    public static @SignatureUnknown boolean progressdisplay;
    public static @SignatureUnknown long PROGRESSINTERVALMILLIS_DEFAULT;
    @Option(value="Display progress message every <int> milliseconds. -1 means no display.")
    public static @SignatureUnknown long progressintervalmillis;
    @Option(value="Display progress message every <int> attempts to create a test; -1 means none")
    public static @SignatureUnknown long progressintervalsteps;
    @Option(value="Perform expensive internal checks (for Randoop debugging)")
    public static @SignatureUnknown boolean debug_checks;
    @Option(value="<filename> Log lots of information to this file")
    public static @SignatureUnknown FileWriterWithName log;
    @Option(value="<filename> Log each random selection to this file")
    public static @SignatureUnknown FileWriterWithName selection_log;
    @Option(value="<filename> Write operation usage counts to this file")
    public static @SignatureUnknown FileWriterWithName operation_history_log;
    @Option(value="Display source if a generated test contains a compilation error.")
    public static @SignatureUnknown boolean print_non_compiling_file;
    @Unpublicized
    @Option(value="Create sequences but never execute them")
    public static @SignatureUnknown boolean dontexecute;
    @OptionGroup(value="Advanced extension points")
    @Option(value="Install the given runtime visitor")
    public static @SignatureUnknown List<@ClassGetName String> visitor;
    @OptionGroup(value="Pacheco thesis", unpublicized=true)
    @Unpublicized
    @Option(value="Use heuristic that may randomly repeat a method call several times")
    public static @SignatureUnknown boolean repeat_heuristic;

    protected GenInputsAbstract(@SignatureUnknown String command, @SignatureUnknown String pitch, @SignatureUnknown String commandGrammar, @SignatureUnknown String where, @SignatureUnknown String summary, @SignatureUnknown List<@SignatureUnknown String> notes, @SignatureUnknown String input, @SignatureUnknown String output, @SignatureUnknown String example, @SignatureUnknown Options options) {
        super(command, pitch, commandGrammar, where, summary, notes, input, output, example, options);
    }

    public void checkOptionsValid() {
        if (alias_ratio < 0.0 || alias_ratio > 1.0) {
            throw new RandoopUsageError("--alias-ratio must be between 0 and 1, inclusive.");
        }
        if (null_ratio < 0.0 || null_ratio > 1.0) {
            throw new RandoopUsageError("--null-ratio must be between 0 and 1, inclusive.");
        }
        if (maxsize <= 0) {
            throw new RandoopUsageError("Maximum sequence size --maxsize must be greater than zero but was " + maxsize);
        }
        if (!literals_file.isEmpty() && literals_level == ClassLiteralsMode.NONE) {
            throw new RandoopUsageError("Invalid parameter combination: specified a class literal file and --use-class-literals=NONE");
        }
        if (deterministic && ReflectionExecutor.usethreads) {
            throw new RandoopUsageError("Invalid parameter combination: --deterministic with --usethreads");
        }
        if (deterministic && time_limit != 0) {
            throw new RandoopUsageError("Invalid parameter combination: --deterministic without --time-limit=0");
        }
        if (deterministic && progressintervalmillis != -1L) {
            if (progressintervalmillis == PROGRESSINTERVALMILLIS_DEFAULT) {
                progressintervalmillis = -1L;
            } else {
                throw new RandoopUsageError("Invalid parameter combination: --deterministic with --progressintervalmillis");
            }
        }
        if (deterministic && method_selection == MethodSelectionMode.BLOODHOUND && bloodhound_update_mode == BloodhoundCoverageUpdateMode.TIME) {
            throw new RandoopUsageError("Invalid parameter combination: --deterministic with --bloodhound-update-mode=time");
        }
        if (ReflectionExecutor.call_timeout != ReflectionExecutor.CALL_TIMEOUT_DEFAULT && !ReflectionExecutor.usethreads) {
            throw new RandoopUsageError("Invalid parameter combination: --call-timeout without --usethreads");
        }
        if (time_limit == 0 && attempted_limit >= LIMIT_DEFAULT && generated_limit >= LIMIT_DEFAULT && output_limit >= LIMIT_DEFAULT) {
            throw new RandoopUsageError(String.format("Unlikely parameter combination: --time-limit=0 and high other limits:%n --attempted-limit=%s --generated-limit=%s --output-limit=%s", attempted_limit, generated_limit, output_limit));
        }
        if (testclass.isEmpty() && testjar.isEmpty() && classlist == null && methodlist == null) {
            throw new RandoopUsageError("You must specify some classes or methods to test." + Globals.lineSep + "Use the --testclass, --testjar, --classlist, or --methodlist options.");
        }
    }

    private static @SignatureUnknown boolean shouldOmitClass(@SignatureUnknown String classname) {
        for (Pattern p : omit_classes) {
            if (!p.matcher(classname).find()) continue;
            return true;
        }
        return false;
    }

    public static @SignatureUnknown Set<@ClassGetName String> getClassnamesFromArgs(@SignatureUnknown VisibilityPredicate visibility) {
        Set<@ClassGetName String> classnames = GenInputsAbstract.getClassNamesFromFile(classlist);
        for (Path jarFile : testjar) {
            classnames.addAll(GenInputsAbstract.getClassnamesFromJarFile(jarFile, visibility));
        }
        for (String classname : testclass) {
            if (!Signatures.isClassGetName(classname)) {
                throw new RandoopUsageError("Illegal argument --testclass=" + classname + ", should be a class name");
            }
            classnames.add(classname);
        }
        Iterator<String> itor = classnames.iterator();
        while (itor.hasNext()) {
            String classname;
            classname = itor.next();
            if (!GenInputsAbstract.shouldOmitClass(classname)) continue;
            itor.remove();
        }
        return classnames;
    }

    public static @SignatureUnknown Set<@ClassGetName String> getClassnamesFromJarFile(@SignatureUnknown Path jarFile, @SignatureUnknown VisibilityPredicate visibility) {
        try {
            TreeSet<@ClassGetName String> classNames = new TreeSet<String>();
            ZipInputStream zip = new ZipInputStream(new FileInputStream(jarFile.toString()));
            ZipEntry entry = zip.getNextEntry();
            while (entry != null) {
                block17: {
                    String classFileName;
                    String ifClassName;
                    String className;
                    if (!entry.isDirectory() && entry.getName().endsWith(".class") && !GenInputsAbstract.shouldOmitClass(className = Signatures.internalFormToClassGetName(ifClassName = (classFileName = entry.getName()).substring(0, classFileName.length() - ".class".length())))) {
                        Class<?> c;
                        try {
                            c = Class.forName(className);
                        }
                        catch (ClassNotFoundException e) {
                            throw new RandoopUsageError(String.format("%s was read from %s but was not found on classpath.  Ensure that %s is on the classpath.  Classpath:%n%s", className, jarFile, jarFile, ReflectionPlume.classpathToString()));
                        }
                        catch (UnsatisfiedLinkError e) {
                            System.out.printf("Ignoring %s which was read from %s but could not be loaded: %s%n", className, jarFile, e);
                            break block17;
                        }
                        catch (ExceptionInInitializerError e) {
                            System.out.printf("Ignoring %s which was read from %s but could not be initialized: %s%n", className, jarFile, e);
                            break block17;
                        }
                        catch (NoClassDefFoundError e) {
                            String eMsg = e.getMessage();
                            if (eMsg.startsWith("Could not initialize class ")) {
                                if (eMsg.endsWith(": " + className)) {
                                    System.out.printf("Ignoring %s which was read from %s but could not be initialized: %s%n", className, jarFile, e);
                                } else {
                                    System.out.printf("Ignoring %s which was read from %s but a class could not be initialized: %s%n", className, jarFile, e);
                                }
                            } else if (className.equals(e.getMessage())) {
                                System.out.printf("Ignoring %s which was read from %s but could not be loaded: %s%n", className, jarFile, e);
                            } else {
                                System.out.printf("Ignoring %s which was read from %s but a class could not be loaded: %s%n", className, jarFile, e);
                            }
                            break block17;
                        }
                        catch (Error e) {
                            System.out.printf("Ignoring %s which was read from %s but could not be loaded: %s%n", className, jarFile, e);
                            break block17;
                        }
                        if (visibility.isVisible(c)) {
                            classNames.add(className);
                        }
                    }
                }
                entry = zip.getNextEntry();
            }
            return classNames;
        }
        catch (IOException e) {
            String message = String.format("Error while reading jar file %s: %s%n", jarFile, e.getMessage());
            throw new RandoopUsageError(message, e);
        }
    }

    public static @SignatureUnknown Set<@ClassGetName String> getClassNamesFromFile(@SignatureUnknown Path file) {
        LinkedHashSet<@ClassGetName String> result = new LinkedHashSet<String>();
        for (String line : GenInputsAbstract.getStringSetFromFile(file, "class names")) {
            if (!Signatures.isClassGetName(line)) {
                throw new RandoopUsageError("Illegal value \"" + line + "\" in " + file + ", should be a class name in the format of Class.GetName()");
            }
            result.add(line);
        }
        return result;
    }

    public static @SignatureUnknown Set<@SignatureUnknown String> getStringSetFromFile(@SignatureUnknown Path listFile, @SignatureUnknown String fileDescription) {
        return GenInputsAbstract.getStringSetFromFile(listFile, fileDescription, "^#.*", null);
    }

    public static @SignatureUnknown Set<@SignatureUnknown String> getStringSetFromFile(@Nullable @SignatureUnknown Path listFile, @SignatureUnknown String fileDescription, @SignatureUnknown String commentRegex, @SignatureUnknown String includeRegex) {
        LinkedHashSet<String> elementSet = new LinkedHashSet<String>();
        if (listFile != null) {
            try (EntryReader er = new EntryReader(listFile.toFile(), commentRegex, includeRegex);){
                for (String line : er) {
                    String trimmed = line.trim();
                    if (trimmed.isEmpty()) continue;
                    elementSet.add(trimmed);
                }
            }
            catch (IOException e) {
                String message = String.format("Error while reading %s file %s: %s%n", fileDescription, listFile, e.getMessage());
                throw new RandoopUsageError(message, e);
            }
        }
        return elementSet;
    }

    static {
        attempted_limit = LIMIT_DEFAULT = 100000000;
        generated_limit = LIMIT_DEFAULT;
        output_limit = LIMIT_DEFAULT;
        maxsize = 100;
        stop_on_error_test = false;
        null_ratio = 0.05;
        forbid_null = false;
        literals_file = new ArrayList<String>();
        literals_level = ClassLiteralsMode.CLASS;
        method_selection = MethodSelectionMode.UNIFORM;
        bloodhound_logging = false;
        bloodhound_update_mode = BloodhoundCoverageUpdateMode.TIME;
        string_maxlen = 1000;
        alias_ratio = 0.0;
        input_selection = InputSelectionMode.UNIFORM;
        clear = 100000000;
        clear_memory = 4000000000L;
        testsperfile = 500;
        error_test_basename = "ErrorTest";
        regression_test_basename = "RegressionTest";
        junit_before_each = null;
        junit_after_each = null;
        junit_before_all = null;
        junit_after_all = null;
        junit_output_dir = null;
        dont_output_tests = false;
        junit_reflection_allowed = true;
        system_props = new ArrayList<String>();
        jvm_max_memory = "3000m";
        capture_output = false;
        randomseed = 0;
        deterministic = false;
        progressdisplay = true;
        progressintervalmillis = PROGRESSINTERVALMILLIS_DEFAULT = 60000L;
        progressintervalsteps = 1000L;
        debug_checks = false;
        log = null;
        selection_log = null;
        operation_history_log = null;
        print_non_compiling_file = false;
        dontexecute = false;
        visitor = new ArrayList<String>();
        repeat_heuristic = false;
    }

    public static enum InputSelectionMode {
        SMALL_TESTS,
        UNIFORM;

    }

    public static enum BloodhoundCoverageUpdateMode {
        TIME,
        INVOCATIONS;

    }

    public static enum MethodSelectionMode {
        UNIFORM,
        BLOODHOUND;

    }

    public static enum ClassLiteralsMode {
        NONE,
        CLASS,
        PACKAGE,
        ALL;

    }

    public static class Limits {
        public @SignatureUnknown int time_limit_millis;
        public @SignatureUnknown int attempted_limit;
        public @SignatureUnknown int generated_limit;
        public @SignatureUnknown int output_limit;

        public Limits() {
            this(time_limit, attempted_limit, generated_limit, output_limit);
        }

        public Limits(@SignatureUnknown int time_limit, @SignatureUnknown int attempted_limit, @SignatureUnknown int generated_limit, @SignatureUnknown int output_limit) {
            this.time_limit_millis = time_limit * 1000;
            this.attempted_limit = attempted_limit;
            this.generated_limit = generated_limit;
            this.output_limit = output_limit;
        }
    }

    public static enum BehaviorType {
        ERROR,
        EXPECTED,
        INVALID;

    }

    public static enum FlakyTestAction {
        HALT,
        DISCARD,
        OUTPUT;

    }
}

