/*
 * Decompiled with CFR 0.152.
 */
package randoop.main;

import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import java.util.ConcurrentModificationException;
import randoop.ExceptionalExecution;
import randoop.main.GenInputsAbstract;
import randoop.sequence.ExecutableSequence;
import randoop.util.TimeoutExceededException;

public class ExceptionBehaviorClassifier {
    private ExceptionBehaviorClassifier() {
        throw new Error("Do not instantiate");
    }

    public static @SignatureUnknown GenInputsAbstract.BehaviorType classify(@SignatureUnknown ExceptionalExecution exec, @SignatureUnknown ExecutableSequence eseq) {
        return ExceptionBehaviorClassifier.classify(exec.getException(), eseq);
    }

    public static @SignatureUnknown GenInputsAbstract.BehaviorType classify(@SignatureUnknown Throwable t, @SignatureUnknown ExecutableSequence eseq) {
        if (t instanceof RuntimeException || t instanceof Error) {
            if (t instanceof ConcurrentModificationException) {
                return GenInputsAbstract.cm_exception;
            }
            if (t instanceof NoClassDefFoundError) {
                return GenInputsAbstract.ncdf_exception;
            }
            if (t instanceof NullPointerException) {
                if (eseq.hasNullInput()) {
                    return GenInputsAbstract.npe_on_null_input;
                }
                return GenInputsAbstract.npe_on_non_null_input;
            }
            if (t instanceof OutOfMemoryError) {
                return GenInputsAbstract.oom_exception;
            }
            if (t instanceof StackOverflowError) {
                return GenInputsAbstract.sof_exception;
            }
            if (t instanceof TimeoutExceededException) {
                return GenInputsAbstract.BehaviorType.INVALID;
            }
            if (t instanceof AssertionError) {
                return GenInputsAbstract.BehaviorType.ERROR;
            }
            return GenInputsAbstract.unchecked_exception;
        }
        return GenInputsAbstract.checked_exception;
    }
}

