/*
 * Decompiled with CFR 0.152.
 */
package randoop.instrument;

import coveredclass.org.apache.bcel.classfile.ClassParser;
import coveredclass.org.apache.bcel.classfile.JavaClass;
import coveredclass.org.apache.bcel.classfile.Method;
import coveredclass.org.apache.bcel.generic.ObjectType;
import coveredclass.org.checkerframework.checker.signature.qual.BinaryName;
import coveredclass.org.checkerframework.checker.signature.qual.DotSeparatedIdentifiers;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.instrument.IllegalClassFormatException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.plumelib.reflection.Signatures;
import org.plumelib.util.EntryReader;
import randoop.instrument.MethodSignature;
import randoop.instrument.ReplaceCallAgent;
import randoop.instrument.ReplacementFileException;

public class ReplacementFileReader {
    public static final @SignatureUnknown String ID_STRING = "\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*";
    public static final @SignatureUnknown String DOT_DELIMITED_IDS = "\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*(?:\\.\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)*";
    private static final @SignatureUnknown String SIGNATURE_STRING = "\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*(?:\\.\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)*(?:\\.<init>)?\\([^)]*\\)";
    private static final @SignatureUnknown Pattern SIGNATURE_LINE = Pattern.compile("(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*(?:\\.\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)*(?:\\.<init>)?\\([^)]*\\))[ \\t]+(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*(?:\\.\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)*(?:\\.<init>)?\\([^)]*\\))");
    private static final @SignatureUnknown Pattern PACKAGE_OR_CLASS_LINE = Pattern.compile("(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*(?:\\.\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)*)[ \\t]+(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*(?:\\.\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)*)");
    private static @SignatureUnknown Map<@SignatureUnknown String, @SignatureUnknown JavaClass> javaClasses = new ConcurrentHashMap<String, JavaClass>();

    static @SignatureUnknown HashMap<@SignatureUnknown MethodSignature, @SignatureUnknown MethodSignature> readReplacements(@SignatureUnknown Path replacementFile) throws @SignatureUnknown IOException, @SignatureUnknown ReplacementFileException {
        return ReplacementFileReader.readReplacements(Files.newBufferedReader(replacementFile, StandardCharsets.UTF_8), replacementFile.toString());
    }

    static @SignatureUnknown HashMap<@SignatureUnknown MethodSignature, @SignatureUnknown MethodSignature> readReplacements(@SignatureUnknown Reader in, @SignatureUnknown String filename) throws @SignatureUnknown ReplacementFileException, @SignatureUnknown IOException {
        HashMap<MethodSignature, MethodSignature> replacementMap = new HashMap<MethodSignature, MethodSignature>();
        try (EntryReader reader = new EntryReader(in, filename, "//.*$", null);){
            for (String line : reader) {
                String trimmed = line.trim();
                if (trimmed.isEmpty()) continue;
                Matcher signatureLineMatcher = SIGNATURE_LINE.matcher(line);
                if (signatureLineMatcher.matches()) {
                    try {
                        ReplacementFileReader.addMethodReplacement(replacementMap, signatureLineMatcher.group(1), signatureLineMatcher.group(2));
                        continue;
                    }
                    catch (ClassNotFoundException | NoSuchMethodException | IllegalClassFormatException | ReplacementException e) {
                        throw new ReplacementFileException(e.getMessage(), filename, reader.getLineNumber(), line);
                    }
                }
                Matcher packageOrClassLineMatcher = PACKAGE_OR_CLASS_LINE.matcher(line);
                if (packageOrClassLineMatcher.matches()) {
                    try {
                        @DotSeparatedIdentifiers String original = packageOrClassLineMatcher.group(1);
                        @DotSeparatedIdentifiers String replacement = packageOrClassLineMatcher.group(2);
                        ReplacementFileReader.addReplacementsForClassOrPackage(replacementMap, original, replacement);
                        continue;
                    }
                    catch (IOException | ClassNotFoundException | ReplacementException e) {
                        throw new ReplacementFileException(e.getMessage(), filename, reader.getLineNumber(), line);
                    }
                }
                String msg = "Error in replacement file: bad format";
                throw new ReplacementFileException(msg, filename, reader.getLineNumber(), line);
            }
        }
        return replacementMap;
    }

    private static void addMethodReplacement(@SignatureUnknown HashMap<@SignatureUnknown MethodSignature, @SignatureUnknown MethodSignature> replacementMap, @SignatureUnknown String originalSignature, @SignatureUnknown String replacementSignature) throws @SignatureUnknown ReplacementException, @SignatureUnknown ClassNotFoundException, @SignatureUnknown IllegalClassFormatException, @SignatureUnknown NoSuchMethodException {
        MethodSignature replacement;
        MethodSignature original;
        try {
            original = MethodSignature.of(originalSignature);
        }
        catch (IllegalArgumentException e) {
            throw new ReplacementException("Bad original signature", e);
        }
        original.toMethod();
        try {
            replacement = MethodSignature.of(replacementSignature);
        }
        catch (IllegalArgumentException e) {
            throw new ReplacementException("Bad replacement signature", e);
        }
        replacement.toMethod();
        ReplacementFileReader.addReplacement(replacementMap, original, replacement);
    }

    private static void addReplacement(@SignatureUnknown HashMap<@SignatureUnknown MethodSignature, @SignatureUnknown MethodSignature> replacementMap, @SignatureUnknown MethodSignature original, @SignatureUnknown MethodSignature replacement) throws @SignatureUnknown ReplacementException {
        if (replacementMap.get(original) != null) {
            String msg = String.format("Method %s already has replacement %s, trying to add another %s", original, replacementMap.get(original), replacement);
            throw new ReplacementException(msg);
        }
        replacementMap.put(original, replacement);
    }

    private static void addReplacementsForClassOrPackage(@SignatureUnknown HashMap<@SignatureUnknown MethodSignature, @SignatureUnknown MethodSignature> replacementMap, @DotSeparatedIdentifiers String original, @DotSeparatedIdentifiers String replacement) throws @SignatureUnknown ReplacementException, @SignatureUnknown IOException, @SignatureUnknown ClassNotFoundException {
        String replacementClassPath = replacement.replace('.', '/') + ".class";
        URL resource = ClassLoader.getSystemResource(replacementClassPath);
        if (resource != null) {
            ReplacementFileReader.addReplacementsForClass(replacementMap, original, replacement);
        } else {
            ReplacementFileReader.addReplacementsForPackage(replacementMap, original, replacement);
        }
    }

    private static void addReplacementsForClass(@SignatureUnknown HashMap<@SignatureUnknown MethodSignature, @SignatureUnknown MethodSignature> replacementMap, @DotSeparatedIdentifiers String originalPackage, @DotSeparatedIdentifiers String replacementPackage, @BinaryName String classname) throws @SignatureUnknown ClassNotFoundException, @SignatureUnknown ReplacementException {
        ReplacementFileReader.addReplacementsForClass(replacementMap, Signatures.addPackage(originalPackage, classname), Signatures.addPackage(replacementPackage, classname));
    }

    private static void addReplacementsForClass(@SignatureUnknown HashMap<@SignatureUnknown MethodSignature, @SignatureUnknown MethodSignature> replacementMap, @BinaryName String originalClassname, @BinaryName String replacementClassname) throws @SignatureUnknown ClassNotFoundException, @SignatureUnknown ReplacementException {
        JavaClass replacementJC = ReplacementFileReader.getJavaClassFromClassname(replacementClassname);
        if (replacementJC == null) {
            throw new ReplacementException("Replacement class not found: " + replacementClassname);
        }
        for (Method m3 : replacementJC.getMethods()) {
            if (m3.getName().equals("<init>") || m3.isPrivate()) continue;
            if (!m3.isStatic()) {
                String msg = String.format("Non-static non-private replacement method found: %s.%s", replacementClassname, m3.getName());
                throw new ReplacementException(msg);
            }
            MethodSignature replacement = MethodSignature.of(replacementClassname, m3);
            MethodSignature original = replacement.substituteClassname(originalClassname);
            if (original.exists()) {
                ReplacementFileReader.addReplacement(replacementMap, original, replacement);
                continue;
            }
            if (replacement.getParameterTypes().length > 0 && replacement.getParameterTypes()[0].equals(new ObjectType(originalClassname)) && (original = original.removeFirstParameter()).exists()) {
                ReplacementFileReader.addReplacement(replacementMap, original, replacement);
                continue;
            }
            String msg = String.format("Replacement method %s has no matching original in %s%n", replacement, originalClassname);
            throw new ReplacementException(msg);
        }
    }

    private static void addReplacementsForPackage(@SignatureUnknown HashMap<@SignatureUnknown MethodSignature, @SignatureUnknown MethodSignature> replacementMap, @DotSeparatedIdentifiers String originalPackage, @DotSeparatedIdentifiers String replacementPackage) throws @SignatureUnknown ReplacementException, @SignatureUnknown ClassNotFoundException {
        String replacementPackagePath;
        URL url;
        if (ReplaceCallAgent.debug) {
            System.err.println("javaVersion: " + System.getProperty("java.version"));
            System.err.println("javaHome: " + System.getProperty("java.home"));
            System.err.println("bootclasspath: " + System.getProperty("sun.boot.class.path"));
            System.err.println("classpath: " + System.getProperty("java.class.path"));
        }
        if ((url = ClassLoader.getSystemResource(replacementPackagePath = replacementPackage.replace('.', '/'))) == null) {
            String msg = String.format("No package for replacement %s found on classpath", replacementPackage);
            throw new ReplacementException(msg);
        }
        String protocol = url.getProtocol();
        if (protocol.equals("jar")) {
            String jarFilePath = ReplaceCallAgent.getJarPathFromURL(url);
            Path file = Paths.get(jarFilePath, new String[0]);
            try {
                JarFile jarFile = new JarFile(file.toFile());
                ReplacementFileReader.addReplacementsFromAllClassesOfPackage(replacementMap, originalPackage, replacementPackage, jarFile);
                return;
            }
            catch (IOException e) {
                throw new ReplacementException("Error reading jar file: " + file, e);
            }
        }
        if (protocol.equals("file")) {
            Path path = null;
            try {
                path = Paths.get(URLDecoder.decode(url.getPath(), "UTF-8"), new String[0]);
            }
            catch (Exception e) {
                throw new ReplacementException("Unable to extract Path from URL: " + url, e);
            }
            if (Files.exists(path, new LinkOption[0]) && Files.isDirectory(path, new LinkOption[0])) {
                ReplacementFileReader.addReplacementsForPackage(replacementMap, originalPackage, replacementPackage, path);
                return;
            }
        } else {
            throw new ReplacementException("URL protocol not 'file' or 'jar'");
        }
    }

    private static void addReplacementsForPackage(@SignatureUnknown HashMap<@SignatureUnknown MethodSignature, @SignatureUnknown MethodSignature> replacementMap, @DotSeparatedIdentifiers String originalPackage, @DotSeparatedIdentifiers String replacementPackage, @SignatureUnknown Path replacementDirectory) throws @SignatureUnknown ReplacementException, @SignatureUnknown ClassNotFoundException {
        for (File file : replacementDirectory.toFile().listFiles()) {
            String filename = file.getName();
            if (file.isFile()) {
                if (!filename.endsWith(".class")) continue;
                ReplacementFileReader.addReplacementsForClass(replacementMap, originalPackage, replacementPackage, Signatures.classfilenameToBaseName(filename));
                continue;
            }
            if (!file.isDirectory()) continue;
            @DotSeparatedIdentifiers String originalPackageRecurse = originalPackage + "." + filename;
            @DotSeparatedIdentifiers String replacementPackageRecurse = replacementPackage + "." + filename;
            ReplacementFileReader.addReplacementsForPackage(replacementMap, originalPackageRecurse, replacementPackageRecurse, file.toPath());
        }
    }

    private static void addReplacementsFromAllClassesOfPackage(@SignatureUnknown HashMap<@SignatureUnknown MethodSignature, @SignatureUnknown MethodSignature> replacementMap, @DotSeparatedIdentifiers String originalPackage, @DotSeparatedIdentifiers String replacementPackage, @SignatureUnknown JarFile jarFile) throws @SignatureUnknown ReplacementException, @SignatureUnknown ClassNotFoundException {
        String replacementPath = replacementPackage.replace('.', '/') + "/";
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String filename = entry.getName();
            if (!filename.endsWith(".class") || !filename.startsWith(replacementPath)) continue;
            ReplacementFileReader.addReplacementsForClass(replacementMap, originalPackage, replacementPackage, Signatures.classfilenameToBaseName(filename));
        }
    }

    protected static @SignatureUnknown JavaClass getJavaClassFromClassname(@SignatureUnknown String classname) throws @SignatureUnknown ReplacementException {
        JavaClass c = javaClasses.get(classname);
        if (c != null) {
            return c;
        }
        String classFilename = classname.replace('.', '/') + ".class";
        InputStream is = ClassLoader.getSystemResourceAsStream(classFilename);
        if (is == null) {
            return null;
        }
        try {
            ClassParser parser = new ClassParser(is, classname);
            c = parser.parse();
            javaClasses.put(classname, c);
            return c;
        }
        catch (Exception e) {
            if (ReplaceCallAgent.debug) {
                System.out.println("Problem in getJavaClassFromClassname:");
                e.printStackTrace(System.out);
            }
            throw new ReplacementException("Error reading class file: " + classFilename, e);
        }
    }

    private static class ReplacementException
    extends Throwable {
        ReplacementException(@SignatureUnknown String message) {
            super(message);
        }

        ReplacementException(@SignatureUnknown String message, @SignatureUnknown Throwable cause) {
            super(message, cause);
        }
    }
}

