/*
 * Decompiled with CFR 0.152.
 */
package randoop.instrument;

import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.instrument.Instrumentation;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import org.plumelib.options.Option;
import org.plumelib.options.Options;
import org.plumelib.util.EntryReader;
import org.plumelib.util.UtilPlume;
import randoop.MethodReplacements;
import randoop.instrument.CallReplacementTransformer;
import randoop.instrument.MethodSignature;
import randoop.instrument.ReplacementFileException;
import randoop.instrument.ReplacementFileReader;

public class ReplaceCallAgent {
    private static final @SignatureUnknown String AGENT_NAME = "replacecall";
    @Option(value="print debug information")
    public static @SignatureUnknown boolean debug = false;
    @Option(value="directory name where debug logs are written")
    public static @SignatureUnknown String debug_directory;
    static @SignatureUnknown Path debugPath;
    @Option(value="print progress information")
    public static @SignatureUnknown boolean verbose;
    @Option(value="file listing methods whose calls to replace by substitute methods")
    public static @SignatureUnknown Path replacement_file;
    @Option(value="file listing packages whose classes should not be transformed")
    public static @SignatureUnknown Path dont_transform;

    public static void premain(@SignatureUnknown String agentArgs, @SignatureUnknown Instrumentation instrumentation) throws @SignatureUnknown IOException {
        try {
            HashMap<MethodSignature, MethodSignature> replacementMap;
            String replacementPath;
            Options options;
            Object[] target_args;
            if (agentArgs != null && (target_args = (options = new Options(ReplaceCallAgent.class)).parse(true, Options.tokenize(agentArgs))).length > 0) {
                System.err.printf("Unexpected agent arguments %s%n", Arrays.toString(target_args));
                System.exit(1);
            }
            if (verbose) {
                System.out.format("In premain, agentargs ='%s', Instrumentation = '%s'%n", agentArgs, instrumentation);
            }
            debugPath = Paths.get("", new String[0]).toAbsolutePath().toAbsolutePath();
            if (debug && debug_directory != null && !debug_directory.isEmpty() && !Files.exists(debugPath = debugPath.resolve(debug_directory), new LinkOption[0])) {
                Files.createDirectory(debugPath, new FileAttribute[0]);
            }
            LinkedHashSet<String> excludedPackagePrefixes = new LinkedHashSet<String>();
            String exclusionFileName = "/default-load-exclusions.txt";
            InputStream inputStream = ReplaceCallAgent.class.getResourceAsStream(exclusionFileName);
            if (inputStream == null) {
                throw new BugInAgentException("Unable to find default package exclusion file.");
            }
            try {
                excludedPackagePrefixes.addAll(ReplaceCallAgent.loadExclusions(new InputStreamReader(inputStream), exclusionFileName));
            }
            catch (IOException e) {
                throw new BugInAgentException("Unable to read default package exclusion file: " + e.getMessage());
            }
            Path exclusionFilePath = null;
            if (dont_transform != null) {
                try {
                    excludedPackagePrefixes.addAll(ReplaceCallAgent.loadExclusions(Files.newBufferedReader(dont_transform, StandardCharsets.UTF_8), dont_transform.toString()));
                }
                catch (IOException e) {
                    System.err.format("Error reading package exclusion file %s:%n %s%n", dont_transform, e.getMessage());
                    System.exit(1);
                }
                exclusionFilePath = dont_transform;
            }
            if ((inputStream = ReplaceCallAgent.class.getResourceAsStream(replacementPath = "/default-replacements.txt")) == null) {
                throw new BugInAgentException("Unable to open default replacements file.");
            }
            try {
                replacementMap = ReplacementFileReader.readReplacements(new InputStreamReader(inputStream), replacementPath);
            }
            catch (ReplacementFileException e) {
                throw new BugInAgentException("Error reading default replacement file. " + e.getMessage());
            }
            Path replacementFilePath = null;
            if (replacement_file != null) {
                try {
                    replacementMap.putAll(ReplacementFileReader.readReplacements(replacement_file));
                }
                catch (Throwable e) {
                    System.err.printf("Error reading replacement file %s:%n  %s%n", replacement_file, e.getMessage());
                    System.exit(1);
                }
                replacementFilePath = replacement_file;
            }
            MethodReplacements.setAgentPath(ReplaceCallAgent.getAgentPath());
            MethodReplacements.setAgentArgs(ReplaceCallAgent.createAgentArgs(replacementFilePath, exclusionFilePath));
            if (debug) {
                // empty if block
            }
            ArrayList<String> signatureList = new ArrayList<String>();
            for (MethodSignature def : replacementMap.keySet()) {
                signatureList.add(def.toString());
            }
            MethodReplacements.setReplacedMethods(signatureList);
            CallReplacementTransformer transformer = new CallReplacementTransformer(replacementMap, excludedPackagePrefixes);
            transformer.addMapFileShutdownHook();
            instrumentation.addTransformer(transformer);
        }
        catch (BugInAgentException e) {
            System.err.println("Error in replacecall agent: " + e.getMessage());
            System.err.println("For problems with the default replacements file, make sure that the replacecall.jar file is on the bootclasspath.");
            System.err.println("Otherwise, please report at https://github.com/randoop/randoop/issues ,");
            System.err.println("providing the information requested at https://randoop.github.io/randoop/manual/index.html#bug-reporting .");
            System.exit(1);
        }
        catch (Throwable e) {
            System.err.println("Unexpected exception thrown by replacecall agent: " + e.getMessage());
            System.err.println("Please report at https://github.com/randoop/randoop/issues ,");
            System.err.println("providing the information requested at https://randoop.github.io/randoop/manual/index.html#bug-reporting .");
            System.exit(1);
        }
    }

    private static @SignatureUnknown Set<@SignatureUnknown String> loadExclusions(@SignatureUnknown Reader exclusionReader, @SignatureUnknown String filename) throws @SignatureUnknown IOException {
        LinkedHashSet<String> excludedPackagePrefixes = new LinkedHashSet<String>();
        try (EntryReader reader = new EntryReader(exclusionReader, filename, "//.*$", null);){
            for (String line : reader) {
                String trimmed = line.trim();
                if (trimmed.isEmpty()) continue;
                if (trimmed.charAt(trimmed.length() - 1) != '.') {
                    trimmed = trimmed + ".";
                }
                excludedPackagePrefixes.add(trimmed);
            }
        }
        return excludedPackagePrefixes;
    }

    private static @SignatureUnknown String getAgentPath() throws @SignatureUnknown BugInAgentException {
        Class<?> c;
        try {
            c = Class.forName("randoop.instrument.ReplaceCallAgent");
        }
        catch (ClassNotFoundException e) {
            throw new BugInAgentException("Error loading ReplaceCallAgent", e);
        }
        if (c.getClassLoader() != null) {
            throw new BugInAgentException("Agent should be included on bootclasspath");
        }
        URL url = ClassLoader.getSystemResource("randoop/instrument/ReplaceCallAgent.class");
        String jarFilePath = ReplaceCallAgent.getJarPathFromURL(url);
        if (debug) {
            System.err.println("AgentPath: " + jarFilePath);
        }
        return jarFilePath;
    }

    protected static @SignatureUnknown String getJarPathFromURL(@SignatureUnknown URL url) {
        String jarPath = url.getPath();
        return jarPath.substring(jarPath.indexOf(":") + 1, jarPath.indexOf("!"));
    }

    private static @SignatureUnknown String createAgentArgs(@SignatureUnknown Path replacementFilePath, @SignatureUnknown Path exclusionFilePath) {
        ArrayList<String> args = new ArrayList<String>();
        if (replacementFilePath != null) {
            args.add("--replacement-file=" + replacementFilePath.toAbsolutePath());
        }
        if (exclusionFilePath != null) {
            args.add("--dont-transform=" + exclusionFilePath.toAbsolutePath());
        }
        return UtilPlume.join(args, (CharSequence)",");
    }

    static {
        verbose = false;
        replacement_file = null;
        dont_transform = null;
    }

    private static class BugInAgentException
    extends Throwable {
        BugInAgentException(@SignatureUnknown String message) {
            super(message);
        }

        BugInAgentException(@SignatureUnknown String message, @SignatureUnknown Throwable cause) {
            super(message, cause);
        }
    }
}

