/*
 * Decompiled with CFR 0.152.
 */
package randoop.instrument;

import coveredclass.org.apache.bcel.classfile.JavaClass;
import coveredclass.org.apache.bcel.classfile.Method;
import coveredclass.org.apache.bcel.generic.ConstantPoolGen;
import coveredclass.org.apache.bcel.generic.InvokeInstruction;
import coveredclass.org.apache.bcel.generic.Type;
import coveredclass.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import coveredclass.org.checkerframework.checker.signature.qual.FqBinaryName;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import coveredclass.org.checkerframework.dataflow.qual.Pure;
import coveredclass.org.checkerframework.dataflow.qual.SideEffectFree;
import java.lang.instrument.IllegalClassFormatException;
import java.util.Arrays;
import java.util.Objects;
import org.plumelib.bcelutil.BcelUtil;
import org.plumelib.reflection.Signatures;
import org.plumelib.util.UtilPlume;
import randoop.instrument.ReplacementFileReader;

public class MethodSignature
implements Comparable<MethodSignature> {
    private final @SignatureUnknown String classname;
    private final @SignatureUnknown String name;
    private final @SignatureUnknown Type @SignatureUnknown [] paramTypes;
    private @SignatureUnknown Method method;

    private MethodSignature(@SignatureUnknown String classname, @SignatureUnknown String name, @SignatureUnknown Type @SignatureUnknown [] argTypes) {
        this.classname = classname;
        this.name = name;
        this.paramTypes = argTypes;
        this.method = null;
    }

    public static @SignatureUnknown MethodSignature of(@SignatureUnknown String classname, @SignatureUnknown Method method) {
        return new MethodSignature(classname, method.getName(), method.getArgumentTypes());
    }

    static @SignatureUnknown MethodSignature of(@SignatureUnknown InvokeInstruction invocation, @SignatureUnknown ConstantPoolGen pgen) {
        return new MethodSignature(invocation.getClassName(pgen), invocation.getMethodName(pgen), invocation.getArgumentTypes(pgen));
    }

    static @SignatureUnknown MethodSignature of(@SignatureUnknown String fullMethodName, @FqBinaryName String @SignatureUnknown [] params) {
        int dotPos = fullMethodName.lastIndexOf(46);
        if (dotPos < 1) {
            throw new IllegalArgumentException("Fully-qualified method name expected, no period found: " + fullMethodName);
        }
        String classname = fullMethodName.substring(0, dotPos);
        String methodName = fullMethodName.substring(dotPos + 1);
        Type[] paramTypes = new Type[params.length];
        for (int i = 0; i < params.length; ++i) {
            paramTypes[i] = BcelUtil.fqBinaryNameToType(params[i]);
        }
        return new MethodSignature(classname, methodName, paramTypes);
    }

    static @SignatureUnknown MethodSignature of(@SignatureUnknown String signature) {
        String[] parameters;
        int parenPos = signature.indexOf(40);
        if (parenPos < 1) {
            throw new IllegalArgumentException("Method signature expected, did not find beginning parenthesis: " + signature);
        }
        String fullMethodName = signature.substring(0, parenPos);
        int lastParenPos = signature.lastIndexOf(41);
        if (lastParenPos < parenPos + 1) {
            throw new IllegalArgumentException("Method signature expected, mismatched parenthesis: " + signature);
        }
        String paramString = signature.substring(parenPos + 1, lastParenPos);
        for (String parameter : parameters = paramString.isEmpty() ? new String[]{} : paramString.trim().split("\\s*,\\s*")) {
            if (Signatures.isFqBinaryName(parameter)) continue;
            throw new IllegalArgumentException("Bad parameter type \"" + parameter + "\" in signature: " + signature);
        }
        return MethodSignature.of(fullMethodName, parameters);
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @SignatureUnknown boolean equals(@SignatureUnknown Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MethodSignature)) {
            return false;
        }
        MethodSignature md = (MethodSignature)obj;
        return this.classname.equals(md.classname) && this.name.equals(md.name) && Arrays.equals(this.paramTypes, md.paramTypes);
    }

    @Override
    @Pure
    public @SignatureUnknown int compareTo(@SignatureUnknown MethodSignature m3) {
        int result = this.classname.compareTo(m3.classname);
        if (result == 0 && (result = this.name.compareTo(m3.name)) == 0) {
            if (this.paramTypes.length < m3.paramTypes.length) {
                return -1;
            }
            if (this.paramTypes.length > m3.paramTypes.length) {
                return 1;
            }
            for (int i = 0; i < this.paramTypes.length; ++i) {
                result = this.paramTypes[i].getSignature().compareTo(m3.paramTypes[i].getSignature());
                if (result == 0) continue;
                return result;
            }
        }
        return result;
    }

    @Pure
    public @SignatureUnknown int hashCode() {
        return Objects.hash(this.classname, this.name, Arrays.hashCode(this.paramTypes));
    }

    @SideEffectFree
    public @SignatureUnknown String toString() {
        return String.format("%s.%s(%s)", this.classname, this.name, UtilPlume.join(this.paramTypes, (CharSequence)", "));
    }

    @SignatureUnknown String getClassname() {
        return this.classname;
    }

    @SignatureUnknown String getName() {
        return this.name;
    }

    @SignatureUnknown Type @SignatureUnknown [] getParameterTypes() {
        return this.paramTypes;
    }

    @SignatureUnknown Method toMethod() throws @SignatureUnknown ClassNotFoundException, @SignatureUnknown NoSuchMethodException, @SignatureUnknown IllegalClassFormatException {
        if (this.method != null) {
            return this.method;
        }
        String currentClassname = this.classname;
        while (true) {
            JavaClass currentClass;
            try {
                currentClass = ReplacementFileReader.getJavaClassFromClassname(currentClassname);
            }
            catch (Throwable e) {
                throw new IllegalClassFormatException("Unable to read: " + currentClassname);
            }
            if (currentClass == null) {
                throw new ClassNotFoundException("Class " + currentClassname + " not found");
            }
            for (Method m3 : currentClass.getMethods()) {
                if (!m3.getName().equals(this.name) || !Arrays.equals(m3.getArgumentTypes(), this.paramTypes)) continue;
                this.method = m3;
                return m3;
            }
            if (currentClass.getSuperclassNameIndex() == 0) {
                throw new NoSuchMethodException("Method " + this.name + " not found");
            }
            currentClassname = currentClass.getSuperclassName();
        }
    }

    @SignatureUnknown boolean exists() {
        try {
            return this.toMethod() != null;
        }
        catch (ClassNotFoundException | NoSuchMethodException | IllegalClassFormatException e) {
            return false;
        }
    }

    @SignatureUnknown MethodSignature substituteClassname(@SignatureUnknown String classname) {
        return new MethodSignature(classname, this.getName(), this.getParameterTypes());
    }

    @SignatureUnknown MethodSignature removeFirstParameter() {
        Type[] types = new Type[this.paramTypes.length - 1];
        System.arraycopy(this.paramTypes, 1, types, 0, this.paramTypes.length - 1);
        return new MethodSignature(this.classname, this.getName(), types);
    }
}

