/*
 * Decompiled with CFR 0.152.
 */
package randoop.instrument;

import coveredclass.org.checkerframework.checker.signature.qual.SignatureBottom;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;
import randoop.ExecutionVisitor;
import randoop.sequence.ExecutableSequence;

public class CoveredClassVisitor
implements ExecutionVisitor {
    private /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Set<@SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?>> classes;

    public CoveredClassVisitor(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Set<@SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?>> classes) {
        this.classes = classes;
    }

    @Override
    public void visitAfterSequence(@SignatureUnknown ExecutableSequence eseq) {
        for (Class<?> c : this.classes) {
            if (!this.checkAndReset(c)) continue;
            eseq.addCoveredClass(c);
        }
    }

    private @SignatureUnknown boolean checkAndReset(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> c) {
        try {
            Method m3 = c.getMethod("randoop_checkAndReset", new Class[0]);
            m3.setAccessible(true);
            return (Boolean)m3.invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new Error("Cannot find instrumentation method: " + e);
        }
        catch (SecurityException e) {
            throw new Error("Security error when accessing instrumentation method: " + e);
        }
        catch (IllegalAccessException e) {
            throw new Error("Cannot access instrumentation method: " + e);
        }
        catch (IllegalArgumentException e) {
            throw new Error("Bad argument to instrumentation method: " + e);
        }
        catch (InvocationTargetException e) {
            throw new Error("Bad invocation of instrumentation method: " + e);
        }
    }

    @Override
    public void visitBeforeStatement(@SignatureUnknown ExecutableSequence eseq, @SignatureUnknown int i) {
    }

    @Override
    public void visitAfterStatement(@SignatureUnknown ExecutableSequence eseq, @SignatureUnknown int i) {
    }

    @Override
    public void initialize(@SignatureUnknown ExecutableSequence eseq) {
    }
}

