/*
 * Decompiled with CFR 0.152.
 */
package randoop.instrument;

import coveredclass.org.apache.bcel.classfile.ClassParser;
import coveredclass.org.apache.bcel.classfile.JavaClass;
import coveredclass.org.apache.bcel.classfile.Method;
import coveredclass.org.apache.bcel.generic.CPInstruction;
import coveredclass.org.apache.bcel.generic.ClassGen;
import coveredclass.org.apache.bcel.generic.Instruction;
import coveredclass.org.apache.bcel.generic.InstructionFactory;
import coveredclass.org.apache.bcel.generic.InstructionHandle;
import coveredclass.org.apache.bcel.generic.InstructionList;
import coveredclass.org.apache.bcel.generic.InvokeInstruction;
import coveredclass.org.apache.bcel.generic.MethodGen;
import coveredclass.org.apache.bcel.generic.NEW;
import coveredclass.org.apache.bcel.generic.ReferenceType;
import coveredclass.org.apache.bcel.generic.Type;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureBottom;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import java.io.ByteArrayInputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.nio.file.Path;
import java.security.ProtectionDomain;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.plumelib.bcelutil.BcelUtil;
import org.plumelib.bcelutil.InstructionListUtils;
import org.plumelib.bcelutil.SimpleLog;
import randoop.instrument.MethodSignature;
import randoop.instrument.ReplaceCallAgent;

public class CallReplacementTransformer
extends InstructionListUtils
implements ClassFileTransformer {
    private static @SignatureUnknown SimpleLog debug_transform = new SimpleLog(false);
    private static @SignatureUnknown SimpleLog debug_map = new SimpleLog(false);
    private final @SignatureUnknown HashMap<@SignatureUnknown MethodSignature, @SignatureUnknown MethodSignature> replacementMap;
    private final @SignatureUnknown Set<@SignatureUnknown String> excludedPackagePrefixes;
    private @SignatureUnknown Deque<@SignatureUnknown NewInstInfo> new_inst_stack = new ArrayDeque<NewInstInfo>();

    CallReplacementTransformer(@SignatureUnknown HashMap<@SignatureUnknown MethodSignature, @SignatureUnknown MethodSignature> replacementMap, @SignatureUnknown Set<@SignatureUnknown String> excludedPackagePrefixes) {
        this.replacementMap = replacementMap;
        this.excludedPackagePrefixes = excludedPackagePrefixes;
    }

    @Override
    public @SignatureUnknown byte @SignatureUnknown [] transform(@SignatureUnknown ClassLoader loader, @SignatureUnknown String className, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> classBeingRedefined, @SignatureUnknown ProtectionDomain protectionDomain, @SignatureUnknown byte @SignatureUnknown [] classfileBuffer) throws @SignatureUnknown IllegalClassFormatException {
        JavaClass c;
        debug_transform.log("loader: %s, className: %s%n", loader, className);
        if (className == null) {
            return null;
        }
        String fullClassName = className.replace("/", ".");
        if (this.isExcludedClass(loader, fullClassName)) {
            debug_transform.log("transform: ignoring excluded class %s%n", className);
            return null;
        }
        debug_transform.log("%ntransform class: ENTER %s%n", className);
        try {
            ClassParser parser = new ClassParser(new ByteArrayInputStream(classfileBuffer), className);
            c = parser.parse();
        }
        catch (Exception e) {
            debug_transform.log("transform: EXIT parse of %s resulted in error %s%n", className, e);
            return null;
        }
        try {
            ClassGen cg = new ClassGen(c);
            if (this.transformClass(cg)) {
                JavaClass javaClass = cg.getJavaClass();
                if (ReplaceCallAgent.debug) {
                    Path filepath = ReplaceCallAgent.debugPath.resolve(className + ".class");
                    javaClass.dump(filepath.toFile());
                }
                debug_transform.log("transform: EXIT class %s transformed%n", className);
                return javaClass.getBytes();
            }
            debug_transform.log("transform: EXIT class %s not transformed (nothing to replace)%n", className);
            return null;
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (IllegalClassFormatException e) {
            debug_transform.log("transform: EXIT transform of %s resulted in exception %s%n", className, e);
            System.out.format("Unexpected exception %s (cause=%s) in CallReplacementTransformer.transform(%s)%n", e, e.getCause(), className);
            throw e;
        }
        catch (Throwable e) {
            debug_transform.log("transform: EXIT transform of %s resulted in exception %s%n", className, e);
            System.out.format("Unexpected exception %s (%s) in CallReplacementTransformer.transform(%s)%n", e, e.getCause(), className);
            e.printStackTrace(System.out);
            return null;
        }
    }

    private @SignatureUnknown boolean isBootloadedClass(@SignatureUnknown ClassLoader loader) {
        return loader == null || loader.getParent() == null;
    }

    private @SignatureUnknown boolean isGUIClass(@SignatureUnknown String fullClassName) {
        return fullClassName.startsWith("java.awt.") || fullClassName.startsWith("javax.swing.");
    }

    private @SignatureUnknown boolean isExcludedClass(@SignatureUnknown ClassLoader loader, @SignatureUnknown String fullClassName) {
        if (this.isBootloadedClass(loader) && !this.isGUIClass(fullClassName)) {
            return true;
        }
        if (fullClassName.contains("ByMockito")) {
            return true;
        }
        for (String prefix : this.excludedPackagePrefixes) {
            if (!fullClassName.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private @SignatureUnknown boolean transformClass(@SignatureUnknown ClassGen cg) throws @SignatureUnknown IllegalClassFormatException {
        boolean transformed = false;
        InstructionFactory ifact = new InstructionFactory(cg);
        boolean save_debug = this.debug_instrument.enabled;
        try {
            for (Method method : cg.getMethods()) {
                CallReplacementTransformer callReplacementTransformer = this;
                synchronized (callReplacementTransformer) {
                    this.new_inst_stack.clear();
                    this.pool = cg.getConstantPool();
                    MethodGen mg = new MethodGen(method, cg.getClassName(), this.pool);
                    debug_transform.log("%ntransform method: ENTER %s%n", mg.getName());
                    if ((0x1000 & mg.getAccessFlags()) > 0) {
                        continue;
                    }
                    InstructionList il = mg.getInstructionList();
                    if (il == null) {
                        continue;
                    }
                    this.debug_instrument.enabled = false;
                    this.set_current_stack_map_table(mg, cg.getMajor());
                    this.build_unitialized_NEW_map(il);
                    this.fix_local_variable_table(mg);
                    this.debug_instrument.enabled = save_debug;
                    if (!this.transformMethod(cg, mg, ifact)) {
                        continue;
                    }
                    transformed = true;
                    this.update_uninitialized_NEW_offsets(il);
                    this.create_new_stack_map_attribute(mg);
                    this.remove_local_variable_type_table(mg);
                    mg.setInstructionList(il);
                    mg.update();
                    mg.setMaxLocals();
                    mg.setMaxStack();
                    mg.update();
                    try {
                        cg.replaceMethod(method, mg.getMethod());
                    }
                    catch (Exception e) {
                        if (e.getMessage().startsWith("Branch target offset too large")) {
                            System.out.printf("ReplaceCall warning: ClassFile: %s - method %s is too large to instrument and is being skipped.%n", cg.getClassName(), mg.getName());
                            continue;
                        }
                        throw e;
                    }
                    this.debug_instrument.log("%n%s.%s modified code: %s%n%n", mg.getClassName(), mg.getName(), mg.getMethod().getCode());
                    cg.update();
                }
            }
        }
        catch (Exception e) {
            System.out.printf("Unexpected exception encountered: %s%n", e);
            e.printStackTrace(System.out);
            this.debug_instrument.enabled = save_debug;
        }
        return transformed;
    }

    private @SignatureUnknown boolean transformMethod(@SignatureUnknown ClassGen cg, @SignatureUnknown MethodGen mg, @SignatureUnknown InstructionFactory ifact) throws @SignatureUnknown IllegalClassFormatException {
        InstructionList il = mg.getInstructionList();
        InstructionHandle ih = il.getStart();
        boolean transformed = false;
        while (ih != null) {
            InstructionHandle nextHandle = ih.getNext();
            InstructionList new_il = this.getReplacementInstruction(cg, mg, ifact, ih);
            if (new_il != null) {
                this.debug_instrument.log("%s.%s:%n", mg.getClassName(), mg.getName());
                transformed = true;
                this.replace_instructions(mg, il, ih, new_il);
            }
            ih = nextHandle;
        }
        return transformed;
    }

    private @SignatureUnknown InstructionList getReplacementInstruction(@SignatureUnknown ClassGen cg, @SignatureUnknown MethodGen mg, @SignatureUnknown InstructionFactory ifact, @SignatureUnknown InstructionHandle ih) throws @SignatureUnknown IllegalClassFormatException {
        InvokeInstruction newInvocation;
        Instruction inst = ih.getInstruction();
        if (inst instanceof NEW) {
            String new_class = ((CPInstruction)ih.getInstruction()).getType(this.pool).toString();
            this.new_inst_stack.push(new NewInstInfo(ih, new_class));
            return null;
        }
        if (!(inst instanceof InvokeInstruction)) {
            return null;
        }
        InvokeInstruction origInvocation = (InvokeInstruction)inst;
        MethodSignature origSig = MethodSignature.of(origInvocation, this.pool);
        MethodSignature newSig = this.replacementMap.get(origSig);
        String super_class_name = cg.getSuperclassName();
        String class_name = cg.getClassName();
        String method_name = mg.getName();
        String invoke_class = origSig.getClassname();
        String invoke_method = origSig.getName();
        if (newSig == null) {
            debug_transform.log("%s.%s: No replacement for %s%n", class_name, method_name, origSig);
            if (invoke_method.equals("<init>")) {
                if (method_name.equals("<init>")) {
                    if (invoke_class.equals(class_name)) {
                        return null;
                    }
                    if (invoke_class.equals(super_class_name)) {
                        return null;
                    }
                }
                NewInstInfo top = this.new_inst_stack.pop();
                if (!invoke_class.equals(top.new_class)) {
                    throw new IllegalClassFormatException("Type of NEW object and <init> method do not match.");
                }
            }
            return null;
        }
        boolean new_dup_removed = false;
        if (invoke_method.equals("<init>")) {
            if (method_name.equals("<init>")) {
                if (invoke_class.equals(class_name)) {
                    debug_transform.log("%s.%s: Do not modify call to this().<init>%n", class_name, method_name);
                    return null;
                }
                if (invoke_class.equals(super_class_name)) {
                    debug_transform.log("%s.%s: Do not modify call to super().<init>%n", class_name, method_name);
                    return null;
                }
            }
            NewInstInfo top = this.new_inst_stack.pop();
            if (!invoke_class.equals(top.new_class)) {
                throw new IllegalClassFormatException("Type of NEW object and <init> method do not match.");
            }
            if (top.new_inst.getNext().getInstruction().getOpcode() != 89) {
                throw new IllegalClassFormatException("Unable to find NEW DUP pair.");
            }
            this.delete_instructions(mg, top.new_inst, top.new_inst.getNext());
            new_dup_removed = true;
        }
        debug_transform.log("%s.%s: Replacing method %s with %s%n", class_name, method_name, origSig, newSig);
        switch (origInvocation.getOpcode()) {
            case 182: 
            case 183: 
            case 185: {
                ReferenceType instanceType = origInvocation.getReferenceType(this.pool);
                if (new_dup_removed) {
                    newInvocation = ifact.createInvoke(newSig.getClassname(), newSig.getName(), instanceType, origInvocation.getArgumentTypes(this.pool), (short)184);
                    break;
                }
                Type[] arguments = BcelUtil.prependToArray(instanceType, origInvocation.getArgumentTypes(this.pool));
                newInvocation = ifact.createInvoke(newSig.getClassname(), newSig.getName(), origInvocation.getReturnType(this.pool), arguments, (short)184);
                break;
            }
            case 184: {
                newInvocation = ifact.createInvoke(newSig.getClassname(), newSig.getName(), origInvocation.getReturnType(this.pool), origInvocation.getArgumentTypes(this.pool), (short)184);
                break;
            }
            default: {
                debug_transform.log("getReplacementInstruction: EXIT Exception thrown due to wrong instruction type in %s.%s%n", mg.getClassName(), mg.getName());
                String msg = String.format("Unexpected invoke instruction %s in %s.%s", origInvocation, mg.getClassName(), mg.getName());
                throw new IllegalClassFormatException(msg);
            }
        }
        debug_transform.log("new invoke: %s%n", newInvocation);
        return this.build_il(newInvocation);
    }

    private void logReplacementMap() {
        if (debug_map.enabled()) {
            if (this.replacementMap.isEmpty()) {
                debug_map.log("No method replacements", new Object[0]);
            } else {
                debug_map.log("%nMethod replacement list:%n", new Object[0]);
                for (Map.Entry<MethodSignature, MethodSignature> entry : this.replacementMap.entrySet()) {
                    debug_map.log("%s => %s%n", entry.getKey(), entry.getValue());
                }
            }
        }
    }

    void addMapFileShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                CallReplacementTransformer.this.logReplacementMap();
            }
        });
    }

    private static class NewInstInfo {
        @SignatureUnknown InstructionHandle new_inst;
        @SignatureUnknown String new_class;

        public NewInstInfo(@SignatureUnknown InstructionHandle new_inst, @SignatureUnknown String new_class) {
            this.new_inst = new_inst;
            this.new_class = new_class;
        }
    }
}

