/*
 * Decompiled with CFR 0.152.
 */
package randoop.generation;

import coveredclass.org.checkerframework.checker.nullness.qual.Nullable;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import org.plumelib.util.FileWriterWithName;
import randoop.generation.AbstractGenerator;
import randoop.generation.OperationHistoryLogger;
import randoop.main.GenInputsAbstract;

public class TestUtils {
    static @SignatureUnknown boolean debug = false;

    public static void setAllLogs(@SignatureUnknown AbstractGenerator generator) {
        TestUtils.setRandoopLog();
        TestUtils.setSelectionLog();
        TestUtils.setOperationLog(generator);
    }

    public static void setRandoopLog() {
        String randoopLog = System.getProperty("randoop.log");
        TestUtils.setRandoopLog(randoopLog);
    }

    public static void setRandoopLog(@Nullable @SignatureUnknown String filename) {
        if (debug) {
            System.out.println("setRandoopLog(" + filename + ")");
        }
        if (filename == null) {
            return;
        }
        if (filename.isEmpty()) {
            throw new IllegalArgumentException();
        }
        try {
            GenInputsAbstract.log = new FileWriterWithName(filename);
        }
        catch (IOException ioe) {
            throw new Error("Cannot write file " + filename, ioe);
        }
    }

    public static void setSelectionLog() {
        String selectionLog = System.getProperty("randoop.selection.log");
        TestUtils.setSelectionLog(selectionLog);
    }

    public static void setSelectionLog(@Nullable @SignatureUnknown String filename) {
        if (debug) {
            System.out.println("setSelectionLog(" + filename + ")");
        }
        if (filename == null) {
            return;
        }
        if (filename.isEmpty()) {
            throw new IllegalArgumentException();
        }
        try {
            TestUtils.setSelectionLog(new FileWriterWithName(filename));
        }
        catch (IOException e) {
            throw new Error("problem creating FileWriter for " + filename, e);
        }
    }

    public static void setSelectionLog(@SignatureUnknown FileWriterWithName fw) {
        if (debug) {
            System.out.println("setSelectionLog(" + fw + ")");
        }
        GenInputsAbstract.selection_log = fw;
    }

    public static void setOperationLog(@SignatureUnknown AbstractGenerator generator) {
        TestUtils.setOperationLog(System.getProperty("randoop.operation.history.log"), generator);
    }

    public static void setOperationLog(@Nullable @SignatureUnknown String filename, @SignatureUnknown AbstractGenerator generator) {
        if (debug) {
            System.out.println("setOperationLog(" + filename + ")");
        }
        if (filename == null) {
            return;
        }
        if (filename.isEmpty()) {
            throw new IllegalArgumentException();
        }
        try {
            TestUtils.setOperationLog(new PrintWriter(new File(filename), StandardCharsets.UTF_8.name()), generator);
        }
        catch (IOException e) {
            throw new Error("problem creating FileWriter for " + filename, e);
        }
    }

    public static void setOperationLog(@SignatureUnknown PrintWriter pw, @SignatureUnknown AbstractGenerator generator) {
        if (debug) {
            System.out.println("setOperationLog(" + pw + ")");
        }
        if (pw != null) {
            OperationHistoryLogger historyLogger = new OperationHistoryLogger(pw);
            generator.setOperationHistoryLogger(historyLogger);
        }
    }
}

