/*
 * Decompiled with CFR 0.152.
 */
package randoop.generation;

import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import java.util.ArrayList;
import java.util.List;
import randoop.generation.IEventListener;
import randoop.sequence.ExecutableSequence;

public class RandoopListenerManager {
    private @SignatureUnknown List<@SignatureUnknown IEventListener> listeners = new ArrayList<IEventListener>();

    public void addListener(@SignatureUnknown IEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener is null");
        }
        this.listeners.add(listener);
    }

    public void generationStepPre() {
        for (IEventListener n : this.listeners) {
            n.generationStepPre();
        }
    }

    public void generationStepPost(@SignatureUnknown ExecutableSequence es) {
        for (IEventListener n : this.listeners) {
            n.generationStepPost(es);
        }
    }

    public void progressThreadUpdateNotify() {
        for (IEventListener n : this.listeners) {
            n.progressThreadUpdate();
        }
    }

    public @SignatureUnknown boolean shouldStopGeneration() {
        for (IEventListener n : this.listeners) {
            if (!n.shouldStopGeneration()) continue;
            return true;
        }
        return false;
    }

    public void explorationStart() {
        for (IEventListener n : this.listeners) {
            n.explorationStart();
        }
    }

    public void explorationEnd() {
        for (IEventListener n : this.listeners) {
            n.explorationEnd();
        }
    }
}

