/*
 * Decompiled with CFR 0.152.
 */
package randoop.generation;

import coveredclass.org.checkerframework.checker.signature.qual.SignatureBottom;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import randoop.generation.ComponentManager;
import randoop.main.GenInputsAbstract;
import randoop.main.RandoopBug;
import randoop.operation.ConstructorCall;
import randoop.operation.MethodCall;
import randoop.operation.NonreceiverTerm;
import randoop.operation.TypedClassOperation;
import randoop.operation.TypedOperation;
import randoop.sequence.Sequence;
import randoop.sequence.TupleSequence;
import randoop.sequence.Variable;
import randoop.types.ArrayType;
import randoop.types.ClassOrInterfaceType;
import randoop.types.GenericClassType;
import randoop.types.InstantiatedType;
import randoop.types.JDKTypes;
import randoop.types.JavaTypes;
import randoop.types.ParameterBound;
import randoop.types.ParameterizedType;
import randoop.types.ReferenceArgument;
import randoop.types.ReferenceBound;
import randoop.types.ReferenceType;
import randoop.types.Type;
import randoop.types.TypeArgument;
import randoop.types.TypeTuple;
import randoop.types.WildcardArgument;
import randoop.util.Log;
import randoop.util.Randomness;
import randoop.util.SimpleArrayList;
import randoop.util.SimpleList;

class HelperSequenceCreator {
    private HelperSequenceCreator() {
        throw new Error("Do not instantiate");
    }

    static @SignatureUnknown SimpleList<@SignatureUnknown Sequence> createArraySequence(@SignatureUnknown ComponentManager components, @SignatureUnknown Type collectionType) {
        int length;
        SimpleList<Sequence> candidates;
        int MAX_LENGTH = 7;
        if (!collectionType.isArray()) {
            return new SimpleArrayList<Sequence>();
        }
        ArrayType arrayType = (ArrayType)collectionType;
        Type componentType = arrayType.getComponentType();
        if (componentType.isArray()) {
            candidates = HelperSequenceCreator.createArraySequence(components, componentType);
        } else {
            InstantiatedType creationType;
            if (componentType.isParameterized() && (creationType = HelperSequenceCreator.getImplementingTypeForCollection((InstantiatedType)componentType)).isRecursiveType()) {
                componentType = ((ReferenceArgument)creationType.getTypeArguments().get(0)).getReferenceType();
            }
            candidates = components.getSequencesForType(componentType);
        }
        if (candidates.isEmpty()) {
            SimpleArrayList<Sequence> seqList = new SimpleArrayList<Sequence>();
            if (!GenInputsAbstract.forbid_null && !Randomness.weightedCoinFlip(0.5)) {
                seqList.add(new Sequence().extend(TypedOperation.createNullOrZeroInitializationForType(componentType), new Variable[0]));
            }
            length = seqList.size();
            candidates = seqList;
        } else {
            length = Randomness.nextRandomInt(7);
        }
        TupleSequence elementsSequence = TupleSequence.createElementsSequence(candidates, length, componentType);
        Sequence s2 = HelperSequenceCreator.createAnArray(elementsSequence, componentType, length);
        assert (s2 != null);
        SimpleArrayList<Sequence> l = new SimpleArrayList<Sequence>();
        l.add(s2);
        return l;
    }

    private static @SignatureUnknown ReferenceType getElementType(@SignatureUnknown InstantiatedType collectionType) {
        List<TypeArgument> argumentList = collectionType.getTypeArguments();
        assert (argumentList.size() == 1) : String.format("Collection type %s should have one type argument, has %d", collectionType, argumentList.size());
        TypeArgument argumentType = argumentList.get(0);
        assert (argumentType instanceof ReferenceArgument) : "Type argument " + argumentType + " should be a reference type";
        return ((ReferenceArgument)argumentType).getReferenceType();
    }

    static @SignatureUnknown Sequence createCollection(@SignatureUnknown ComponentManager componentManager, @SignatureUnknown InstantiatedType collectionType) {
        ReferenceType elementType = HelperSequenceCreator.getElementType(collectionType);
        InstantiatedType implementingType = HelperSequenceCreator.getImplementingTypeForCollection(collectionType);
        SimpleList<Sequence> candidates = componentManager.getSequencesForType(elementType);
        int length = 0;
        if (!candidates.isEmpty()) {
            length = Randomness.nextRandomInt(candidates.size()) + 1;
        }
        assert (!candidates.isEmpty() || length == 0) : "if there are no candidates, length must be zero";
        TupleSequence elementsSequence = TupleSequence.createElementsSequence(candidates, length, elementType);
        Sequence creationSequence = HelperSequenceCreator.createCollectionCreationSequence(implementingType, elementType);
        if (creationSequence == null) {
            return null;
        }
        if (!(elementType.isParameterized() || elementType.isArray() && ((ArrayType)elementType).hasParameterizedElementType())) {
            int totStatements = 0;
            ArrayList<Sequence> inputSequences = new ArrayList<Sequence>();
            ArrayList<Integer> variableIndices = new ArrayList<Integer>();
            Sequence inputSequence = HelperSequenceCreator.createAnArray(elementsSequence, elementType, length);
            inputSequences.add(inputSequence);
            int inputIndex = totStatements + inputSequence.getLastVariable().index;
            inputSequences.add(creationSequence);
            int creationIndex = (totStatements += inputSequence.size()) + creationSequence.getLastVariable().index;
            variableIndices.add(creationIndex);
            variableIndices.add(inputIndex);
            TypedOperation addOperation = HelperSequenceCreator.getCollectionAddAllOperation(elementType);
            return Sequence.createSequence(addOperation, inputSequences, variableIndices);
        }
        final TypedOperation addOperation = HelperSequenceCreator.getAddOperation(collectionType, elementType);
        SequenceExtender addExtender = new SequenceExtender(){

            @Override
            public @SignatureUnknown Sequence extend(@SignatureUnknown Sequence addSequence, @SignatureUnknown int creationIndex, @SignatureUnknown Integer index, @SignatureUnknown int i) {
                ArrayList<Variable> inputs = new ArrayList<Variable>();
                inputs.add(addSequence.getVariable(creationIndex));
                inputs.add(addSequence.getVariable(index));
                return addSequence.extend(addOperation, inputs);
            }
        };
        return HelperSequenceCreator.buildAddSequence(creationSequence, elementsSequence, addExtender);
    }

    private static @SignatureUnknown Sequence buildAddSequence(@SignatureUnknown Sequence creationSequence, @SignatureUnknown TupleSequence elementsSequence, @SignatureUnknown SequenceExtender addSequenceExtender) {
        ArrayList<Sequence> inputSequences = new ArrayList<Sequence>();
        inputSequences.add(elementsSequence.sequence);
        inputSequences.add(creationSequence);
        Sequence addSequence = Sequence.concatenate(inputSequences);
        int creationIndex = addSequence.getLastVariable().index;
        int i = 0;
        for (Integer index : elementsSequence.getOutputIndices()) {
            addSequence = addSequenceExtender.extend(addSequence, creationIndex, index, i);
            ++i;
        }
        return addSequence;
    }

    private static @SignatureUnknown Sequence createCollectionCreationSequence(@SignatureUnknown InstantiatedType implementingType, @SignatureUnknown ReferenceType elementType) {
        TypedOperation creationOperation;
        Sequence creationSequence = new Sequence();
        ArrayList<Variable> creationInputs = new ArrayList<Variable>();
        if (implementingType.isInstantiationOf(JDKTypes.ENUM_SET_TYPE)) {
            NonreceiverTerm classLiteral = new NonreceiverTerm(JavaTypes.CLASS_TYPE, elementType.getRuntimeClass());
            creationSequence = creationSequence.extend(TypedOperation.createNonreceiverInitialization(classLiteral), new Variable[0]);
            creationInputs.add(creationSequence.getLastVariable());
            creationOperation = HelperSequenceCreator.getEnumSetCreation(implementingType);
        } else {
            Constructor<?> constructor = HelperSequenceCreator.getDefaultConstructor(implementingType);
            if (constructor == null) {
                return null;
            }
            ConstructorCall op = new ConstructorCall(constructor);
            creationOperation = new TypedClassOperation(op, implementingType, new TypeTuple(), implementingType);
        }
        return creationSequence.extend(creationOperation, creationInputs);
    }

    private static @SignatureUnknown Sequence createAnArray(@SignatureUnknown TupleSequence elementsSequence, @SignatureUnknown Type elementType, @SignatureUnknown int length) {
        ArrayType arrayType = ArrayType.ofComponentType(elementType);
        if (!(elementType.isParameterized() || elementType.isArray() && ((ArrayType)elementType).hasParameterizedElementType())) {
            TypedOperation creationOperation = TypedOperation.createInitializedArrayCreation(arrayType, length);
            return Sequence.createSequence(creationOperation, elementsSequence);
        }
        Sequence createSequence = HelperSequenceCreator.createGenericArrayCreationSequence(arrayType, length);
        final TypedOperation arrayElementAssignment = TypedOperation.createArrayElementAssignment(arrayType);
        SequenceExtender addExtender = new SequenceExtender(){

            @Override
            public @SignatureUnknown Sequence extend(@SignatureUnknown Sequence addSequence, @SignatureUnknown int creationIndex, @SignatureUnknown Integer index, @SignatureUnknown int i) {
                addSequence = addSequence.extend(TypedOperation.createPrimitiveInitialization(JavaTypes.INT_TYPE, i), new Variable[0]);
                ArrayList<Variable> inputs = new ArrayList<Variable>();
                inputs.add(addSequence.getVariable(creationIndex));
                inputs.add(addSequence.getLastVariable());
                inputs.add(addSequence.getVariable(index));
                return addSequence.extend(arrayElementAssignment, inputs);
            }
        };
        return HelperSequenceCreator.buildAddSequence(createSequence, elementsSequence, addExtender);
    }

    private static @SignatureUnknown Sequence createGenericArrayCreationSequence(@SignatureUnknown ArrayType arrayType, @SignatureUnknown int length) {
        ArrayType rawArrayType = arrayType.getRawTypeArray();
        Sequence creationSequence = new Sequence();
        List<Variable> input = new ArrayList<Variable>();
        TypedOperation lengthTerm = TypedOperation.createNonreceiverInitialization(new NonreceiverTerm(JavaTypes.INT_TYPE, length));
        creationSequence = creationSequence.extend(lengthTerm, Collections.emptyList());
        input.add(creationSequence.getLastVariable());
        TypedOperation creationOperation = TypedOperation.createArrayCreation(rawArrayType);
        creationSequence = creationSequence.extend(creationOperation, input);
        TypedOperation castOperation = TypedOperation.createCast(rawArrayType, arrayType);
        input = Collections.singletonList(creationSequence.getLastVariable());
        creationSequence = creationSequence.extend(castOperation, input);
        return creationSequence;
    }

    private static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Constructor<@SignatureUnknown @SignatureBottom ?> getDefaultConstructor(@SignatureUnknown ClassOrInterfaceType creationType) {
        Constructor<?> constructor;
        try {
            constructor = creationType.getRuntimeClass().getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        return constructor;
    }

    private static @SignatureUnknown InstantiatedType getImplementingTypeForCollection(@SignatureUnknown InstantiatedType elementType) {
        InstantiatedType creationType = elementType;
        if (elementType.getGenericClassType().isSubtypeOf(JDKTypes.COLLECTION_TYPE) && elementType.getPackage().equals(JDKTypes.COLLECTION_TYPE.getPackage())) {
            GenericClassType implementingType = JDKTypes.getImplementingTypeForCollection(elementType);
            ArrayList<ReferenceType> typeArgumentList = new ArrayList<ReferenceType>();
            for (TypeArgument argument : elementType.getTypeArguments()) {
                if (argument instanceof ReferenceArgument) {
                    typeArgumentList.add(((ReferenceArgument)argument).getReferenceType());
                    continue;
                }
                if (argument instanceof WildcardArgument) {
                    ParameterBound bound = ((WildcardArgument)argument).getTypeBound();
                    if (bound instanceof ReferenceBound) {
                        typeArgumentList.add(((ReferenceBound)bound).getBoundType());
                        continue;
                    }
                    throw new RandoopBug(String.format("can't handle wildcard with bound %s: %s", Log.toStringAndClass(bound), Log.toStringAndClass(argument)));
                }
                throw new RandoopBug(String.format("unexpected argument of %s: %s", elementType, Log.toStringAndClass(argument)));
            }
            creationType = implementingType.instantiate(typeArgumentList);
        }
        return creationType;
    }

    private static @SignatureUnknown TypedOperation getEnumSetCreation(@SignatureUnknown ParameterizedType creationType) {
        Method method;
        Class<?> enumsetClass = JDKTypes.ENUM_SET_TYPE.getRuntimeClass();
        try {
            method = enumsetClass.getMethod("noneOf", JavaTypes.CLASS_TYPE.getRuntimeClass());
        }
        catch (NoSuchMethodException e) {
            throw new RandoopBug("Can't find \"noneOf\" method for EnumSet: ", e);
        }
        MethodCall op = new MethodCall(method);
        List<Type> paramTypes = Collections.singletonList(JavaTypes.CLASS_TYPE);
        return new TypedClassOperation(op, creationType, new TypeTuple(paramTypes), creationType);
    }

    private static @SignatureUnknown TypedOperation getAddOperation(@SignatureUnknown ParameterizedType collectionType, @SignatureUnknown ReferenceType elementType) {
        Method addMethod;
        try {
            addMethod = collectionType.getRuntimeClass().getMethod("add", Object.class);
        }
        catch (NoSuchMethodException e) {
            throw new RandoopBug("Can't find add() method for " + collectionType, e);
        }
        MethodCall op = new MethodCall(addMethod);
        ArrayList<Type> arguments = new ArrayList<Type>();
        arguments.add(collectionType);
        arguments.add(elementType);
        return new TypedClassOperation(op, collectionType, new TypeTuple(arguments), JavaTypes.BOOLEAN_TYPE);
    }

    private static @SignatureUnknown TypedOperation getCollectionAddAllOperation(@SignatureUnknown ReferenceType elementType) {
        Method method;
        Class<Collections> collectionsClass = Collections.class;
        try {
            method = collectionsClass.getMethod("addAll", JDKTypes.COLLECTION_TYPE.getRuntimeClass(), new Object[0].getClass());
        }
        catch (NoSuchMethodException e) {
            throw new RandoopBug("Can't find Collections.addAll method", e);
        }
        MethodCall op = new MethodCall(method);
        assert (method.getTypeParameters().length == 1) : "method should have one type parameter";
        ArrayList<Type> paramTypes = new ArrayList<Type>();
        InstantiatedType collectionType = JDKTypes.COLLECTION_TYPE.instantiate(elementType);
        paramTypes.add(collectionType);
        paramTypes.add(ArrayType.ofComponentType(elementType));
        return new TypedClassOperation(op, ClassOrInterfaceType.forClass(collectionsClass), new TypeTuple(paramTypes), JavaTypes.BOOLEAN_TYPE);
    }

    private static interface SequenceExtender {
        public @SignatureUnknown Sequence extend(@SignatureUnknown Sequence var1, @SignatureUnknown int var2, @SignatureUnknown Integer var3, @SignatureUnknown int var4);
    }
}

