/*
 * Decompiled with CFR 0.152.
 */
package randoop.generation;

import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import coveredclass.org.checkerframework.dataflow.qual.SideEffectFree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.plumelib.util.UtilPlume;
import randoop.DummyVisitor;
import randoop.Globals;
import randoop.NormalExecution;
import randoop.SubTypeSet;
import randoop.generation.AbstractGenerator;
import randoop.generation.Bloodhound;
import randoop.generation.ComponentManager;
import randoop.generation.HelperSequenceCreator;
import randoop.generation.IStopper;
import randoop.generation.InputSequenceSelector;
import randoop.generation.InputsAndSuccessFlag;
import randoop.generation.OperationOutcome;
import randoop.generation.RandoopGenerationError;
import randoop.generation.RandoopListenerManager;
import randoop.generation.SmallTestsSequenceSelection;
import randoop.generation.TypedOperationSelector;
import randoop.generation.UniformRandomMethodSelection;
import randoop.generation.UniformRandomSequenceSelection;
import randoop.main.GenInputsAbstract;
import randoop.main.RandoopBug;
import randoop.operation.NonreceiverTerm;
import randoop.operation.TypedClassOperation;
import randoop.operation.TypedOperation;
import randoop.reflection.RandoopInstantiationError;
import randoop.reflection.TypeInstantiator;
import randoop.sequence.ExecutableSequence;
import randoop.sequence.Sequence;
import randoop.sequence.Statement;
import randoop.sequence.Value;
import randoop.sequence.Variable;
import randoop.test.DummyCheckGenerator;
import randoop.types.ClassOrInterfaceType;
import randoop.types.InstantiatedType;
import randoop.types.JDKTypes;
import randoop.types.JavaTypes;
import randoop.types.Type;
import randoop.types.TypeTuple;
import randoop.util.ListOfLists;
import randoop.util.Log;
import randoop.util.MultiMap;
import randoop.util.Randomness;
import randoop.util.SimpleArrayList;
import randoop.util.SimpleList;

public class ForwardGenerator
extends AbstractGenerator {
    private final @SignatureUnknown LinkedHashSet<@SignatureUnknown Sequence> allSequences = new LinkedHashSet();
    private final @SignatureUnknown Set<@SignatureUnknown TypedOperation> sideEffectFreeMethods;
    private final @SignatureUnknown List<@SignatureUnknown String> allsequencesAsCode = new ArrayList<String>();
    private final @SignatureUnknown List<@SignatureUnknown Sequence> allsequencesAsList = new ArrayList<Sequence>();
    private final @SignatureUnknown TypeInstantiator instantiator;
    private final @SignatureUnknown InputSequenceSelector inputSequenceSelector;
    private final @SignatureUnknown TypedOperationSelector operationSelector;
    private @SignatureUnknown Set<@SignatureUnknown Object> runtimePrimitivesSeen = new LinkedHashSet<Object>();

    public ForwardGenerator(@SignatureUnknown List<@SignatureUnknown TypedOperation> operations, @SignatureUnknown Set<@SignatureUnknown TypedOperation> sideEffectFreeMethods, @SignatureUnknown GenInputsAbstract.Limits limits, @SignatureUnknown ComponentManager componentManager, @SignatureUnknown RandoopListenerManager listenerManager, @SignatureUnknown Set<@SignatureUnknown ClassOrInterfaceType> classesUnderTest) {
        this(operations, sideEffectFreeMethods, limits, componentManager, null, listenerManager, classesUnderTest);
    }

    public ForwardGenerator(@SignatureUnknown List<@SignatureUnknown TypedOperation> operations, @SignatureUnknown Set<@SignatureUnknown TypedOperation> sideEffectFreeMethods, @SignatureUnknown GenInputsAbstract.Limits limits, @SignatureUnknown ComponentManager componentManager, @SignatureUnknown IStopper stopper, @SignatureUnknown RandoopListenerManager listenerManager, @SignatureUnknown Set<@SignatureUnknown ClassOrInterfaceType> classesUnderTest) {
        super(operations, limits, componentManager, stopper, listenerManager);
        this.sideEffectFreeMethods = sideEffectFreeMethods;
        this.instantiator = componentManager.getTypeInstantiator();
        this.initializeRuntimePrimitivesSeen();
        switch (GenInputsAbstract.method_selection) {
            case UNIFORM: {
                this.operationSelector = new UniformRandomMethodSelection(operations);
                break;
            }
            case BLOODHOUND: {
                this.operationSelector = new Bloodhound(operations, classesUnderTest);
                break;
            }
            default: {
                throw new Error("Unhandled method_selection: " + (Object)((Object)GenInputsAbstract.method_selection));
            }
        }
        switch (GenInputsAbstract.input_selection) {
            case SMALL_TESTS: {
                this.inputSequenceSelector = new SmallTestsSequenceSelection();
                break;
            }
            case UNIFORM: {
                this.inputSequenceSelector = new UniformRandomSequenceSelection();
                break;
            }
            default: {
                throw new Error("Unhandled input_selection: " + (Object)((Object)GenInputsAbstract.input_selection));
            }
        }
    }

    @Override
    public void newRegressionTestHook(@SignatureUnknown Sequence sequence) {
        this.operationSelector.newRegressionTestHook(sequence);
    }

    private void initializeRuntimePrimitivesSeen() {
        for (Sequence s2 : this.componentManager.getAllPrimitiveSequences()) {
            ExecutableSequence es = new ExecutableSequence(s2);
            es.execute(new DummyVisitor(), new DummyCheckGenerator());
            NormalExecution e = (NormalExecution)es.getResult(0);
            Object runtimeValue = e.getRuntimeValue();
            this.runtimePrimitivesSeen.add(runtimeValue);
        }
    }

    @Override
    public @SignatureUnknown ExecutableSequence step() {
        ExecutableSequence eSeq;
        int nanoPerMilli = 1000000;
        long nanoPerOne = 1000000000L;
        long timeWarningLimit = 1000000000L;
        long startTime = System.nanoTime();
        if (this.componentManager.numGeneratedSequences() % GenInputsAbstract.clear == 0) {
            this.componentManager.clearGeneratedSequences();
        }
        if (UtilPlume.usedMemory(false) > GenInputsAbstract.clear_memory && UtilPlume.usedMemory(true) > GenInputsAbstract.clear_memory) {
            this.componentManager.clearGeneratedSequences();
        }
        if ((eSeq = this.createNewUniqueSequence()) == null) {
            long gentime = System.nanoTime() - startTime;
            if (gentime > 1000000000L) {
                System.out.printf("Long generation time %d msec for null sequence.%n", gentime / 1000000L);
            }
            return null;
        }
        if (GenInputsAbstract.dontexecute) {
            this.componentManager.addGeneratedSequence(eSeq.sequence);
            long gentime = System.nanoTime() - startTime;
            if (gentime > 1000000000L) {
                System.out.printf("Long generation time %d msec for%n", gentime / 1000000L);
                System.out.println(eSeq.sequence);
            }
            return null;
        }
        this.setCurrentSequence(eSeq.sequence);
        long gentime1 = System.nanoTime() - startTime;
        eSeq.execute(this.executionVisitor, this.checkGenerator);
        startTime = System.nanoTime();
        this.determineActiveIndices(eSeq);
        if (eSeq.sequence.hasActiveFlags()) {
            this.componentManager.addGeneratedSequence(eSeq.sequence);
        }
        long gentime2 = System.nanoTime() - startTime;
        eSeq.gentime = gentime1 + gentime2;
        if (eSeq.gentime > 1000000000L) {
            System.out.printf("Long generation time %d msec (= %d + %d) for%n", eSeq.gentime / 1000000L, gentime1 / 1000000L, gentime2 / 1000000L);
            System.out.println(eSeq.sequence);
        }
        if (eSeq.exectime > 10000000000L) {
            System.out.printf("Long execution time %d sec for%n", eSeq.exectime / 1000000000L);
            System.out.println(eSeq.sequence);
        }
        return eSeq;
    }

    @Override
    public @SignatureUnknown LinkedHashSet<@SignatureUnknown Sequence> getAllSequences() {
        return this.allSequences;
    }

    private void determineActiveIndices(@SignatureUnknown ExecutableSequence seq) {
        if (seq.hasNonExecutedStatements()) {
            Log.logPrintf("Sequence has non-executed statements: excluding from extension pool.%n", new Object[0]);
            Log.logPrintf("Non-executed statement: %s%n", seq.statementToCodeString(seq.getNonExecutedIndex()));
            seq.sequence.clearAllActiveFlags();
            return;
        }
        if (seq.hasFailure()) {
            Log.logPrintf("Sequence has failure: excluding from extension pool.%n", new Object[0]);
            Log.logPrintf("Failing sequence: %s%n", seq.toCodeString());
            seq.sequence.clearAllActiveFlags();
            return;
        }
        if (seq.hasInvalidBehavior()) {
            Log.logPrintf("Sequence has invalid behavior (%s): excluding from extension pool.%n", seq.getChecks());
            Log.logPrintf("Invalid sequence: %s%n", seq.toCodeString());
            seq.sequence.clearAllActiveFlags();
            return;
        }
        if (!seq.isNormalExecution()) {
            int i = seq.getNonNormalExecutionIndex();
            Log.logPrintf("Excluding from extension pool due to exception or failure in statement %d%n", i);
            Log.logPrintf("  Statement: %s%n", seq.statementToCodeString(i));
            Log.logPrintf("  Result: %s%n", seq.getResult(i));
            seq.sequence.clearAllActiveFlags();
            return;
        }
        if (!Value.lastValueSizeOk(seq)) {
            int i = seq.sequence.statements.size() - 1;
            Log.logPrintf("Excluding from extension pool due to value too large in last statement %d%n", i);
            Log.logPrintf("  Statement: %s%n", seq.statementToCodeString(i));
            seq.sequence.clearAllActiveFlags();
            return;
        }
        for (int i = 0; i < seq.sequence.size(); ++i) {
            Class<?> objectClass;
            NormalExecution e = (NormalExecution)seq.getResult(i);
            Object runtimeValue = e.getRuntimeValue();
            if (runtimeValue == null) {
                Log.logPrintf("Making index " + i + " inactive (value is null)%n", new Object[0]);
                seq.sequence.clearActiveFlag(i);
                continue;
            }
            Sequence stmts = seq.sequence;
            Statement stmt = stmts.statements.get(i);
            boolean isSideEffectFree = stmt.isMethodCall() && this.sideEffectFreeMethods.contains(stmt.getOperation());
            Log.logPrintf("isSideEffectFree => %s for %s%n", isSideEffectFree, stmt);
            if (isSideEffectFree) {
                List<Integer> inputVars = stmts.getInputsAsAbsoluteIndices(i);
                for (Integer inputIndex : inputVars) {
                    seq.sequence.clearActiveFlag(inputIndex);
                }
            }
            if ((objectClass = runtimeValue.getClass()).isArray() && !Value.arrayLengthOk(runtimeValue)) {
                seq.sequence.clearActiveFlag(i);
            }
            if (NonreceiverTerm.isNonreceiverType(objectClass) && !objectClass.equals(Class.class)) {
                boolean tooLongString;
                Log.logPrintf("Making index " + i + " inactive (value is a primitive)%n", new Object[0]);
                seq.sequence.clearActiveFlag(i);
                boolean looksLikeObjToString = runtimeValue instanceof String && Value.looksLikeObjectToString((String)runtimeValue);
                boolean bl = tooLongString = runtimeValue instanceof String && !Value.escapedStringLengthOk((String)runtimeValue);
                if (runtimeValue instanceof Double && Double.isNaN((Double)runtimeValue)) {
                    runtimeValue = Double.NaN;
                }
                if (runtimeValue instanceof Float && Float.isNaN(((Float)runtimeValue).floatValue())) {
                    runtimeValue = Float.valueOf(Float.NaN);
                }
                if (looksLikeObjToString || tooLongString || !this.runtimePrimitivesSeen.add(runtimeValue)) continue;
                this.componentManager.addGeneratedSequence(Sequence.createSequenceForPrimitive(runtimeValue));
                continue;
            }
            Log.logPrintf("Making index " + i + " active.%n", new Object[0]);
        }
    }

    private @SignatureUnknown ExecutableSequence createNewUniqueSequence() {
        InputsAndSuccessFlag inputs;
        Log.logPrintf("-------------------------------------------%n", new Object[0]);
        if (Log.isLoggingOn()) {
            Log.logPrintln("Memory used: " + UtilPlume.abbreviateNumber(UtilPlume.usedMemory(false)));
        }
        if (this.operations.isEmpty()) {
            return null;
        }
        TypedOperation operation = this.operationSelector.selectOperation();
        Log.logPrintf("Selected operation: %s%n", operation);
        if (operation.isGeneric() || operation.hasWildcardTypes()) {
            try {
                operation = this.instantiator.instantiate((TypedClassOperation)operation);
            }
            catch (Throwable e) {
                if (GenInputsAbstract.fail_on_generation_error) {
                    if (operation.isMethodCall() || operation.isConstructorCall()) {
                        String opName = operation.getOperation().getReflectionObject().toString();
                        throw new RandoopInstantiationError(opName, e);
                    }
                }
                this.operationHistory.add(operation, OperationOutcome.SEQUENCE_DISCARDED);
                Log.logPrintf("Sequence discarded: Instantiation error for operation%n %s%n", operation);
                Log.logStackTrace(e);
                System.out.printf("Instantiation error for operation%n %s%n", operation);
                return null;
            }
            if (operation == null) {
                Log.logPrintf("Failed to instantiate generic operation%n", operation);
                return null;
            }
        }
        try {
            inputs = this.selectInputs(operation);
        }
        catch (Throwable e) {
            if (GenInputsAbstract.fail_on_generation_error) {
                throw new RandoopGenerationError(operation, e);
            }
            this.operationHistory.add(operation, OperationOutcome.SEQUENCE_DISCARDED);
            Log.logPrintf("Sequence discarded: Error selecting inputs for operation: %s%n", operation);
            Log.logStackTrace(e);
            System.out.println("Error selecting inputs for operation: " + operation);
            e.printStackTrace(System.out);
            return null;
        }
        if (!inputs.success) {
            this.operationHistory.add(operation, OperationOutcome.NO_INPUTS_FOUND);
            Log.logPrintf("Failed to find inputs for operation: %s%n", operation);
            return null;
        }
        Sequence concatSeq = Sequence.concatenate(inputs.sequences);
        ArrayList<Variable> inputVars = new ArrayList<Variable>();
        for (Integer inputIndex : inputs.indices) {
            Variable v = concatSeq.getVariable(inputIndex);
            inputVars.add(v);
        }
        Sequence newSequence = concatSeq.extend(operation, inputVars);
        if (GenInputsAbstract.repeat_heuristic && Randomness.nextRandomInt(10) == 0) {
            int times = Randomness.nextRandomInt(100);
            newSequence = this.repeat(newSequence, operation, times);
            Log.logPrintf("repeat-heuristic>>> %s %s%n", times, newSequence.toCodeString());
        }
        if (operation.getInputTypes().isEmpty()) {
            this.operationHistory.add(operation, OperationOutcome.REMOVED);
            this.operations.remove(operation);
        }
        if (newSequence.size() > GenInputsAbstract.maxsize) {
            this.operationHistory.add(operation, OperationOutcome.SEQUENCE_DISCARDED);
            Log.logPrintf("Sequence discarded: size %d exceeds maximum allowed size %d%n", newSequence.size(), GenInputsAbstract.maxsize);
            return null;
        }
        this.randoopConsistencyTests(newSequence);
        if (this.allSequences.contains(newSequence)) {
            this.operationHistory.add(operation, OperationOutcome.SEQUENCE_DISCARDED);
            Log.logPrintf("Sequence discarded: the same sequence was previously created.%n", new Object[0]);
            return null;
        }
        this.allSequences.add(newSequence);
        this.randoopConsistencyTest2(newSequence);
        Log.logPrintf("Successfully created new unique sequence:%n%s%n", newSequence.toString());
        ExecutableSequence result = new ExecutableSequence(newSequence);
        result.componentSequences = inputs.sequences;
        return result;
    }

    private @SignatureUnknown Sequence repeat(@SignatureUnknown Sequence seq, @SignatureUnknown TypedOperation operation, @SignatureUnknown int times) {
        Sequence retval = new Sequence(seq.statements);
        for (int i = 0; i < times; ++i) {
            ArrayList<Integer> vil = new ArrayList<Integer>();
            for (Variable v : retval.getInputs(retval.size() - 1)) {
                if (v.getType().equals(JavaTypes.INT_TYPE)) {
                    int randint = Randomness.nextRandomInt(100);
                    retval = retval.extend(TypedOperation.createPrimitiveInitialization(JavaTypes.INT_TYPE, randint), new Variable[0]);
                    vil.add(retval.size() - 1);
                    continue;
                }
                vil.add(v.getDeclIndex());
            }
            ArrayList<Variable> vl = new ArrayList<Variable>();
            for (Integer vi : vil) {
                vl.add(retval.getVariable(vi));
            }
            retval = retval.extend(operation, vl);
        }
        return retval;
    }

    private void randoopConsistencyTest2(@SignatureUnknown Sequence newSequence) {
        if (GenInputsAbstract.debug_checks) {
            this.allsequencesAsCode.add(newSequence.toCodeString());
            this.allsequencesAsList.add(newSequence);
        }
    }

    private void randoopConsistencyTests(@SignatureUnknown Sequence newSequence) {
        if (GenInputsAbstract.debug_checks) {
            String code = newSequence.toCodeString();
            if (this.allSequences.contains(newSequence)) {
                if (!this.allsequencesAsCode.contains(code)) {
                    throw new IllegalStateException(code);
                }
            } else if (this.allsequencesAsCode.contains(code)) {
                int index = this.allsequencesAsCode.indexOf(code);
                StringBuilder b = new StringBuilder();
                Sequence co = this.allsequencesAsList.get(index);
                assert (co.equals(newSequence));
                b.append("new component:").append(Globals.lineSep).append("").append(newSequence.toString()).append("").append(Globals.lineSep).append("as code:").append(Globals.lineSep).append("").append(code).append(Globals.lineSep);
                b.append("existing component:").append(Globals.lineSep).append("").append(this.allsequencesAsList.get(index).toString()).append("").append(Globals.lineSep).append("as code:").append(Globals.lineSep).append("").append(this.allsequencesAsList.get(index).toCodeString());
                throw new IllegalStateException(b.toString());
            }
        }
    }

    private @SignatureUnknown InputsAndSuccessFlag selectInputs(@SignatureUnknown TypedOperation operation) {
        TypeTuple inputTypes = operation.getInputTypes();
        Log.logPrintf("selectInputs:  inputTypes=%s%n", inputTypes);
        ArrayList<Sequence> sequences = new ArrayList<Sequence>();
        int totStatements = 0;
        ArrayList<Integer> variables = new ArrayList<Integer>();
        SubTypeSet types = new SubTypeSet(false);
        MultiMap<Type, Integer> typesToVars = new MultiMap<Type, Integer>();
        for (int i = 0; i < inputTypes.size(); ++i) {
            SimpleList<Sequence> candidates;
            boolean isReceiver;
            Type inputType = inputTypes.get(i);
            boolean bl = isReceiver = i == 0 && operation.isMessage() && !operation.isStatic();
            if (GenInputsAbstract.alias_ratio != 0.0 && Randomness.weightedCoinFlip(GenInputsAbstract.alias_ratio)) {
                ArrayList candidateVars = new ArrayList();
                for (Type match : types.getMatches(inputType)) {
                    assert (typesToVars.keySet().contains(match));
                    candidateVars.add(new SimpleArrayList(typesToVars.getValues(match)));
                }
                ListOfLists candidateVars2 = new ListOfLists(candidateVars);
                if (!candidateVars2.isEmpty()) {
                    int randVarIdx = Randomness.nextRandomInt(candidateVars2.size());
                    Integer randVar = (Integer)candidateVars2.get(randVarIdx);
                    variables.add(randVar);
                    continue;
                }
            }
            if (!isReceiver && GenInputsAbstract.null_ratio != 0.0 && Randomness.weightedCoinFlip(GenInputsAbstract.null_ratio)) {
                Log.logPrintf("Using null as input.%n", new Object[0]);
                TypedOperation st = TypedOperation.createNullOrZeroInitializationForType(inputType);
                Sequence seq = new Sequence().extend(st, Collections.emptyList());
                variables.add(totStatements);
                sequences.add(seq);
                assert (seq.size() == 1);
                ++totStatements;
                continue;
            }
            if (inputType.isArray()) {
                Log.logPrintf("Array creation heuristic: will create helper array of type %s%n", inputType);
                SimpleList<Sequence> l1 = this.componentManager.getSequencesForType(operation, i, isReceiver);
                SimpleList<Sequence> l2 = HelperSequenceCreator.createArraySequence(this.componentManager, inputType);
                candidates = new ListOfLists<Sequence>(l1, l2);
                Log.logPrintf("Array creation heuristic: " + candidates.size() + " candidates%n", new Object[0]);
            } else if (inputType.isParameterized() && ((InstantiatedType)inputType).getGenericClassType().isSubtypeOf(JDKTypes.COLLECTION_TYPE)) {
                InstantiatedType classType = (InstantiatedType)inputType;
                SimpleList<Sequence> l1 = this.componentManager.getSequencesForType(operation, i, isReceiver);
                Log.logPrintf("Collection creation heuristic: will create helper of type %s%n", classType);
                SimpleArrayList<Sequence> l2 = new SimpleArrayList<Sequence>();
                Sequence creationSequence = HelperSequenceCreator.createCollection(this.componentManager, classType);
                if (creationSequence != null) {
                    l2.add(creationSequence);
                }
                candidates = new ListOfLists<Sequence>(l1, l2);
            } else {
                Log.logPrintf("Will query component set for objects of type %s%n", inputType);
                candidates = this.componentManager.getSequencesForType(operation, i, isReceiver);
            }
            assert (candidates != null);
            Log.logPrintf("number of candidate components: %s%n", candidates.size());
            if (candidates.isEmpty()) {
                if (isReceiver) {
                    Log.logPrintf("No sequences of receiver type.%n", new Object[0]);
                    return new InputsAndSuccessFlag(false, null, null);
                }
                if (GenInputsAbstract.forbid_null) {
                    Log.logPrintf("No sequences of type, and forbid-null option is true. Failed to create new sequence.%n", new Object[0]);
                    return new InputsAndSuccessFlag(false, null, null);
                }
                Log.logPrintf("Found no sequences of required type; will use null as " + i + "-th input%n", new Object[0]);
                TypedOperation st = TypedOperation.createNullOrZeroInitializationForType(inputType);
                Sequence seq = new Sequence().extend(st, Collections.emptyList());
                variables.add(totStatements);
                sequences.add(seq);
                assert (seq.size() == 1);
                ++totStatements;
                continue;
            }
            VarAndSeq varAndSeq = this.randomVariable(candidates, inputType, isReceiver);
            Variable randomVariable = varAndSeq.var;
            Sequence chosenSeq = varAndSeq.seq;
            if (GenInputsAbstract.alias_ratio != 0.0) {
                for (int j = 0; j < chosenSeq.size(); ++j) {
                    Statement stk = chosenSeq.getStatement(j);
                    if (stk.isNonreceivingInitialization()) continue;
                    Type outType = stk.getOutputType();
                    types.add(outType);
                    typesToVars.add(outType, totStatements + j);
                }
            }
            variables.add(totStatements + randomVariable.index);
            sequences.add(chosenSeq);
            totStatements += chosenSeq.size();
        }
        return new InputsAndSuccessFlag(true, sequences, variables);
    }

    @SignatureUnknown VarAndSeq randomVariable(@SignatureUnknown SimpleList<@SignatureUnknown Sequence> candidates, @SignatureUnknown Type inputType, @SignatureUnknown boolean isReceiver) {
        for (int i = 0; i < 10; ++i) {
            Sequence chosenSeq = this.inputSequenceSelector.selectInputSequence(candidates);
            Log.logPrintf("chosenSeq: %s%n", chosenSeq);
            Variable randomVariable = chosenSeq.randomVariableForTypeLastStatement(inputType, isReceiver);
            if (randomVariable == null) continue;
            if (isReceiver && (chosenSeq.getCreatingStatement(randomVariable).isNonreceivingInitialization() || randomVariable.getType().isPrimitive())) {
                System.out.println();
                System.out.println("Selected null or a primitive as the receiver for a method call.");
                System.out.printf("  isReceiver = %s%n", isReceiver);
                System.out.printf("  randomVariable = %s%n", randomVariable);
                System.out.printf("    getType() = %s%n", randomVariable.getType());
                System.out.printf("    isPrimitive = %s%n", randomVariable.getType().isPrimitive());
                System.out.printf("  chosenSeq = {%n%s}%n", chosenSeq);
                System.out.printf("    getCreatingStatement = %s%n", chosenSeq.getCreatingStatement(randomVariable));
                System.out.printf("    isNonreceivingInitialization = %s%n", chosenSeq.getCreatingStatement(randomVariable).isNonreceivingInitialization());
                continue;
            }
            return new VarAndSeq(randomVariable, chosenSeq);
        }
        assert (isReceiver);
        ArrayList<VarAndSeq> validResults = new ArrayList<VarAndSeq>();
        for (int i = 0; i < candidates.size(); ++i) {
            Sequence s2 = candidates.get(i);
            Variable randomVariable = s2.randomVariableForTypeLastStatement(inputType, isReceiver);
            validResults.add(new VarAndSeq(randomVariable, s2));
        }
        if (validResults.isEmpty()) {
            throw new RandoopBug(String.format("In randomVariable, no candidates for %svariable with input type %s", isReceiver ? "receiver " : "", inputType));
        }
        return (VarAndSeq)Randomness.randomMember(validResults);
    }

    @Override
    public @SignatureUnknown int numGeneratedSequences() {
        return this.allSequences.size();
    }

    @SideEffectFree
    public @SignatureUnknown String toString() {
        return "ForwardGenerator(" + String.join((CharSequence)(";" + Globals.lineSep + "    "), String.join((CharSequence)", ", "steps: " + this.num_steps, "null steps: " + this.null_steps, "num_sequences_generated: " + this.num_sequences_generated), String.join((CharSequence)", ", "allSequences: " + this.allSequences.size(), "regresson seqs: " + this.outRegressionSeqs.size(), "error seqs: " + this.outErrorSeqs.size() + "=" + this.num_failing_sequences + "=" + this.getErrorTestSequences().size(), "invalid seqs: " + this.invalidSequenceCount, "subsumed_sequences: " + this.subsumed_sequences.size(), "num_failed_output_test: " + this.num_failed_output_test), String.join((CharSequence)("sideEffectFreeMethods:" + this.sideEffectFreeMethods.size()), "runtimePrimitivesSeen:" + this.runtimePrimitivesSeen.size())) + ")";
    }

    private static class VarAndSeq {
        final @SignatureUnknown Variable var;
        final @SignatureUnknown Sequence seq;

        VarAndSeq(@SignatureUnknown Variable var, @SignatureUnknown Sequence seq) {
            this.var = var;
            this.seq = seq;
        }
    }
}

