/*
 * Decompiled with CFR 0.152.
 */
package randoop.execution;

import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import randoop.execution.RunCommand;
import randoop.main.GenInputsAbstract;

public class TestEnvironment {
    private @SignatureUnknown long timeout = 900000L;
    private final @SignatureUnknown String testClasspath;
    private final @SignatureUnknown LinkedHashMap<@SignatureUnknown Path, @SignatureUnknown String> agentMap = new LinkedHashMap();
    private @SignatureUnknown Path replaceCallAgentPath;
    private @SignatureUnknown String replaceCallAgentArgs;

    public TestEnvironment(@SignatureUnknown String testClasspath) {
        this.testClasspath = testClasspath;
    }

    public void addAgent(@SignatureUnknown Path agentPath, @SignatureUnknown String agentArgumentString) {
        this.agentMap.put(agentPath, agentArgumentString);
    }

    public void setReplaceCallAgent(@SignatureUnknown Path agentPath, @SignatureUnknown String agentArgs) {
        this.replaceCallAgentPath = agentPath;
        this.replaceCallAgentArgs = agentArgs;
    }

    public void setTimeout(@SignatureUnknown long timeout) {
        this.timeout = timeout;
    }

    public @SignatureUnknown RunCommand.Status runTest(@SignatureUnknown String testClassName, @SignatureUnknown Path workingDirectory) throws @SignatureUnknown RunCommand.CommandException {
        List<String> command = this.commandPrefix();
        command.add(testClassName);
        return RunCommand.run(command, workingDirectory, this.timeout);
    }

    private @SignatureUnknown List<@SignatureUnknown String> commandPrefix() {
        ArrayList<String> command = new ArrayList<String>();
        command.add("java");
        command.add("-ea");
        command.add("-Xmx" + GenInputsAbstract.jvm_max_memory);
        command.add("-XX:+HeapDumpOnOutOfMemoryError");
        if (this.replaceCallAgentPath != null) {
            command.add("-Xbootclasspath/a:" + this.replaceCallAgentPath);
            command.add(this.getJavaagentOption(this.replaceCallAgentPath, this.replaceCallAgentArgs));
        }
        for (Map.Entry<Path, String> entry : this.agentMap.entrySet()) {
            String args = entry.getValue();
            command.add(this.getJavaagentOption(entry.getKey(), args));
        }
        command.add("-classpath");
        command.add("." + File.pathSeparator + this.testClasspath);
        command.add("org.junit.runner.JUnitCore");
        return command;
    }

    private @SignatureUnknown String getJavaagentOption(@SignatureUnknown Path agentPath, @SignatureUnknown String args) {
        String agent = "-javaagent:" + agentPath;
        if (args != null && !args.isEmpty()) {
            agent = agent + "=" + args;
        }
        return agent;
    }
}

