/*
 * Decompiled with CFR 0.152.
 */
package randoop.execution;

import coveredclass.org.apache.commons.exec.CommandLine;
import coveredclass.org.apache.commons.exec.DefaultExecuteResultHandler;
import coveredclass.org.apache.commons.exec.DefaultExecutor;
import coveredclass.org.apache.commons.exec.ExecuteWatchdog;
import coveredclass.org.apache.commons.exec.PumpStreamHandler;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import coveredclass.org.checkerframework.dataflow.qual.SideEffectFree;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import org.plumelib.util.UtilPlume;
import randoop.Globals;
import randoop.util.Log;

public class RunCommand {
    static @SignatureUnknown Status run(@SignatureUnknown List<@SignatureUnknown String> command, @SignatureUnknown Path workingDirectory, @SignatureUnknown long timeout) throws @SignatureUnknown CommandException {
        List<String> errorOutputLines;
        List<String> standardOutputLines;
        String[] args = command.toArray(new String[0]);
        CommandLine cmdLine = new CommandLine(args[0]);
        cmdLine.addArguments(Arrays.copyOfRange(args, 1, args.length));
        DefaultExecuteResultHandler resultHandler = new DefaultExecuteResultHandler();
        DefaultExecutor executor = new DefaultExecutor();
        executor.setWorkingDirectory(workingDirectory.toFile());
        ExecuteWatchdog watchdog = new ExecuteWatchdog(timeout);
        executor.setWatchdog(watchdog);
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        ByteArrayOutputStream errStream = new ByteArrayOutputStream();
        PumpStreamHandler streamHandler = new PumpStreamHandler(outStream, errStream);
        executor.setStreamHandler(streamHandler);
        Log.logPrintf("RunCommand.run():%n", new Object[0]);
        Log.logPrintf("  cd %s; %s%n", workingDirectory, UtilPlume.join((CharSequence)" ", command));
        Log.logPrintf("  timeout=%s, environment: %s%n", timeout, System.getenv());
        try {
            executor.execute(cmdLine, resultHandler);
        }
        catch (IOException e) {
            throw new CommandException("Exception starting process", e);
        }
        int exitValue = -1;
        try {
            resultHandler.waitFor();
            exitValue = resultHandler.getExitValue();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        boolean timedOut = executor.isFailure(exitValue) && watchdog.killedProcess();
        try {
            standardOutputLines = Arrays.asList(outStream.toString().split(Globals.lineSep));
        }
        catch (RuntimeException e) {
            throw new CommandException("Exception getting process standard output", e);
        }
        try {
            errorOutputLines = Arrays.asList(errStream.toString().split(Globals.lineSep));
        }
        catch (RuntimeException e) {
            throw new CommandException("Exception getting process error output", e);
        }
        return new Status(command, exitValue, timedOut, standardOutputLines, errorOutputLines);
    }

    public static class CommandException
    extends Throwable {
        private static final @SignatureUnknown long serialVersionUID = 736230736083495268L;

        CommandException(@SignatureUnknown String message, @SignatureUnknown Throwable cause) {
            super(message, cause);
        }
    }

    public static class Status {
        public final @SignatureUnknown List<@SignatureUnknown String> command;
        public final @SignatureUnknown int exitStatus;
        public final @SignatureUnknown boolean timedOut;
        public final @SignatureUnknown List<@SignatureUnknown String> standardOutputLines;
        public final @SignatureUnknown List<@SignatureUnknown String> errorOutputLines;

        Status(@SignatureUnknown List<@SignatureUnknown String> command, @SignatureUnknown int exitStatus, @SignatureUnknown boolean timedOut, @SignatureUnknown List<@SignatureUnknown String> standardOutputLines, @SignatureUnknown List<@SignatureUnknown String> errorOutputLines) {
            this.command = command;
            this.exitStatus = exitStatus;
            this.timedOut = timedOut;
            this.standardOutputLines = standardOutputLines;
            this.errorOutputLines = errorOutputLines;
        }

        @SideEffectFree
        public @SignatureUnknown String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("Status %d (timedOut=%s) for command \"%s\"", this.exitStatus, this.timedOut, UtilPlume.join((CharSequence)" ", this.command)));
            this.describeLines("stdout", this.standardOutputLines, sb);
            this.describeLines("stderr", this.errorOutputLines, sb);
            return sb.toString();
        }

        private void describeLines(@SignatureUnknown String source, @SignatureUnknown List<@SignatureUnknown String> lines, @SignatureUnknown StringBuilder sb) {
            if (lines.size() <= 2) {
                sb.append(", ");
                sb.append(source);
                sb.append("=\"");
                sb.append(UtilPlume.joinLines(lines));
                sb.append("\"");
                sb.append(Globals.lineSep);
            } else {
                sb.append(", ");
                sb.append(source);
                sb.append(" lines=");
                sb.append(lines.size());
            }
        }
    }
}

