/*
 * Decompiled with CFR 0.152.
 */
package randoop.contract;

import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import java.util.Arrays;
import java.util.Collection;
import randoop.contract.ObjectContract;
import randoop.types.JavaTypes;
import randoop.types.TypeTuple;

public final class SizeToArrayLength
extends ObjectContract {
    private static final @SignatureUnknown SizeToArrayLength instance = new SizeToArrayLength();
    static @SignatureUnknown TypeTuple inputTypes = new TypeTuple(Arrays.asList(JavaTypes.COLLECTION_TYPE));

    private SizeToArrayLength() {
    }

    public static @SignatureUnknown SizeToArrayLength getInstance() {
        return instance;
    }

    @Override
    public @SignatureUnknown boolean evaluate(Object ... objects) {
        assert (objects != null && objects.length == 1);
        Object o = objects[0];
        if (o instanceof Collection) {
            Collection c = (Collection)o;
            assert (c != null);
            return c.size() == c.toArray().length;
        }
        return true;
    }

    @Override
    public @SignatureUnknown int getArity() {
        return 1;
    }

    @Override
    public @SignatureUnknown TypeTuple getInputTypes() {
        return inputTypes;
    }

    @Override
    public @SignatureUnknown String toCommentString() {
        return "x0.toArray().length == x0.size()";
    }

    @Override
    public @SignatureUnknown String get_observer_str() {
        return "SizeToArrayLength";
    }

    @Override
    public @SignatureUnknown String toCodeString() {
        StringBuilder b = new StringBuilder();
        b.append("org.junit.Assert.assertEquals(");
        b.append("\"Contract failed: " + this.toCommentString() + "\", ");
        b.append("x0.toArray().length, x0.size()");
        b.append(");");
        return b.toString();
    }
}

