/*
 * Decompiled with CFR 0.152.
 */
package randoop.contract;

import coveredclass.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import coveredclass.org.checkerframework.dataflow.qual.Pure;
import coveredclass.org.checkerframework.dataflow.qual.SideEffectFree;
import java.util.Arrays;
import java.util.Objects;
import org.plumelib.util.UtilPlume;
import randoop.contract.ObjectContract;
import randoop.sequence.StringTooLongException;
import randoop.sequence.Value;
import randoop.types.JavaTypes;
import randoop.types.Type;
import randoop.types.TypeTuple;

public final class PrimValue
extends ObjectContract {
    public final @SignatureUnknown Object value;
    private final @SignatureUnknown EqualityMode equalityMode;
    static @SignatureUnknown TypeTuple inputTypes = new TypeTuple(Arrays.asList(JavaTypes.OBJECT_TYPE));

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @SignatureUnknown boolean equals(@SignatureUnknown Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PrimValue)) {
            return false;
        }
        PrimValue other = (PrimValue)o;
        return this.value.equals(other.value);
    }

    @Pure
    public @SignatureUnknown int hashCode() {
        return Objects.hash(this.value);
    }

    public PrimValue(@SignatureUnknown Object value, @SignatureUnknown EqualityMode equalityMode) {
        if (value == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
        Type type = Type.forClass(value.getClass());
        if (!type.isBoxedPrimitive() && !type.isString()) {
            throw new IllegalArgumentException("value is not a primitive or string : " + value.getClass());
        }
        if (value instanceof String && !Value.escapedStringLengthOk((String)value)) {
            throw new StringTooLongException((String)value);
        }
        this.value = value;
        this.equalityMode = equalityMode;
    }

    @Override
    public @SignatureUnknown boolean evaluate(Object ... objects) throws @SignatureUnknown Throwable {
        assert (objects.length == 1);
        return this.value.equals(objects[0]);
    }

    @Override
    public @SignatureUnknown int getArity() {
        return 1;
    }

    @Override
    public @SignatureUnknown TypeTuple getInputTypes() {
        return inputTypes;
    }

    @SideEffectFree
    public @SignatureUnknown String toString() {
        return "randoop.PrimValue, value=" + UtilPlume.escapeJava(this.value.toString());
    }

    @Override
    public @SignatureUnknown String get_observer_str() {
        return "PrimValue";
    }

    @Override
    public @SignatureUnknown String toCodeString() {
        if (this.value.equals(Double.NaN)) {
            return "org.junit.Assert.assertTrue(Double.isNaN(x0));";
        }
        if (this.value.equals(Float.valueOf(Float.NaN))) {
            return "org.junit.Assert.assertTrue(Float.isNaN(x0));";
        }
        if (this.equalityMode.equals((Object)EqualityMode.EQUALSMETHOD)) {
            StringBuilder b = new StringBuilder();
            b.append("org.junit.Assert.assertEquals(");
            b.append("\"'\" + x0 + \"' != '\" + ").append(Value.toCodeString(this.value)).append("+ \"'\", ");
            b.append("x0");
            b.append(", ");
            b.append(Value.toCodeString(this.value));
            b.append(");");
            return b.toString();
        }
        if (this.equalityMode.equals((Object)EqualityMode.EQUALSEQUALS)) {
            StringBuilder b = new StringBuilder();
            b.append("org.junit.Assert.assertTrue(");
            b.append("\"'\" + x0 + \"' != '\" + ").append(Value.toCodeString(this.value)).append("+ \"'\", ");
            b.append("x0 == ").append(Value.toCodeString(this.value));
            b.append(");");
            return b.toString();
        }
        throw new Error("unexpected equalityMode " + (Object)((Object)this.equalityMode));
    }

    @Override
    public @SignatureUnknown String toCommentString() {
        return null;
    }

    public static enum EqualityMode {
        EQUALSEQUALS,
        EQUALSMETHOD;

    }
}

