/*
 * Decompiled with CFR 0.152.
 */
package randoop.contract;

import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import java.util.Arrays;
import randoop.contract.ObjectContract;
import randoop.types.JavaTypes;
import randoop.types.TypeTuple;

public final class EqualsHashcode
extends ObjectContract {
    private static final @SignatureUnknown EqualsHashcode instance = new EqualsHashcode();
    static @SignatureUnknown TypeTuple inputTypes = new TypeTuple(Arrays.asList(JavaTypes.OBJECT_TYPE, JavaTypes.OBJECT_TYPE));

    private EqualsHashcode() {
    }

    public static @SignatureUnknown EqualsHashcode getInstance() {
        return instance;
    }

    @Override
    public @SignatureUnknown boolean evaluate(Object ... objects) {
        Object o1 = objects[0];
        Object o2 = objects[1];
        return !o1.equals(o2) || o1.hashCode() == o2.hashCode();
    }

    @Override
    public @SignatureUnknown int getArity() {
        return 2;
    }

    @Override
    public @SignatureUnknown TypeTuple getInputTypes() {
        return inputTypes;
    }

    @Override
    public @SignatureUnknown String toCommentString() {
        return "equals-hashcode on x0 and x1";
    }

    @Override
    public @SignatureUnknown String get_observer_str() {
        return "EqualsHashcode";
    }

    @Override
    public @SignatureUnknown String toCodeString() {
        StringBuilder b = new StringBuilder();
        b.append("org.junit.Assert.assertTrue(");
        b.append("\"Contract failed: ").append(this.toCommentString()).append("\", ");
        b.append("x0.equals(x1) ? x0.hashCode() == x1.hashCode() : true");
        b.append(");");
        return b.toString();
    }
}

