/*
 * Decompiled with CFR 0.152.
 */
package randoop.contract;

import coveredclass.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureBottom;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import coveredclass.org.checkerframework.dataflow.qual.Pure;
import coveredclass.org.checkerframework.dataflow.qual.SideEffectFree;
import java.util.Collections;
import java.util.Objects;
import randoop.contract.ObjectContract;
import randoop.types.Type;
import randoop.types.TypeTuple;

public final class EnumValue
extends ObjectContract {
    public final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Enum<@SignatureUnknown @SignatureBottom ?> value;
    private final @SignatureUnknown Type type;

    public EnumValue(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Enum<@SignatureUnknown @SignatureBottom ?> value) {
        this.value = value;
        this.type = Type.forClass(value.getDeclaringClass());
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @SignatureUnknown boolean equals(@SignatureUnknown Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EnumValue)) {
            return false;
        }
        EnumValue enumValue = (EnumValue)obj;
        return this.value.equals(enumValue.value);
    }

    @Pure
    public @SignatureUnknown int hashCode() {
        return Objects.hash(this.value);
    }

    @SideEffectFree
    public @SignatureUnknown String toString() {
        return "randoop.contract.EnumValue = " + this.value.name();
    }

    @Override
    public @SignatureUnknown int getArity() {
        return 1;
    }

    @Override
    public @SignatureUnknown TypeTuple getInputTypes() {
        return new TypeTuple(Collections.singletonList(this.type));
    }

    @Override
    public @SignatureUnknown boolean evaluate(Object ... objects) throws @SignatureUnknown Throwable {
        assert (objects.length == 1);
        return this.value.equals(objects[0]);
    }

    @Override
    public @SignatureUnknown String toCommentString() {
        return null;
    }

    public @SignatureUnknown String getValueName() {
        return this.type.getFqName() + "." + this.value.name();
    }

    @Override
    public @SignatureUnknown String toCodeString() {
        String valueName = this.getValueName();
        StringBuilder b = new StringBuilder();
        b.append("org.junit.Assert.assertTrue(");
        b.append("\"'\" + x0 + \"' != '\" + ").append(valueName).append(" + \"'\", ");
        b.append("x0");
        b.append(".equals(");
        b.append(valueName);
        b.append(")");
        b.append(");");
        return b.toString();
    }

    @Override
    public @SignatureUnknown String get_observer_str() {
        return "EnumValue";
    }
}

