/*
 * Decompiled with CFR 0.152.
 */
package randoop.contract;

import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import java.util.Arrays;
import randoop.contract.ObjectContract;
import randoop.types.JavaTypes;
import randoop.types.TypeTuple;

public class CompareToReflexive
extends ObjectContract {
    private static final @SignatureUnknown CompareToReflexive instance = new CompareToReflexive();
    static @SignatureUnknown TypeTuple inputTypes = new TypeTuple(Arrays.asList(JavaTypes.COMPARABLE_TYPE));

    private CompareToReflexive() {
    }

    public static @SignatureUnknown CompareToReflexive getInstance() {
        return instance;
    }

    @Override
    public @SignatureUnknown boolean evaluate(Object ... objects) {
        assert (objects != null && objects.length == 1);
        Object o1 = objects[0];
        assert (o1 != null);
        if (o1 instanceof Comparable) {
            Comparable compObj1 = (Comparable)o1;
            return compObj1.compareTo(compObj1) == 0;
        }
        return true;
    }

    @Override
    public @SignatureUnknown int getArity() {
        return 1;
    }

    @Override
    public @SignatureUnknown TypeTuple getInputTypes() {
        return inputTypes;
    }

    @Override
    public @SignatureUnknown String toCommentString() {
        return "compareTo-reflexive on x0";
    }

    @Override
    public @SignatureUnknown String get_observer_str() {
        return "CompareToReflexive";
    }

    @Override
    public @SignatureUnknown String toCodeString() {
        StringBuilder b = new StringBuilder();
        b.append("org.junit.Assert.assertTrue(");
        b.append("\"Contract failed: " + this.toCommentString() + "\", ");
        b.append("x0.compareTo(x0) == 0");
        b.append(");");
        return b.toString();
    }
}

