/*
 * Decompiled with CFR 0.152.
 */
package randoop.contract;

import coveredclass.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureBottom;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import coveredclass.org.checkerframework.dataflow.qual.Pure;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Objects;
import randoop.Globals;
import randoop.contract.ObjectContract;
import randoop.main.RandoopBug;
import randoop.operation.TypedClassOperation;
import randoop.operation.TypedOperation;
import randoop.types.JavaTypes;
import randoop.types.TypeTuple;

public final class CheckRepContract
extends ObjectContract {
    public final @SignatureUnknown Method checkRepMethod;
    private final @SignatureUnknown TypedClassOperation operation;
    @SignatureUnknown boolean returnsBoolean;
    public final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> declaringClass;

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @SignatureUnknown boolean equals(@SignatureUnknown Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CheckRepContract)) {
            return false;
        }
        CheckRepContract other = (CheckRepContract)o;
        return this.checkRepMethod.equals(other.checkRepMethod);
    }

    @Pure
    public @SignatureUnknown int hashCode() {
        return Objects.hash(this.checkRepMethod);
    }

    public CheckRepContract(@SignatureUnknown Method checkRepMethod) {
        if (checkRepMethod == null) {
            throw new IllegalArgumentException("check-rep method cannot be null.");
        }
        int modifiers = checkRepMethod.getModifiers();
        assert (Modifier.isPublic(modifiers));
        assert (!Modifier.isStatic(modifiers));
        assert (checkRepMethod.getParameterTypes().length == 0);
        this.operation = TypedOperation.forMethod(checkRepMethod);
        if (this.operation.getOutputType().equals(JavaTypes.BOOLEAN_TYPE)) {
            this.returnsBoolean = true;
        } else if (this.operation.getOutputType().equals(JavaTypes.VOID_TYPE)) {
            this.returnsBoolean = false;
        } else {
            throw new IllegalArgumentException("check-rep method must have void or boolean return type");
        }
        this.checkRepMethod = checkRepMethod;
        this.declaringClass = checkRepMethod.getDeclaringClass();
    }

    @Override
    public @SignatureUnknown boolean evaluate(Object ... objects) throws @SignatureUnknown Throwable {
        assert (objects.length == 1);
        assert (objects[0] != null);
        if (this.declaringClass.equals(objects[0].getClass())) {
            try {
                if (this.returnsBoolean) {
                    return (Boolean)this.checkRepMethod.invoke(objects[0], new Object[0]);
                }
                this.checkRepMethod.invoke(objects[0], new Object[0]);
                return true;
            }
            catch (IllegalArgumentException e) {
                throw new RandoopBug(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
        return true;
    }

    @Override
    public @SignatureUnknown int getArity() {
        return 1;
    }

    @Override
    public @SignatureUnknown TypeTuple getInputTypes() {
        return this.operation.getInputTypes();
    }

    @Override
    public @SignatureUnknown String toCommentString() {
        return "Check rep invariant (method " + this.checkRepMethod.getName() + ") for x0";
    }

    @Override
    public @SignatureUnknown String get_observer_str() {
        return "CheckRep " + this.checkRepMethod.getName();
    }

    @Override
    public @SignatureUnknown String toCodeString() {
        StringBuilder b = new StringBuilder();
        b.append(Globals.lineSep);
        b.append("// Check representation invariant.").append(Globals.lineSep);
        if (this.returnsBoolean) {
            b.append("org.junit.Assert.assertTrue(");
            b.append("\"Representation invariant failed: ").append(this.toCommentString()).append("\", ");
            b.append("x0.").append(this.checkRepMethod.getName()).append("()");
            b.append(");");
        } else {
            b.append("x0.").append(this.checkRepMethod.getName()).append("();");
        }
        return b.toString();
    }
}

