/*
 * Decompiled with CFR 0.152.
 */
package randoop.condition.specification;

import coveredclass.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import coveredclass.org.checkerframework.dataflow.qual.Pure;
import java.util.Objects;
import randoop.condition.specification.Guard;

public abstract class SpecificationClause {
    private final @SignatureUnknown String description;
    private final @SignatureUnknown Guard guard;

    protected SpecificationClause() {
        this.description = "";
        this.guard = null;
    }

    protected SpecificationClause(@SignatureUnknown String description, @SignatureUnknown Guard guard) {
        this.description = description;
        this.guard = guard;
    }

    public @SignatureUnknown String getDescription() {
        return this.description;
    }

    public @SignatureUnknown Guard getGuard() {
        return this.guard;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @SignatureUnknown boolean equals(@SignatureUnknown Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SpecificationClause)) {
            return false;
        }
        SpecificationClause other = (SpecificationClause)object;
        return this.description.equals(other.description) && (this.guard != null && this.guard.equals(other.guard) || this.guard == null && other.guard == null);
    }

    @Pure
    public @SignatureUnknown int hashCode() {
        return Objects.hashCode(this.description);
    }
}

