/*
 * Decompiled with CFR 0.152.
 */
package randoop.condition.specification;

import coveredclass.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import coveredclass.org.checkerframework.checker.signature.qual.ClassGetName;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureBottom;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import coveredclass.org.checkerframework.dataflow.qual.Pure;
import coveredclass.org.checkerframework.dataflow.qual.SideEffectFree;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class OperationSignature {
    private final @ClassGetName String classname;
    private final @SignatureUnknown String name;
    private final @SignatureUnknown List<@ClassGetName String> parameterTypes;

    private OperationSignature() {
        this.classname = "";
        this.name = "";
        this.parameterTypes = new ArrayList<String>();
    }

    private OperationSignature(@ClassGetName String classname, @SignatureUnknown String name, @SignatureUnknown List<@ClassGetName String> parameterTypes) {
        this.classname = classname;
        this.name = name;
        this.parameterTypes = parameterTypes;
    }

    public static @SignatureUnknown OperationSignature forConstructorName(@ClassGetName String classname, @SignatureUnknown String simpleName, @SignatureUnknown List<@ClassGetName String> parameterTypes) {
        return new OperationSignature(classname, simpleName, parameterTypes);
    }

    public static @SignatureUnknown OperationSignature forMethodName(@ClassGetName String classname, @SignatureUnknown String name, @SignatureUnknown List<@ClassGetName String> parameterTypes) {
        return new OperationSignature(classname, name, parameterTypes);
    }

    public static @SignatureUnknown OperationSignature of(@SignatureUnknown Method method) {
        return new OperationSignature(method.getDeclaringClass().getName(), method.getName(), OperationSignature.getTypeNames(method.getParameterTypes()));
    }

    public static @SignatureUnknown OperationSignature of(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Constructor<@SignatureUnknown @SignatureBottom ?> constructor) {
        return new OperationSignature(constructor.getDeclaringClass().getName(), constructor.getName(), OperationSignature.getTypeNames(constructor.getParameterTypes()));
    }

    public static @SignatureUnknown OperationSignature of(@SignatureUnknown AccessibleObject op) {
        if (op instanceof Field) {
            return null;
        }
        if (op instanceof Method) {
            return OperationSignature.of((Method)op);
        }
        if (op instanceof Constructor) {
            return OperationSignature.of((Constructor)op);
        }
        throw new Error("how did this happen?");
    }

    public @ClassGetName String getClassname() {
        return this.classname;
    }

    public @SignatureUnknown String getName() {
        return this.name;
    }

    public @SignatureUnknown List<@ClassGetName String> getParameterTypeNames() {
        return this.parameterTypes;
    }

    public @SignatureUnknown boolean isConstructor() {
        return this.name.equals(this.classname);
    }

    public @SignatureUnknown boolean isValid() {
        return this.classname != null && !this.classname.isEmpty() && this.name != null && !this.name.isEmpty() && this.parameterTypes != null;
    }

    private static @SignatureUnknown List<@ClassGetName String> getTypeNames(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> @SignatureUnknown [] classes) {
        ArrayList<@ClassGetName String> parameterTypes = new ArrayList<String>();
        for (Class<?> aClass : classes) {
            parameterTypes.add(aClass.getName());
        }
        return parameterTypes;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @SignatureUnknown boolean equals(@SignatureUnknown Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof OperationSignature)) {
            return false;
        }
        OperationSignature other = (OperationSignature)object;
        return this.classname.equals(other.classname) && this.name.equals(other.name) && this.parameterTypes.equals(other.parameterTypes);
    }

    @Pure
    public @SignatureUnknown int hashCode() {
        return Objects.hash(this.classname, this.name, this.parameterTypes);
    }

    @SideEffectFree
    public @SignatureUnknown String toString() {
        return String.format("{%n \"classname\": \"%s\",%n \"name\": \"%s\",%n \"parameterTypes\": \"%s\"%n}", this.classname, this.name, this.parameterTypes);
    }
}

