/*
 * Decompiled with CFR 0.152.
 */
package randoop.condition.specification;

import coveredclass.com.google.gson.annotations.SerializedName;
import coveredclass.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import coveredclass.org.checkerframework.dataflow.qual.Pure;
import coveredclass.org.checkerframework.dataflow.qual.SideEffectFree;
import java.util.Objects;

public abstract class AbstractBooleanExpression {
    @SerializedName(value="condition")
    private final @SignatureUnknown String conditionSource;
    private final @SignatureUnknown String description;

    private AbstractBooleanExpression() {
        this.conditionSource = "";
        this.description = "";
    }

    AbstractBooleanExpression(@SignatureUnknown String description, @SignatureUnknown String conditionSource) {
        this.description = description;
        this.conditionSource = conditionSource;
    }

    public @SignatureUnknown String getDescription() {
        return this.description;
    }

    public @SignatureUnknown String getConditionSource() {
        return this.conditionSource;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @SignatureUnknown boolean equals(@SignatureUnknown Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AbstractBooleanExpression)) {
            return false;
        }
        AbstractBooleanExpression other = (AbstractBooleanExpression)object;
        return this.description.equals(other.description) && this.conditionSource.equals(other.conditionSource);
    }

    @Pure
    public @SignatureUnknown int hashCode() {
        return Objects.hash(this.description, this.conditionSource);
    }

    @SideEffectFree
    public @SignatureUnknown String toString() {
        return "{ \"description\": \"" + this.description + "\", \"conditionSource\": \"" + this.conditionSource + "\" }";
    }
}

