/*
 * Decompiled with CFR 0.152.
 */
package randoop.condition;

import coveredclass.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import coveredclass.org.checkerframework.dataflow.qual.Pure;
import coveredclass.org.checkerframework.dataflow.qual.SideEffectFree;
import java.util.Objects;
import randoop.types.ClassOrInterfaceType;

public class ThrowsClause {
    private final @SignatureUnknown String comment;
    private final @SignatureUnknown ClassOrInterfaceType exceptionType;

    ThrowsClause(@SignatureUnknown ClassOrInterfaceType exceptionType, @SignatureUnknown String comment) {
        this.exceptionType = exceptionType;
        this.comment = comment;
    }

    public @SignatureUnknown ClassOrInterfaceType getExceptionType() {
        return this.exceptionType;
    }

    public @SignatureUnknown String getComment() {
        return this.comment;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @SignatureUnknown boolean equals(@SignatureUnknown Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ThrowsClause)) {
            return false;
        }
        ThrowsClause other = (ThrowsClause)object;
        return this.exceptionType.equals(other.exceptionType) && this.comment.equals(other.comment);
    }

    @Pure
    public @SignatureUnknown int hashCode() {
        return Objects.hash(this.exceptionType, this.comment);
    }

    @SideEffectFree
    public @SignatureUnknown String toString() {
        return this.exceptionType + " // " + this.comment;
    }
}

