/*
 * Decompiled with CFR 0.152.
 */
package randoop.condition;

import coveredclass.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureBottom;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import coveredclass.org.checkerframework.dataflow.qual.Pure;
import coveredclass.org.checkerframework.dataflow.qual.SideEffectFree;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.plumelib.util.UtilPlume;
import randoop.Globals;
import randoop.compile.SequenceCompiler;
import randoop.compile.SequenceCompilerException;
import randoop.condition.RandoopSpecificationError;
import randoop.main.GenInputsAbstract;
import randoop.main.RandoopBug;
import randoop.output.NameGenerator;
import randoop.reflection.RawSignature;

public class ExecutableBooleanExpression {
    private static final @SignatureUnknown NameGenerator classNameGenerator = new NameGenerator("RandoopExpressionClass");
    private final @SignatureUnknown Method expressionMethod;
    private final @SignatureUnknown String comment;
    private final @SignatureUnknown String contractSource;

    ExecutableBooleanExpression(@SignatureUnknown Method expressionMethod, @SignatureUnknown String comment, @SignatureUnknown String contractSource) {
        this.expressionMethod = expressionMethod;
        this.comment = comment;
        this.contractSource = contractSource;
    }

    ExecutableBooleanExpression(@SignatureUnknown RawSignature signature, @SignatureUnknown String declarations, @SignatureUnknown String expressionSource, @SignatureUnknown String contractSource, @SignatureUnknown String comment, @SignatureUnknown SequenceCompiler compiler) {
        this(ExecutableBooleanExpression.createMethod(signature, declarations, expressionSource, compiler), comment, contractSource);
    }

    @SignatureUnknown ExecutableBooleanExpression addPrestate(@SignatureUnknown Object @SignatureUnknown [] args) {
        return this;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @SignatureUnknown boolean equals(@SignatureUnknown Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ExecutableBooleanExpression)) {
            return false;
        }
        ExecutableBooleanExpression other = (ExecutableBooleanExpression)object;
        return this.expressionMethod.equals(other.expressionMethod) && this.comment.equals(other.comment) && this.contractSource.equals(other.contractSource);
    }

    @Pure
    public @SignatureUnknown int hashCode() {
        return Objects.hash(this.expressionMethod, this.comment, this.contractSource);
    }

    @SideEffectFree
    public @SignatureUnknown String toString() {
        if (this.comment == null || this.comment.isEmpty()) {
            return String.format("ExecutableBooleanExpression{contractSource=%s, expressionMethod=%s}", this.contractSource, this.expressionMethod);
        }
        return String.format("ExecutableBooleanExpression{contractSource=%s, comment=%s, expressionMethod=%s}", this.contractSource, this.comment, this.expressionMethod);
    }

    public @SignatureUnknown boolean check(@SignatureUnknown Object @SignatureUnknown [] values) {
        try {
            return (Boolean)this.expressionMethod.invoke(null, values);
        }
        catch (IllegalAccessException e) {
            throw new RandoopSpecificationError("Failure executing expression method", e);
        }
        catch (InvocationTargetException e) {
            String messageDetails = String.format("  contractSource = %s%n  comment = %s%n  cause = %s", this.contractSource, this.comment, e.getCause());
            if (GenInputsAbstract.ignore_condition_exception) {
                if (!GenInputsAbstract.ignore_condition_exception_quiet) {
                    System.out.printf("Failure executing expression method; fix the specification.%n" + messageDetails, new Object[0]);
                    e.printStackTrace(System.out);
                }
                return false;
            }
            throw new RandoopSpecificationError(String.format("Failure executing expression method.%nFix the specification or pass --ignore-condition-exception=true .%n", new Object[0]) + messageDetails);
        }
    }

    public @SignatureUnknown String getComment() {
        return this.comment;
    }

    public @SignatureUnknown String getContractSource() {
        return this.contractSource;
    }

    static @SignatureUnknown Method createMethod(@SignatureUnknown RawSignature signature, @SignatureUnknown String parameterDeclaration, @SignatureUnknown String expressionSource, @SignatureUnknown SequenceCompiler compiler) {
        Class<?> expressionClass;
        String packageName = signature.getPackageName();
        String classname = classNameGenerator.next();
        String classText = ExecutableBooleanExpression.createConditionClassSource(signature.getName(), expressionSource, parameterDeclaration, packageName, classname);
        try {
            expressionClass = compiler.compileAndLoad(packageName, classname, classText);
        }
        catch (SequenceCompilerException e) {
            String msg = ExecutableBooleanExpression.getCompilerErrorMessage(e.getDiagnostics().getDiagnostics(), classText);
            throw new RandoopSpecificationError(msg, e);
        }
        try {
            return expressionClass.getDeclaredMethod(signature.getName(), signature.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            throw new RandoopBug("Condition class does not contain expression method", e);
        }
    }

    private static @SignatureUnknown String createConditionClassSource(@SignatureUnknown String methodName, @SignatureUnknown String expressionText, @SignatureUnknown String parameterDeclarations, @SignatureUnknown String packageName, @SignatureUnknown String expressionClassName) {
        String packageDeclaration = "";
        if (packageName != null) {
            packageDeclaration = "package " + packageName + ";" + Globals.lineSep + Globals.lineSep;
        }
        return UtilPlume.joinLines(packageDeclaration + "public class " + expressionClassName + " {", "  public static boolean " + methodName + parameterDeclarations + " throws Throwable {", "    return " + expressionText + ";", "  }", "}" + Globals.lineSep);
    }

    private static @SignatureUnknown String getCompilerErrorMessage(@SignatureUnknown List<@SignatureUnknown Diagnostic<@SignatureBottom ? extends @SignatureUnknown JavaFileObject>> diagnostics, @SignatureUnknown String classText) {
        StringBuilder msg = new StringBuilder("Condition method did not compile:");
        msg.append(Globals.lineSep);
        for (Diagnostic<? extends JavaFileObject> diag : diagnostics) {
            if (diag == null) continue;
            String diagMessage = diag.getMessage(null);
            if (diagMessage.contains("unreported exception")) {
                diagMessage = String.format("expression threw exception %s", diagMessage.substring(0, diagMessage.indexOf(59)));
            }
            msg.append(String.format("%d:%d: %s%n", diag.getLineNumber(), diag.getColumnNumber(), diagMessage));
        }
        msg.append(String.format("%nClass Declaration:%n%s", classText));
        return msg.toString();
    }
}

