/*
 * Decompiled with CFR 0.152.
 */
package randoop.compile;

import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

public class FileCompiler {
    private final @SignatureUnknown List<@SignatureUnknown String> options;
    private final @SignatureUnknown JavaCompiler compiler;

    public FileCompiler() {
        this(new ArrayList<String>());
    }

    public FileCompiler(@SignatureUnknown List<@SignatureUnknown String> options) {
        this.options = options;
        this.compiler = ToolProvider.getSystemJavaCompiler();
    }

    public void compile(@SignatureUnknown List<@SignatureUnknown File> sourceFiles, @SignatureUnknown Path destinationDir) throws @SignatureUnknown FileCompilerException {
        ArrayList<String> compilerOptions = new ArrayList<String>(this.options);
        compilerOptions.add("-d");
        compilerOptions.add(destinationDir.toString());
        compilerOptions.add("-XDuseUnsharedTable");
        DiagnosticCollector<JavaFileObject> diagnostics = new DiagnosticCollector<JavaFileObject>();
        StandardJavaFileManager fileManager = this.compiler.getStandardFileManager(diagnostics, null, null);
        Iterable<? extends JavaFileObject> filesToCompile = fileManager.getJavaFileObjectsFromFiles(sourceFiles);
        JavaCompiler.CompilationTask task = this.compiler.getTask(null, fileManager, diagnostics, compilerOptions, null, filesToCompile);
        Boolean succeeded = task.call();
        if (succeeded == null || !succeeded.booleanValue()) {
            throw new FileCompilerException("Compilation failed", sourceFiles, compilerOptions, diagnostics);
        }
    }

    public void compile(@SignatureUnknown Path sourceFile, @SignatureUnknown Path destinationDir) throws @SignatureUnknown FileCompilerException {
        this.compile(Collections.singletonList(sourceFile.toFile()), destinationDir);
    }

    public static class FileCompilerException
    extends Throwable {
        private static final @SignatureUnknown long serialVersionUID = 8362158619216912395L;
        private final @SignatureUnknown List<@SignatureUnknown File> sourceFiles;
        private final @SignatureUnknown List<@SignatureUnknown String> options;
        private final @SignatureUnknown DiagnosticCollector<@SignatureUnknown JavaFileObject> diagnostics;

        FileCompilerException(@SignatureUnknown String message, @SignatureUnknown List<@SignatureUnknown File> sourceFiles, @SignatureUnknown List<@SignatureUnknown String> options, @SignatureUnknown DiagnosticCollector<@SignatureUnknown JavaFileObject> diagnostics) {
            super(message);
            this.sourceFiles = sourceFiles;
            this.options = options;
            this.diagnostics = diagnostics;
        }

        public @SignatureUnknown List<@SignatureUnknown File> getSourceFiles() {
            return this.sourceFiles;
        }

        public @SignatureUnknown List<@SignatureUnknown String> getOptions() {
            return this.options;
        }

        public @SignatureUnknown DiagnosticCollector<@SignatureUnknown JavaFileObject> getDiagnostics() {
            return this.diagnostics;
        }
    }
}

