/*
 * Decompiled with CFR 0.152.
 */
package randoop;

import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import java.util.ArrayList;
import java.util.List;
import randoop.DummyVisitor;
import randoop.ExecutionVisitor;
import randoop.sequence.ExecutableSequence;

public class MultiVisitor
implements ExecutionVisitor {
    private final @SignatureUnknown List<@SignatureUnknown ExecutionVisitor> visitors = new ArrayList<ExecutionVisitor>();

    public MultiVisitor() {
    }

    public static @SignatureUnknown ExecutionVisitor createMultiVisitor(@SignatureUnknown List<@SignatureUnknown ExecutionVisitor> visitors) {
        switch (visitors.size()) {
            case 0: {
                return new DummyVisitor();
            }
            case 1: {
                return visitors.get(0);
            }
        }
        return new MultiVisitor(visitors);
    }

    @Override
    public void initialize(@SignatureUnknown ExecutableSequence eseq) {
        for (ExecutionVisitor visitor : this.visitors) {
            visitor.initialize(eseq);
        }
    }

    public MultiVisitor(@SignatureUnknown List<@SignatureUnknown ExecutionVisitor> visitors) {
        this.visitors.addAll(visitors);
    }

    @Override
    public void visitAfterStatement(@SignatureUnknown ExecutableSequence eseq, @SignatureUnknown int i) {
        for (ExecutionVisitor visitor : this.visitors) {
            visitor.visitAfterStatement(eseq, i);
        }
    }

    @Override
    public void visitBeforeStatement(@SignatureUnknown ExecutableSequence eseq, @SignatureUnknown int i) {
        for (ExecutionVisitor visitor : this.visitors) {
            visitor.visitBeforeStatement(eseq, i);
        }
    }

    @Override
    public void visitAfterSequence(@SignatureUnknown ExecutableSequence eseq) {
        for (ExecutionVisitor visitor : this.visitors) {
            visitor.visitAfterSequence(eseq);
        }
    }
}

