/*
 * Decompiled with CFR 0.152.
 */
package org.plumelib.bcelutil;

import coveredclass.org.apache.bcel.generic.InstructionList;
import coveredclass.org.apache.bcel.generic.MethodGen;
import coveredclass.org.apache.bcel.generic.Type;
import coveredclass.org.apache.bcel.verifier.structurals.Frame;
import coveredclass.org.apache.bcel.verifier.structurals.LocalVariables;
import coveredclass.org.apache.bcel.verifier.structurals.OperandStack;
import coveredclass.org.apache.bcel.verifier.structurals.UninitializedObjectType;
import coveredclass.org.checkerframework.checker.formatter.qual.UnknownFormat;
import coveredclass.org.checkerframework.checker.index.qual.IndexFor;
import coveredclass.org.checkerframework.checker.index.qual.SameLen;
import coveredclass.org.checkerframework.checker.initialization.qual.Initialized;
import coveredclass.org.checkerframework.checker.interning.qual.Interned;
import coveredclass.org.checkerframework.checker.interning.qual.UnknownInterned;
import coveredclass.org.checkerframework.checker.lock.qual.GuardSatisfied;
import coveredclass.org.checkerframework.checker.lock.qual.GuardedBy;
import coveredclass.org.checkerframework.checker.lock.qual.LockPossiblyHeld;
import coveredclass.org.checkerframework.checker.nullness.qual.NonNull;
import coveredclass.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import coveredclass.org.checkerframework.checker.regex.qual.UnknownRegex;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import coveredclass.org.checkerframework.dataflow.qual.SideEffectFree;

public final class StackTypes {
    @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown OperandStack @SameLen(value={"loc_arr"}) @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown [] os_arr;
    @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown LocalVariables @SameLen(value={"os_arr"}) @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown [] loc_arr;

    public StackTypes(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown MethodGen mg) {
        InstructionList il = mg.getInstructionList();
        int size = il == null ? 0 : il.getEnd().getPosition();
        this.os_arr = new OperandStack[size + 1];
        this.loc_arr = new LocalVariables[size + 1];
    }

    public void set(@IndexFor(value={"loc_arr", "os_arr"}) @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown int offset, @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown Frame f) {
        OperandStack os = f.getStack();
        this.loc_arr[offset] = (LocalVariables)f.getLocals().clone();
        this.os_arr[offset] = (OperandStack)os.clone();
    }

    public @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown OperandStack get(@IndexFor(value={"loc_arr", "os_arr"}) @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown int offset) {
        return this.os_arr[offset];
    }

    @SideEffectFree
    public @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown String toString(@GuardSatisfied StackTypes this) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.os_arr.length; ++i) {
            if (this.os_arr[i] == null) continue;
            sb.append(String.format("Instruction %d:\n", i));
            sb.append(String.format("  stack:  %s\n", this.toString(this.os_arr[i])));
            sb.append(String.format("  locals: %s\n", this.toString(this.loc_arr[i])));
        }
        return sb.toString();
    }

    @SideEffectFree
    public @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown String toString(@GuardSatisfied StackTypes this, @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown OperandStack os) {
        String buff = "";
        for (int i = 0; i < os.size(); ++i) {
            Type t;
            if (buff.length() > 0) {
                buff = buff + ", ";
            }
            buff = (t = os.peek(i)) instanceof UninitializedObjectType ? buff + "uninitialized-object" : buff + t;
        }
        return "{" + buff + "}";
    }

    @SideEffectFree
    public @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown String toString(@GuardSatisfied StackTypes this, @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown LocalVariables lv) {
        String buff = "";
        for (int i = 0; i < lv.maxLocals(); ++i) {
            Type t;
            if (buff.length() > 0) {
                buff = buff + ", ";
            }
            buff = (t = lv.get(i)) instanceof UninitializedObjectType ? buff + "uninitialized-object" : buff + t;
        }
        return "{" + buff + "}";
    }
}

