/*
 * Decompiled with CFR 0.152.
 */
package coveredclass.org.github.javaparser.resolution.types;

import coveredclass.org.github.javaparser.resolution.types.ResolvedType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum ResolvedPrimitiveType implements ResolvedType
{
    BYTE("byte", Byte.class.getCanonicalName(), Collections.emptyList()),
    SHORT("short", Short.class.getCanonicalName(), Collections.singletonList(BYTE)),
    CHAR("char", Character.class.getCanonicalName(), Collections.emptyList()),
    INT("int", Integer.class.getCanonicalName(), Arrays.asList(BYTE, SHORT, CHAR)),
    LONG("long", Long.class.getCanonicalName(), Arrays.asList(BYTE, SHORT, INT, CHAR)),
    BOOLEAN("boolean", Boolean.class.getCanonicalName(), Collections.emptyList()),
    FLOAT("float", Float.class.getCanonicalName(), Arrays.asList(LONG, INT, SHORT, BYTE, CHAR)),
    DOUBLE("double", Double.class.getCanonicalName(), Arrays.asList(FLOAT, LONG, INT, SHORT, BYTE, CHAR));

    private String name;
    private String boxTypeQName;
    private List<ResolvedPrimitiveType> promotionTypes;

    private ResolvedPrimitiveType(String name, String boxTypeQName, List<ResolvedPrimitiveType> promotionTypes) {
        this.name = name;
        this.boxTypeQName = boxTypeQName;
        this.promotionTypes = promotionTypes;
    }

    public static ResolvedType byName(String name) {
        name = name.toLowerCase();
        for (ResolvedPrimitiveType ptu : ResolvedPrimitiveType.values()) {
            if (!ptu.describe().equals(name)) continue;
            return ptu;
        }
        throw new IllegalArgumentException("Name " + name);
    }

    public String toString() {
        return "PrimitiveTypeUsage{name='" + this.name + '\'' + '}';
    }

    @Override
    public ResolvedPrimitiveType asPrimitive() {
        return this;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    @Override
    public boolean isReferenceType() {
        return false;
    }

    @Override
    public String describe() {
        return this.name;
    }

    @Override
    public boolean isTypeVariable() {
        return false;
    }

    @Override
    public boolean isAssignableBy(ResolvedType other) {
        if (other.isPrimitive()) {
            return this == other || this.promotionTypes.contains(other);
        }
        if (other.isReferenceType()) {
            if (other.asReferenceType().getQualifiedName().equals(this.boxTypeQName)) {
                return true;
            }
            for (ResolvedPrimitiveType promotion : this.promotionTypes) {
                if (!other.asReferenceType().getQualifiedName().equals(promotion.boxTypeQName)) continue;
                return true;
            }
            return false;
        }
        return other.isConstraint() && this.isAssignableBy(other.asConstraintType().getBound());
    }

    public String getBoxTypeQName() {
        return this.boxTypeQName;
    }

    public boolean isNumeric() {
        return this != BOOLEAN;
    }
}

