/*
 * Decompiled with CFR 0.152.
 */
package coveredclass.org.github.javaparser.ast.expr;

import coveredclass.org.github.javaparser.TokenRange;
import coveredclass.org.github.javaparser.ast.AllFieldsConstructor;
import coveredclass.org.github.javaparser.ast.Node;
import coveredclass.org.github.javaparser.ast.expr.Expression;
import coveredclass.org.github.javaparser.ast.expr.NameExpr;
import coveredclass.org.github.javaparser.ast.nodeTypes.NodeWithExpression;
import coveredclass.org.github.javaparser.ast.nodeTypes.NodeWithType;
import coveredclass.org.github.javaparser.ast.observer.ObservableProperty;
import coveredclass.org.github.javaparser.ast.type.ClassOrInterfaceType;
import coveredclass.org.github.javaparser.ast.type.ReferenceType;
import coveredclass.org.github.javaparser.ast.visitor.CloneVisitor;
import coveredclass.org.github.javaparser.ast.visitor.GenericVisitor;
import coveredclass.org.github.javaparser.ast.visitor.VoidVisitor;
import coveredclass.org.github.javaparser.metamodel.InstanceOfExprMetaModel;
import coveredclass.org.github.javaparser.metamodel.JavaParserMetaModel;
import coveredclass.org.github.javaparser.utils.Utils;
import java.util.Optional;
import java.util.function.Consumer;

public class InstanceOfExpr
extends Expression
implements NodeWithType<InstanceOfExpr, ReferenceType>,
NodeWithExpression<InstanceOfExpr> {
    private Expression expression;
    private ReferenceType type;

    public InstanceOfExpr() {
        this(null, new NameExpr(), new ClassOrInterfaceType());
    }

    @AllFieldsConstructor
    public InstanceOfExpr(Expression expression, ReferenceType type) {
        this(null, expression, type);
    }

    public InstanceOfExpr(TokenRange tokenRange, Expression expression, ReferenceType type) {
        super(tokenRange);
        this.setExpression(expression);
        this.setType(type);
        this.customInitialization();
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    @Override
    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public ReferenceType getType() {
        return this.type;
    }

    @Override
    public InstanceOfExpr setExpression(Expression expression) {
        Utils.assertNotNull(expression);
        if (expression == this.expression) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.EXPRESSION, this.expression, expression);
        if (this.expression != null) {
            this.expression.setParentNode(null);
        }
        this.expression = expression;
        this.setAsParentNodeOf(expression);
        return this;
    }

    @Override
    public InstanceOfExpr setType(ReferenceType type) {
        Utils.assertNotNull(type);
        if (type == this.type) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.TYPE, this.type, type);
        if (this.type != null) {
            this.type.setParentNode(null);
        }
        this.type = type;
        this.setAsParentNodeOf(type);
        return this;
    }

    @Override
    public boolean remove(Node node) {
        if (node == null) {
            return false;
        }
        return super.remove(node);
    }

    @Override
    public InstanceOfExpr clone() {
        return (InstanceOfExpr)this.accept(new CloneVisitor(), null);
    }

    @Override
    public InstanceOfExprMetaModel getMetaModel() {
        return JavaParserMetaModel.instanceOfExprMetaModel;
    }

    @Override
    public boolean replace(Node node, Node replacementNode) {
        if (node == null) {
            return false;
        }
        if (node == this.expression) {
            this.setExpression((Expression)replacementNode);
            return true;
        }
        if (node == this.type) {
            this.setType((ReferenceType)replacementNode);
            return true;
        }
        return super.replace(node, replacementNode);
    }

    @Override
    public boolean isInstanceOfExpr() {
        return true;
    }

    @Override
    public InstanceOfExpr asInstanceOfExpr() {
        return this;
    }

    @Override
    public void ifInstanceOfExpr(Consumer<InstanceOfExpr> action) {
        action.accept(this);
    }

    @Override
    public Optional<InstanceOfExpr> toInstanceOfExpr() {
        return Optional.of(this);
    }
}

