/*
 * Decompiled with CFR 0.152.
 */
package coveredclass.org.apache.commons.io.serialization;

import coveredclass.org.apache.commons.io.serialization.ClassNameMatcher;
import coveredclass.org.apache.commons.io.serialization.FullClassNameMatcher;
import coveredclass.org.apache.commons.io.serialization.RegexpClassNameMatcher;
import coveredclass.org.apache.commons.io.serialization.WildcardClassNameMatcher;
import coveredclass.org.checkerframework.checker.initialization.qual.Initialized;
import coveredclass.org.checkerframework.checker.nullness.qual.NonNull;
import coveredclass.org.checkerframework.checker.nullness.qual.Nullable;
import coveredclass.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class ValidatingObjectInputStream
extends ObjectInputStream {
    private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ClassNameMatcher> acceptMatchers = new ArrayList<ClassNameMatcher>();
    private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ClassNameMatcher> rejectMatchers = new ArrayList<ClassNameMatcher>();

    public ValidatingObjectInputStream(@UnknownKeyFor @NonNull @Initialized InputStream input) throws @UnknownKeyFor @NonNull @Initialized IOException {
        super(input);
    }

    private void validateClassName(@UnknownKeyFor @NonNull @Initialized String name) throws @UnknownKeyFor @NonNull @Initialized InvalidClassException {
        for (ClassNameMatcher m3 : this.rejectMatchers) {
            if (!m3.matches(name)) continue;
            this.invalidClassNameFound(name);
        }
        boolean ok = false;
        for (ClassNameMatcher m4 : this.acceptMatchers) {
            if (!m4.matches(name)) continue;
            ok = true;
            break;
        }
        if (!ok) {
            this.invalidClassNameFound(name);
        }
    }

    protected void invalidClassNameFound(@UnknownKeyFor @NonNull @Initialized String className) throws @UnknownKeyFor @NonNull @Initialized InvalidClassException {
        throw new InvalidClassException("Class name not accepted: " + className);
    }

    @Override
    protected /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> resolveClass(@UnknownKeyFor @NonNull @Initialized ObjectStreamClass osc) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized ClassNotFoundException {
        this.validateClassName(osc.getName());
        return super.resolveClass(osc);
    }

    public @UnknownKeyFor @NonNull @Initialized ValidatingObjectInputStream accept(Class<?> ... classes) {
        for (Class<?> c : classes) {
            this.acceptMatchers.add(new FullClassNameMatcher(c.getName()));
        }
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized ValidatingObjectInputStream reject(Class<?> ... classes) {
        for (Class<?> c : classes) {
            this.rejectMatchers.add(new FullClassNameMatcher(c.getName()));
        }
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized ValidatingObjectInputStream accept(String ... patterns) {
        for (String pattern : patterns) {
            this.acceptMatchers.add(new WildcardClassNameMatcher(pattern));
        }
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized ValidatingObjectInputStream reject(String ... patterns) {
        for (String pattern : patterns) {
            this.rejectMatchers.add(new WildcardClassNameMatcher(pattern));
        }
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized ValidatingObjectInputStream accept(@UnknownKeyFor @NonNull @Initialized Pattern pattern) {
        this.acceptMatchers.add(new RegexpClassNameMatcher(pattern));
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized ValidatingObjectInputStream reject(@UnknownKeyFor @NonNull @Initialized Pattern pattern) {
        this.rejectMatchers.add(new RegexpClassNameMatcher(pattern));
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized ValidatingObjectInputStream accept(@UnknownKeyFor @NonNull @Initialized ClassNameMatcher m3) {
        this.acceptMatchers.add(m3);
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized ValidatingObjectInputStream reject(@UnknownKeyFor @NonNull @Initialized ClassNameMatcher m3) {
        this.rejectMatchers.add(m3);
        return this;
    }
}

