/*
 * Decompiled with CFR 0.152.
 */
package coveredclass.org.apache.commons.io.output;

import coveredclass.org.apache.commons.io.TaggedIOException;
import coveredclass.org.apache.commons.io.output.ProxyWriter;
import coveredclass.org.checkerframework.checker.initialization.qual.Initialized;
import coveredclass.org.checkerframework.checker.nullness.qual.NonNull;
import coveredclass.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.UUID;

public class TaggedWriter
extends ProxyWriter {
    private final @UnknownKeyFor @NonNull @Initialized Serializable tag = UUID.randomUUID();

    public TaggedWriter(@UnknownKeyFor @NonNull @Initialized Writer proxy) {
        super(proxy);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isCauseOf(@UnknownKeyFor @NonNull @Initialized Exception exception) {
        return TaggedIOException.isTaggedWith(exception, this.tag);
    }

    public void throwIfCauseOf(@UnknownKeyFor @NonNull @Initialized Exception exception) throws @UnknownKeyFor @NonNull @Initialized IOException {
        TaggedIOException.throwCauseIfTaggedWith(exception, this.tag);
    }

    @Override
    protected void handleIOException(@UnknownKeyFor @NonNull @Initialized IOException e) throws @UnknownKeyFor @NonNull @Initialized IOException {
        throw new TaggedIOException(e, this.tag);
    }
}

