/*
 * Decompiled with CFR 0.152.
 */
package coveredclass.org.apache.commons.io.output;

import coveredclass.org.apache.commons.io.IOUtils;
import coveredclass.org.apache.commons.io.output.FilterCollectionWriter;
import coveredclass.org.checkerframework.checker.initialization.qual.Initialized;
import coveredclass.org.checkerframework.checker.nullness.qual.NonNull;
import coveredclass.org.checkerframework.checker.nullness.qual.Nullable;
import coveredclass.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;

public class ProxyCollectionWriter
extends FilterCollectionWriter {
    public ProxyCollectionWriter(@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized Writer> writers) {
        super(writers);
    }

    public ProxyCollectionWriter(Writer ... writers) {
        super(writers);
    }

    protected void afterWrite(@UnknownKeyFor @NonNull @Initialized int n) throws @UnknownKeyFor @NonNull @Initialized IOException {
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Writer append(@UnknownKeyFor @NonNull @Initialized char c) throws @UnknownKeyFor @NonNull @Initialized IOException {
        try {
            this.beforeWrite(1);
            super.append(c);
            this.afterWrite(1);
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
        return this;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Writer append(@Nullable @UnknownKeyFor @Initialized CharSequence csq) throws @UnknownKeyFor @NonNull @Initialized IOException {
        try {
            int len = IOUtils.length(csq);
            this.beforeWrite(len);
            super.append(csq);
            this.afterWrite(len);
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
        return this;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Writer append(@Nullable @UnknownKeyFor @Initialized CharSequence csq, @UnknownKeyFor @NonNull @Initialized int start, @UnknownKeyFor @NonNull @Initialized int end) throws @UnknownKeyFor @NonNull @Initialized IOException {
        try {
            this.beforeWrite(end - start);
            super.append(csq, start, end);
            this.afterWrite(end - start);
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
        return this;
    }

    protected void beforeWrite(@UnknownKeyFor @NonNull @Initialized int n) throws @UnknownKeyFor @NonNull @Initialized IOException {
    }

    @Override
    public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
        try {
            super.close();
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
    }

    @Override
    public void flush() throws @UnknownKeyFor @NonNull @Initialized IOException {
        try {
            super.flush();
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
    }

    protected void handleIOException(@UnknownKeyFor @NonNull @Initialized IOException e) throws @UnknownKeyFor @NonNull @Initialized IOException {
        throw e;
    }

    @Override
    public void write(@UnknownKeyFor @NonNull @Initialized char @UnknownKeyFor @NonNull @Initialized [] cbuf) throws @UnknownKeyFor @NonNull @Initialized IOException {
        try {
            int len = IOUtils.length(cbuf);
            this.beforeWrite(len);
            super.write(cbuf);
            this.afterWrite(len);
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
    }

    @Override
    public void write(@UnknownKeyFor @NonNull @Initialized char @UnknownKeyFor @NonNull @Initialized [] cbuf, @UnknownKeyFor @NonNull @Initialized int off, @UnknownKeyFor @NonNull @Initialized int len) throws @UnknownKeyFor @NonNull @Initialized IOException {
        try {
            this.beforeWrite(len);
            super.write(cbuf, off, len);
            this.afterWrite(len);
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
    }

    @Override
    public void write(@UnknownKeyFor @NonNull @Initialized int c) throws @UnknownKeyFor @NonNull @Initialized IOException {
        try {
            this.beforeWrite(1);
            super.write(c);
            this.afterWrite(1);
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
    }

    @Override
    public void write(@UnknownKeyFor @NonNull @Initialized String str) throws @UnknownKeyFor @NonNull @Initialized IOException {
        try {
            int len = IOUtils.length(str);
            this.beforeWrite(len);
            super.write(str);
            this.afterWrite(len);
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
    }

    @Override
    public void write(@UnknownKeyFor @NonNull @Initialized String str, @UnknownKeyFor @NonNull @Initialized int off, @UnknownKeyFor @NonNull @Initialized int len) throws @UnknownKeyFor @NonNull @Initialized IOException {
        try {
            this.beforeWrite(len);
            super.write(str, off, len);
            this.afterWrite(len);
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
    }
}

