/*
 * Decompiled with CFR 0.152.
 */
package coveredclass.org.apache.commons.io.output;

import coveredclass.org.apache.commons.io.FileUtils;
import coveredclass.org.apache.commons.io.IOUtils;
import coveredclass.org.apache.commons.io.output.ByteArrayOutputStream;
import coveredclass.org.apache.commons.io.output.ThresholdingOutputStream;
import coveredclass.org.checkerframework.checker.initialization.qual.Initialized;
import coveredclass.org.checkerframework.checker.nullness.qual.NonNull;
import coveredclass.org.checkerframework.checker.nullness.qual.Nullable;
import coveredclass.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import coveredclass.org.checkerframework.dataflow.qual.Pure;
import coveredclass.org.checkerframework.framework.qual.EnsuresQualifierIf;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DeferredFileOutputStream
extends ThresholdingOutputStream {
    private @Nullable @UnknownKeyFor @Initialized ByteArrayOutputStream memoryOutputStream;
    private @UnknownKeyFor @NonNull @Initialized OutputStream currentOutputStream;
    private @Nullable @UnknownKeyFor @Initialized File outputFile;
    private final @Nullable @UnknownKeyFor @Initialized String prefix;
    private final @Nullable @UnknownKeyFor @Initialized String suffix;
    private final @Nullable @UnknownKeyFor @Initialized File directory;
    private @UnknownKeyFor @NonNull @Initialized boolean closed = false;

    public DeferredFileOutputStream(@UnknownKeyFor @NonNull @Initialized int threshold, @UnknownKeyFor @NonNull @Initialized File outputFile) {
        this(threshold, outputFile, null, null, null, 1024);
    }

    public DeferredFileOutputStream(@UnknownKeyFor @NonNull @Initialized int threshold, @UnknownKeyFor @NonNull @Initialized int initialBufferSize, @UnknownKeyFor @NonNull @Initialized File outputFile) {
        this(threshold, outputFile, null, null, null, initialBufferSize);
        if (initialBufferSize < 0) {
            throw new IllegalArgumentException("Initial buffer size must be atleast 0.");
        }
    }

    public DeferredFileOutputStream(@UnknownKeyFor @NonNull @Initialized int threshold, @UnknownKeyFor @NonNull @Initialized String prefix, @UnknownKeyFor @NonNull @Initialized String suffix, @UnknownKeyFor @NonNull @Initialized File directory) {
        this(threshold, null, prefix, suffix, directory, 1024);
        if (prefix == null) {
            throw new IllegalArgumentException("Temporary file prefix is missing");
        }
    }

    public DeferredFileOutputStream(@UnknownKeyFor @NonNull @Initialized int threshold, @UnknownKeyFor @NonNull @Initialized int initialBufferSize, @UnknownKeyFor @NonNull @Initialized String prefix, @UnknownKeyFor @NonNull @Initialized String suffix, @UnknownKeyFor @NonNull @Initialized File directory) {
        this(threshold, null, prefix, suffix, directory, initialBufferSize);
        if (prefix == null) {
            throw new IllegalArgumentException("Temporary file prefix is missing");
        }
        if (initialBufferSize < 0) {
            throw new IllegalArgumentException("Initial buffer size must be atleast 0.");
        }
    }

    private DeferredFileOutputStream(@UnknownKeyFor @NonNull @Initialized int threshold, @Nullable @UnknownKeyFor @Initialized File outputFile, @Nullable @UnknownKeyFor @Initialized String prefix, @Nullable @UnknownKeyFor @Initialized String suffix, @Nullable @UnknownKeyFor @Initialized File directory, @UnknownKeyFor @NonNull @Initialized int initialBufferSize) {
        super(threshold);
        this.outputFile = outputFile;
        this.prefix = prefix;
        this.suffix = suffix;
        this.directory = directory;
        this.memoryOutputStream = new ByteArrayOutputStream(initialBufferSize);
        this.currentOutputStream = this.memoryOutputStream;
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized OutputStream getStream() throws @UnknownKeyFor @NonNull @Initialized IOException {
        return this.currentOutputStream;
    }

    @Override
    protected void thresholdReached() throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (this.prefix != null) {
            this.outputFile = File.createTempFile(this.prefix, this.suffix, this.directory);
        }
        assert (this.outputFile != null) : "@AssumeAssertion(nullness): constructors ensure that either prefix or outputFile is non-null";
        FileUtils.forceMkdirParent(this.outputFile);
        FileOutputStream fos = new FileOutputStream(this.outputFile);
        try {
            assert (this.memoryOutputStream != null) : "@AssumeAssertion(nullness): thresholdReached() is called at most once and nothing else sets memoryOutputStream to null";
            this.memoryOutputStream.writeTo(fos);
        }
        catch (IOException e) {
            fos.close();
            throw e;
        }
        this.currentOutputStream = fos;
        this.memoryOutputStream = null;
    }

    @EnsuresQualifierIf.List(value={@EnsuresQualifierIf(result=true, qualifier=NonNull.class, expression={"memoryOutputStream"}), @EnsuresQualifierIf(result=false, qualifier=NonNull.class, expression={"outputFile"})})
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean isInMemory() {
        return !this.isThresholdExceeded();
    }

    @Override
    @EnsuresQualifierIf.List(value={@EnsuresQualifierIf(result=true, qualifier=NonNull.class, expression={"outputFile"}), @EnsuresQualifierIf(result=false, qualifier=NonNull.class, expression={"memoryOutputStream"})})
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean isThresholdExceeded() {
        return super.isThresholdExceeded();
    }

    public @UnknownKeyFor @NonNull @Initialized byte @Nullable @UnknownKeyFor @Initialized [] getData() {
        if (this.memoryOutputStream != null) {
            return this.memoryOutputStream.toByteArray();
        }
        return null;
    }

    public @Nullable @UnknownKeyFor @Initialized File getFile() {
        return this.outputFile;
    }

    @Override
    public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
        super.close();
        this.closed = true;
    }

    public void writeTo(@UnknownKeyFor @NonNull @Initialized OutputStream out) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (!this.closed) {
            throw new IOException("Stream not closed");
        }
        if (this.isInMemory()) {
            this.memoryOutputStream.writeTo(out);
        } else {
            try (FileInputStream fis = new FileInputStream(this.outputFile);){
                IOUtils.copy((InputStream)fis, out);
            }
        }
    }
}

