/*
 * Decompiled with CFR 0.152.
 */
package coveredclass.org.apache.commons.io.input;

import coveredclass.org.apache.commons.io.input.ProxyReader;
import coveredclass.org.checkerframework.checker.initialization.qual.Initialized;
import coveredclass.org.checkerframework.checker.nullness.qual.NonNull;
import coveredclass.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.CharBuffer;

public class TeeReader
extends ProxyReader {
    private final @UnknownKeyFor @NonNull @Initialized Writer branch;
    private final @UnknownKeyFor @NonNull @Initialized boolean closeBranch;

    public TeeReader(@UnknownKeyFor @NonNull @Initialized Reader input, @UnknownKeyFor @NonNull @Initialized Writer branch) {
        this(input, branch, false);
    }

    public TeeReader(@UnknownKeyFor @NonNull @Initialized Reader input, @UnknownKeyFor @NonNull @Initialized Writer branch, @UnknownKeyFor @NonNull @Initialized boolean closeBranch) {
        super(input);
        this.branch = branch;
        this.closeBranch = closeBranch;
    }

    @Override
    public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
        try {
            super.close();
        }
        finally {
            if (this.closeBranch) {
                this.branch.close();
            }
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int read() throws @UnknownKeyFor @NonNull @Initialized IOException {
        int ch = super.read();
        if (ch != -1) {
            this.branch.write(ch);
        }
        return ch;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int read(@UnknownKeyFor @NonNull @Initialized char @UnknownKeyFor @NonNull @Initialized [] chr) throws @UnknownKeyFor @NonNull @Initialized IOException {
        int n = super.read(chr);
        if (n != -1) {
            this.branch.write(chr, 0, n);
        }
        return n;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int read(@UnknownKeyFor @NonNull @Initialized char @UnknownKeyFor @NonNull @Initialized [] chr, @UnknownKeyFor @NonNull @Initialized int st, @UnknownKeyFor @NonNull @Initialized int end) throws @UnknownKeyFor @NonNull @Initialized IOException {
        int n = super.read(chr, st, end);
        if (n != -1) {
            this.branch.write(chr, st, n);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @UnknownKeyFor @NonNull @Initialized int read(@UnknownKeyFor @NonNull @Initialized CharBuffer target) throws @UnknownKeyFor @NonNull @Initialized IOException {
        int originalPosition = target.position();
        int n = super.read(target);
        if (n != -1) {
            int newPosition = target.position();
            int newLimit = target.limit();
            try {
                target.position(originalPosition).limit(newPosition);
                this.branch.append(target);
            }
            finally {
                target.position(newPosition).limit(newLimit);
            }
        }
        return n;
    }
}

