/*
 * Decompiled with CFR 0.152.
 */
package coveredclass.org.apache.commons.io.input;

import coveredclass.org.checkerframework.checker.initialization.qual.Initialized;
import coveredclass.org.checkerframework.checker.nullness.qual.NonNull;
import coveredclass.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Objects;

public class RandomAccessFileInputStream
extends InputStream {
    private final @UnknownKeyFor @NonNull @Initialized boolean closeOnClose;
    private final @UnknownKeyFor @NonNull @Initialized RandomAccessFile randomAccessFile;

    public RandomAccessFileInputStream(@UnknownKeyFor @NonNull @Initialized RandomAccessFile file) {
        this(file, false);
    }

    public RandomAccessFileInputStream(@UnknownKeyFor @NonNull @Initialized RandomAccessFile file, @UnknownKeyFor @NonNull @Initialized boolean closeOnClose) {
        this.randomAccessFile = Objects.requireNonNull(file, "file");
        this.closeOnClose = closeOnClose;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int available() throws @UnknownKeyFor @NonNull @Initialized IOException {
        long avail = this.availableLong();
        if (avail > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)avail;
    }

    public @UnknownKeyFor @NonNull @Initialized long availableLong() throws @UnknownKeyFor @NonNull @Initialized IOException {
        return this.randomAccessFile.length() - this.randomAccessFile.getFilePointer();
    }

    @Override
    public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
        super.close();
        if (this.closeOnClose) {
            this.randomAccessFile.close();
        }
    }

    public @UnknownKeyFor @NonNull @Initialized RandomAccessFile getRandomAccessFile() {
        return this.randomAccessFile;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isCloseOnClose() {
        return this.closeOnClose;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int read() throws @UnknownKeyFor @NonNull @Initialized IOException {
        return this.randomAccessFile.read();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int read(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] bytes) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return this.randomAccessFile.read(bytes);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int read(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] bytes, @UnknownKeyFor @NonNull @Initialized int offset, @UnknownKeyFor @NonNull @Initialized int length) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return this.randomAccessFile.read(bytes, offset, length);
    }

    private void seek(@UnknownKeyFor @NonNull @Initialized long position) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.randomAccessFile.seek(position);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long skip(@UnknownKeyFor @NonNull @Initialized long skipCount) throws @UnknownKeyFor @NonNull @Initialized IOException {
        long newPos;
        long fileLength;
        if (skipCount <= 0L) {
            return 0L;
        }
        long filePointer = this.randomAccessFile.getFilePointer();
        if (filePointer >= (fileLength = this.randomAccessFile.length())) {
            return 0L;
        }
        long targetPos = filePointer + skipCount;
        long l = newPos = targetPos > fileLength ? fileLength - 1L : targetPos;
        if (newPos > 0L) {
            this.seek(newPos);
        }
        return this.randomAccessFile.getFilePointer() - filePointer;
    }
}

