/*
 * Decompiled with CFR 0.152.
 */
package coveredclass.org.apache.commons.io.input;

import coveredclass.org.apache.commons.io.input.ProxyInputStream;
import coveredclass.org.checkerframework.checker.initialization.qual.Initialized;
import coveredclass.org.checkerframework.checker.nullness.qual.NonNull;
import coveredclass.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import java.io.IOException;
import java.io.InputStream;

public class CountingInputStream
extends ProxyInputStream {
    private @UnknownKeyFor @NonNull @Initialized long count;

    public CountingInputStream(@UnknownKeyFor @NonNull @Initialized InputStream in) {
        super(in);
    }

    @Override
    public synchronized @UnknownKeyFor @NonNull @Initialized long skip(@UnknownKeyFor @NonNull @Initialized long length) throws @UnknownKeyFor @NonNull @Initialized IOException {
        long skip = super.skip(length);
        this.count += skip;
        return skip;
    }

    @Override
    protected synchronized void afterRead(@UnknownKeyFor @NonNull @Initialized int n) {
        if (n != -1) {
            this.count += (long)n;
        }
    }

    public @UnknownKeyFor @NonNull @Initialized int getCount() {
        long result = this.getByteCount();
        if (result > Integer.MAX_VALUE) {
            throw new ArithmeticException("The byte count " + result + " is too large to be converted to an int");
        }
        return (int)result;
    }

    public @UnknownKeyFor @NonNull @Initialized int resetCount() {
        long result = this.resetByteCount();
        if (result > Integer.MAX_VALUE) {
            throw new ArithmeticException("The byte count " + result + " is too large to be converted to an int");
        }
        return (int)result;
    }

    public synchronized @UnknownKeyFor @NonNull @Initialized long getByteCount() {
        return this.count;
    }

    public synchronized @UnknownKeyFor @NonNull @Initialized long resetByteCount() {
        long tmp = this.count;
        this.count = 0L;
        return tmp;
    }
}

