/*
 * Decompiled with CFR 0.152.
 */
package coveredclass.org.apache.commons.io.input;

import coveredclass.org.checkerframework.checker.initialization.qual.Initialized;
import coveredclass.org.checkerframework.checker.nullness.qual.NonNull;
import coveredclass.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import java.io.IOException;
import java.io.Reader;

public class BoundedReader
extends Reader {
    private static final @UnknownKeyFor @NonNull @Initialized int INVALID = -1;
    private final @UnknownKeyFor @NonNull @Initialized Reader target;
    private @UnknownKeyFor @NonNull @Initialized int charsRead = 0;
    private @UnknownKeyFor @NonNull @Initialized int markedAt = -1;
    private @UnknownKeyFor @NonNull @Initialized int readAheadLimit;
    private final @UnknownKeyFor @NonNull @Initialized int maxCharsFromTargetReader;

    public BoundedReader(@UnknownKeyFor @NonNull @Initialized Reader target, @UnknownKeyFor @NonNull @Initialized int maxCharsFromTargetReader) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.target = target;
        this.maxCharsFromTargetReader = maxCharsFromTargetReader;
    }

    @Override
    public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.target.close();
    }

    @Override
    public void reset() throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.charsRead = this.markedAt;
        this.target.reset();
    }

    @Override
    public void mark(@UnknownKeyFor @NonNull @Initialized int readAheadLimit) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.readAheadLimit = readAheadLimit - this.charsRead;
        this.markedAt = this.charsRead;
        this.target.mark(readAheadLimit);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int read() throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (this.charsRead >= this.maxCharsFromTargetReader) {
            return -1;
        }
        if (this.markedAt >= 0 && this.charsRead - this.markedAt >= this.readAheadLimit) {
            return -1;
        }
        ++this.charsRead;
        return this.target.read();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int read(@UnknownKeyFor @NonNull @Initialized char @UnknownKeyFor @NonNull @Initialized [] cbuf, @UnknownKeyFor @NonNull @Initialized int off, @UnknownKeyFor @NonNull @Initialized int len) throws @UnknownKeyFor @NonNull @Initialized IOException {
        for (int i = 0; i < len; ++i) {
            int c = this.read();
            if (c == -1) {
                return i == 0 ? -1 : i;
            }
            cbuf[off + i] = (char)c;
        }
        return len;
    }
}

