/*
 * Decompiled with CFR 0.152.
 */
package coveredclass.org.apache.commons.io.input;

import coveredclass.org.apache.commons.io.ByteOrderMark;
import coveredclass.org.apache.commons.io.IOUtils;
import coveredclass.org.apache.commons.io.input.ProxyInputStream;
import coveredclass.org.checkerframework.checker.initialization.qual.Initialized;
import coveredclass.org.checkerframework.checker.nullness.qual.AssertNonNullIfNonNull;
import coveredclass.org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import coveredclass.org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import coveredclass.org.checkerframework.checker.nullness.qual.NonNull;
import coveredclass.org.checkerframework.checker.nullness.qual.Nullable;
import coveredclass.org.checkerframework.checker.nullness.qual.RequiresNonNull;
import coveredclass.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import coveredclass.org.checkerframework.dataflow.qual.Pure;
import coveredclass.org.checkerframework.dataflow.qual.SideEffectFree;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class BOMInputStream
extends ProxyInputStream {
    private final @UnknownKeyFor @NonNull @Initialized boolean include;
    private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ByteOrderMark> boms;
    private @Nullable @UnknownKeyFor @Initialized ByteOrderMark byteOrderMark;
    private @UnknownKeyFor @NonNull @Initialized int @MonotonicNonNull @UnknownKeyFor @Initialized [] firstBytes;
    private @UnknownKeyFor @NonNull @Initialized int fbLength;
    private @UnknownKeyFor @NonNull @Initialized int fbIndex;
    private @UnknownKeyFor @NonNull @Initialized int markFbIndex;
    private @UnknownKeyFor @NonNull @Initialized boolean markedAtStart;
    private static final @UnknownKeyFor @NonNull @Initialized Comparator<@UnknownKeyFor @NonNull @Initialized ByteOrderMark> ByteOrderMarkLengthComparator = (bom1, bom2) -> {
        int len1 = bom1.length();
        int len2 = bom2.length();
        return Integer.compare(len2, len1);
    };

    public BOMInputStream(@UnknownKeyFor @NonNull @Initialized InputStream delegate) {
        this(delegate, false, ByteOrderMark.UTF_8);
    }

    public BOMInputStream(@UnknownKeyFor @NonNull @Initialized InputStream delegate, @UnknownKeyFor @NonNull @Initialized boolean include) {
        this(delegate, include, ByteOrderMark.UTF_8);
    }

    public BOMInputStream(@UnknownKeyFor @NonNull @Initialized InputStream delegate, ByteOrderMark ... boms) {
        this(delegate, false, boms);
    }

    public BOMInputStream(@UnknownKeyFor @NonNull @Initialized InputStream delegate, @UnknownKeyFor @NonNull @Initialized boolean include, ByteOrderMark ... boms) {
        super(delegate);
        if (IOUtils.length(boms) == 0) {
            throw new IllegalArgumentException("No BOMs specified");
        }
        this.include = include;
        List<ByteOrderMark> list = Arrays.asList(boms);
        list.sort(ByteOrderMarkLengthComparator);
        this.boms = list;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean hasBOM() throws @UnknownKeyFor @NonNull @Initialized IOException {
        return this.getBOM() != null;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean hasBOM(@UnknownKeyFor @NonNull @Initialized ByteOrderMark bom) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (!this.boms.contains(bom)) {
            throw new IllegalArgumentException("Stream not configure to detect " + bom);
        }
        this.getBOM();
        return this.byteOrderMark != null && this.byteOrderMark.equals(bom);
    }

    @AssertNonNullIfNonNull(value={"byteOrderMark"})
    @EnsuresNonNull(value={"firstBytes"})
    public @Nullable @UnknownKeyFor @Initialized ByteOrderMark getBOM() throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (this.firstBytes == null) {
            this.fbLength = 0;
            int maxBomSize = this.boms.get(0).length();
            this.firstBytes = new int[maxBomSize];
            for (int i = 0; i < this.firstBytes.length; ++i) {
                this.firstBytes[i] = this.in.read();
                ++this.fbLength;
                if (this.firstBytes[i] < 0) break;
            }
            this.byteOrderMark = this.find();
            if (this.byteOrderMark != null && !this.include) {
                if (this.byteOrderMark.length() < this.firstBytes.length) {
                    this.fbIndex = this.byteOrderMark.length();
                } else {
                    this.fbLength = 0;
                }
            }
        }
        return this.byteOrderMark;
    }

    public @Nullable @UnknownKeyFor @Initialized String getBOMCharsetName() throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.getBOM();
        return this.byteOrderMark == null ? null : this.byteOrderMark.getCharsetName();
    }

    private @UnknownKeyFor @NonNull @Initialized int readFirstBytes() throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.getBOM();
        return this.fbIndex < this.fbLength ? this.firstBytes[this.fbIndex++] : -1;
    }

    @SideEffectFree
    @RequiresNonNull(value={"firstBytes"})
    private @Nullable @UnknownKeyFor @Initialized ByteOrderMark find() {
        for (ByteOrderMark bom : this.boms) {
            if (!this.matches(bom)) continue;
            return bom;
        }
        return null;
    }

    @RequiresNonNull(value={"firstBytes"})
    @Pure
    private @UnknownKeyFor @NonNull @Initialized boolean matches(@UnknownKeyFor @NonNull @Initialized ByteOrderMark bom) {
        for (int i = 0; i < bom.length(); ++i) {
            if (bom.get(i) == this.firstBytes[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int read() throws @UnknownKeyFor @NonNull @Initialized IOException {
        int b = this.readFirstBytes();
        return b >= 0 ? b : this.in.read();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int read(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] buf, @UnknownKeyFor @NonNull @Initialized int off, @UnknownKeyFor @NonNull @Initialized int len) throws @UnknownKeyFor @NonNull @Initialized IOException {
        int firstCount = 0;
        int b = 0;
        while (len > 0 && b >= 0) {
            b = this.readFirstBytes();
            if (b < 0) continue;
            buf[off++] = (byte)(b & 0xFF);
            --len;
            ++firstCount;
        }
        int secondCount = this.in.read(buf, off, len);
        return secondCount < 0 ? (firstCount > 0 ? firstCount : -1) : firstCount + secondCount;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int read(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] buf) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return this.read(buf, 0, buf.length);
    }

    @Override
    public synchronized void mark(@UnknownKeyFor @NonNull @Initialized int readlimit) {
        this.markFbIndex = this.fbIndex;
        this.markedAtStart = this.firstBytes == null;
        this.in.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.fbIndex = this.markFbIndex;
        if (this.markedAtStart) {
            this.firstBytes = null;
        }
        this.in.reset();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long skip(@UnknownKeyFor @NonNull @Initialized long n) throws @UnknownKeyFor @NonNull @Initialized IOException {
        int skipped = 0;
        while (n > (long)skipped && this.readFirstBytes() >= 0) {
            ++skipped;
        }
        return this.in.skip(n - (long)skipped) + (long)skipped;
    }
}

