/*
 * Decompiled with CFR 0.152.
 */
package coveredclass.org.apache.commons.io.filefilter;

import coveredclass.org.apache.commons.io.FilenameUtils;
import coveredclass.org.apache.commons.io.IOCase;
import coveredclass.org.apache.commons.io.filefilter.AbstractFileFilter;
import coveredclass.org.checkerframework.checker.initialization.qual.Initialized;
import coveredclass.org.checkerframework.checker.nullness.qual.NonNull;
import coveredclass.org.checkerframework.checker.nullness.qual.Nullable;
import coveredclass.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import coveredclass.org.checkerframework.dataflow.qual.SideEffectFree;
import java.io.File;
import java.io.Serializable;
import java.util.List;

public class WildcardFileFilter
extends AbstractFileFilter
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = -7426486598995782105L;
    private final @UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] wildcards;
    private final @UnknownKeyFor @NonNull @Initialized IOCase caseSensitivity;

    public WildcardFileFilter(@UnknownKeyFor @NonNull @Initialized String wildcard) {
        this(wildcard, IOCase.SENSITIVE);
    }

    public WildcardFileFilter(@UnknownKeyFor @NonNull @Initialized String wildcard, @Nullable @UnknownKeyFor @Initialized IOCase caseSensitivity) {
        if (wildcard == null) {
            throw new IllegalArgumentException("The wildcard must not be null");
        }
        this.wildcards = new String[]{wildcard};
        this.caseSensitivity = caseSensitivity == null ? IOCase.SENSITIVE : caseSensitivity;
    }

    public WildcardFileFilter(String ... wildcards) {
        this(wildcards, IOCase.SENSITIVE);
    }

    public WildcardFileFilter(@UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] wildcards, @Nullable @UnknownKeyFor @Initialized IOCase caseSensitivity) {
        if (wildcards == null) {
            throw new IllegalArgumentException("The wildcard array must not be null");
        }
        this.wildcards = new String[wildcards.length];
        System.arraycopy(wildcards, 0, this.wildcards, 0, wildcards.length);
        this.caseSensitivity = caseSensitivity == null ? IOCase.SENSITIVE : caseSensitivity;
    }

    public WildcardFileFilter(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> wildcards) {
        this(wildcards, IOCase.SENSITIVE);
    }

    public WildcardFileFilter(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> wildcards, @Nullable @UnknownKeyFor @Initialized IOCase caseSensitivity) {
        if (wildcards == null) {
            throw new IllegalArgumentException("The wildcard list must not be null");
        }
        this.wildcards = wildcards.toArray(EMPTY_STRING_ARRAY);
        this.caseSensitivity = caseSensitivity == null ? IOCase.SENSITIVE : caseSensitivity;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean accept(@UnknownKeyFor @NonNull @Initialized File dir, @UnknownKeyFor @NonNull @Initialized String name) {
        for (String wildcard : this.wildcards) {
            if (!FilenameUtils.wildcardMatch(name, wildcard, this.caseSensitivity)) continue;
            return true;
        }
        return false;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean accept(@UnknownKeyFor @NonNull @Initialized File file) {
        String name = file.getName();
        for (String wildcard : this.wildcards) {
            if (!FilenameUtils.wildcardMatch(name, wildcard, this.caseSensitivity)) continue;
            return true;
        }
        return false;
    }

    @Override
    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(super.toString());
        buffer.append("(");
        if (this.wildcards != null) {
            for (int i = 0; i < this.wildcards.length; ++i) {
                if (i > 0) {
                    buffer.append(",");
                }
                buffer.append(this.wildcards[i]);
            }
        }
        buffer.append(")");
        return buffer.toString();
    }
}

