/*
 * Decompiled with CFR 0.152.
 */
package coveredclass.org.apache.commons.io.file;

import coveredclass.org.checkerframework.checker.initialization.qual.Initialized;
import coveredclass.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import coveredclass.org.checkerframework.checker.nullness.qual.NonNull;
import coveredclass.org.checkerframework.checker.nullness.qual.Nullable;
import coveredclass.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import coveredclass.org.checkerframework.dataflow.qual.Pure;
import coveredclass.org.checkerframework.dataflow.qual.SideEffectFree;
import java.math.BigInteger;
import java.util.Objects;

public class Counters {
    public static @UnknownKeyFor @NonNull @Initialized Counter bigIntegerCounter() {
        return new BigIntegerCounter();
    }

    public static @UnknownKeyFor @NonNull @Initialized PathCounters bigIntegerPathCounters() {
        return new BigIntegerPathCounters();
    }

    public static @UnknownKeyFor @NonNull @Initialized Counter longCounter() {
        return new LongCounter();
    }

    public static @UnknownKeyFor @NonNull @Initialized PathCounters longPathCounters() {
        return new LongPathCounters();
    }

    public static interface PathCounters {
        public @UnknownKeyFor @NonNull @Initialized Counter getByteCounter();

        public @UnknownKeyFor @NonNull @Initialized Counter getDirectoryCounter();

        public @UnknownKeyFor @NonNull @Initialized Counter getFileCounter();
    }

    private static class LongPathCounters
    extends AbstractPathCounters {
        protected LongPathCounters() {
            super(Counters.longCounter(), Counters.longCounter(), Counters.longCounter());
        }
    }

    private static class LongCounter
    implements Counter {
        private @UnknownKeyFor @NonNull @Initialized long value;

        private LongCounter() {
        }

        @Override
        public void add(@UnknownKeyFor @NonNull @Initialized long add) {
            this.value += add;
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Counter)) {
                return false;
            }
            Counter other = (Counter)obj;
            return this.value == other.get();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized long get() {
            return this.value;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized BigInteger getBigInteger() {
            return BigInteger.valueOf(this.value);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Long getLong() {
            return this.value;
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(this.value);
        }

        @Override
        public void increment() {
            ++this.value;
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return Long.toString(this.value);
        }
    }

    public static interface Counter {
        public void add(@UnknownKeyFor @NonNull @Initialized long var1);

        public @UnknownKeyFor @NonNull @Initialized long get();

        public @UnknownKeyFor @NonNull @Initialized BigInteger getBigInteger();

        public @UnknownKeyFor @NonNull @Initialized Long getLong();

        public void increment();
    }

    private static class BigIntegerPathCounters
    extends AbstractPathCounters {
        protected BigIntegerPathCounters() {
            super(Counters.bigIntegerCounter(), Counters.bigIntegerCounter(), Counters.bigIntegerCounter());
        }
    }

    private static class BigIntegerCounter
    implements Counter {
        private @UnknownKeyFor @NonNull @Initialized BigInteger value = BigInteger.ZERO;

        private BigIntegerCounter() {
        }

        @Override
        public void add(@UnknownKeyFor @NonNull @Initialized long val) {
            this.value = this.value.add(BigInteger.valueOf(val));
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Counter)) {
                return false;
            }
            Counter other = (Counter)obj;
            return Objects.equals(this.value, other.getBigInteger());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized long get() {
            return this.value.longValueExact();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized BigInteger getBigInteger() {
            return this.value;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Long getLong() {
            return this.value.longValueExact();
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(this.value);
        }

        @Override
        public void increment() {
            this.value = this.value.add(BigInteger.ONE);
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return this.value.toString();
        }
    }

    private static class AbstractPathCounters
    implements PathCounters {
        private final @UnknownKeyFor @NonNull @Initialized Counter byteCounter;
        private final @UnknownKeyFor @NonNull @Initialized Counter directoryCounter;
        private final @UnknownKeyFor @NonNull @Initialized Counter fileCounter;

        protected AbstractPathCounters(@UnknownKeyFor @NonNull @Initialized Counter byteCounter, @UnknownKeyFor @NonNull @Initialized Counter directoryCounter, @UnknownKeyFor @NonNull @Initialized Counter fileCounter) {
            this.byteCounter = byteCounter;
            this.directoryCounter = directoryCounter;
            this.fileCounter = fileCounter;
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof AbstractPathCounters)) {
                return false;
            }
            AbstractPathCounters other = (AbstractPathCounters)obj;
            return Objects.equals(this.byteCounter, other.byteCounter) && Objects.equals(this.directoryCounter, other.directoryCounter) && Objects.equals(this.fileCounter, other.fileCounter);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Counter getByteCounter() {
            return this.byteCounter;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Counter getDirectoryCounter() {
            return this.directoryCounter;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Counter getFileCounter() {
            return this.fileCounter;
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(this.byteCounter, this.directoryCounter, this.fileCounter);
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return String.format("%,d files, %,d directories, %,d bytes", this.fileCounter.get(), this.directoryCounter.get(), this.byteCounter.get());
        }
    }
}

