/*
 * Decompiled with CFR 0.152.
 */
package coveredclass.org.apache.commons.io.comparator;

import coveredclass.org.apache.commons.io.FilenameUtils;
import coveredclass.org.apache.commons.io.IOCase;
import coveredclass.org.apache.commons.io.comparator.AbstractFileComparator;
import coveredclass.org.apache.commons.io.comparator.ReverseFileComparator;
import coveredclass.org.checkerframework.checker.initialization.qual.Initialized;
import coveredclass.org.checkerframework.checker.nullness.qual.NonNull;
import coveredclass.org.checkerframework.checker.nullness.qual.Nullable;
import coveredclass.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import coveredclass.org.checkerframework.dataflow.qual.SideEffectFree;
import java.io.File;
import java.io.Serializable;
import java.util.Comparator;

public class ExtensionFileComparator
extends AbstractFileComparator
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = 1928235200184222815L;
    public static final @UnknownKeyFor @NonNull @Initialized Comparator<@UnknownKeyFor @NonNull @Initialized File> EXTENSION_COMPARATOR = new ExtensionFileComparator();
    public static final @UnknownKeyFor @NonNull @Initialized Comparator<@UnknownKeyFor @NonNull @Initialized File> EXTENSION_REVERSE = new ReverseFileComparator(EXTENSION_COMPARATOR);
    public static final @UnknownKeyFor @NonNull @Initialized Comparator<@UnknownKeyFor @NonNull @Initialized File> EXTENSION_INSENSITIVE_COMPARATOR = new ExtensionFileComparator(IOCase.INSENSITIVE);
    public static final @UnknownKeyFor @NonNull @Initialized Comparator<@UnknownKeyFor @NonNull @Initialized File> EXTENSION_INSENSITIVE_REVERSE = new ReverseFileComparator(EXTENSION_INSENSITIVE_COMPARATOR);
    public static final @UnknownKeyFor @NonNull @Initialized Comparator<@UnknownKeyFor @NonNull @Initialized File> EXTENSION_SYSTEM_COMPARATOR = new ExtensionFileComparator(IOCase.SYSTEM);
    public static final @UnknownKeyFor @NonNull @Initialized Comparator<@UnknownKeyFor @NonNull @Initialized File> EXTENSION_SYSTEM_REVERSE = new ReverseFileComparator(EXTENSION_SYSTEM_COMPARATOR);
    private final @UnknownKeyFor @NonNull @Initialized IOCase caseSensitivity;

    public ExtensionFileComparator() {
        this.caseSensitivity = IOCase.SENSITIVE;
    }

    public ExtensionFileComparator(@Nullable @UnknownKeyFor @Initialized IOCase caseSensitivity) {
        this.caseSensitivity = caseSensitivity == null ? IOCase.SENSITIVE : caseSensitivity;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int compare(@UnknownKeyFor @NonNull @Initialized File file1, @UnknownKeyFor @NonNull @Initialized File file2) {
        String suffix1 = FilenameUtils.getExtension(file1.getName());
        String suffix2 = FilenameUtils.getExtension(file2.getName());
        return this.caseSensitivity.checkCompareTo(suffix1, suffix2);
    }

    @Override
    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return super.toString() + "[caseSensitivity=" + (Object)((Object)this.caseSensitivity) + "]";
    }
}

