/*
 * Decompiled with CFR 0.152.
 */
package coveredclass.org.apache.commons.io;

import coveredclass.org.apache.commons.io.FileUtils;
import coveredclass.org.checkerframework.checker.initialization.qual.Initialized;
import coveredclass.org.checkerframework.checker.nullness.qual.NonNull;
import coveredclass.org.checkerframework.checker.nullness.qual.Nullable;
import coveredclass.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import coveredclass.org.checkerframework.dataflow.qual.SideEffectFree;
import java.io.File;
import java.io.IOException;

public class FileDeleteStrategy {
    public static final @UnknownKeyFor @NonNull @Initialized FileDeleteStrategy NORMAL = new FileDeleteStrategy("Normal");
    public static final @UnknownKeyFor @NonNull @Initialized FileDeleteStrategy FORCE = new ForceFileDeleteStrategy();
    private final @UnknownKeyFor @NonNull @Initialized String name;

    protected FileDeleteStrategy(@UnknownKeyFor @NonNull @Initialized String name) {
        this.name = name;
    }

    public void delete(@UnknownKeyFor @NonNull @Initialized File fileToDelete) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (fileToDelete.exists() && !this.doDelete(fileToDelete)) {
            throw new IOException("Deletion failed: " + fileToDelete);
        }
    }

    public @UnknownKeyFor @NonNull @Initialized boolean deleteQuietly(@Nullable @UnknownKeyFor @Initialized File fileToDelete) {
        if (fileToDelete == null || !fileToDelete.exists()) {
            return true;
        }
        try {
            return this.doDelete(fileToDelete);
        }
        catch (IOException ex) {
            return false;
        }
    }

    protected @UnknownKeyFor @NonNull @Initialized boolean doDelete(@UnknownKeyFor @NonNull @Initialized File fileToDelete) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return fileToDelete.delete();
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "FileDeleteStrategy[" + this.name + "]";
    }

    static class ForceFileDeleteStrategy
    extends FileDeleteStrategy {
        ForceFileDeleteStrategy() {
            super("Force");
        }

        @Override
        protected @UnknownKeyFor @NonNull @Initialized boolean doDelete(@UnknownKeyFor @NonNull @Initialized File fileToDelete) throws @UnknownKeyFor @NonNull @Initialized IOException {
            FileUtils.forceDelete(fileToDelete);
            return true;
        }
    }
}

