/*
 * Decompiled with CFR 0.152.
 */
package coveredclass.org.apache.commons.io;

import coveredclass.org.checkerframework.checker.initialization.qual.Initialized;
import coveredclass.org.checkerframework.checker.nullness.qual.NonNull;
import coveredclass.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class EndianUtils {
    public static @UnknownKeyFor @NonNull @Initialized short swapShort(@UnknownKeyFor @NonNull @Initialized short value) {
        return (short)(((value >> 0 & 0xFF) << 8) + ((value >> 8 & 0xFF) << 0));
    }

    public static @UnknownKeyFor @NonNull @Initialized int swapInteger(@UnknownKeyFor @NonNull @Initialized int value) {
        return ((value >> 0 & 0xFF) << 24) + ((value >> 8 & 0xFF) << 16) + ((value >> 16 & 0xFF) << 8) + ((value >> 24 & 0xFF) << 0);
    }

    public static @UnknownKeyFor @NonNull @Initialized long swapLong(@UnknownKeyFor @NonNull @Initialized long value) {
        return ((value >> 0 & 0xFFL) << 56) + ((value >> 8 & 0xFFL) << 48) + ((value >> 16 & 0xFFL) << 40) + ((value >> 24 & 0xFFL) << 32) + ((value >> 32 & 0xFFL) << 24) + ((value >> 40 & 0xFFL) << 16) + ((value >> 48 & 0xFFL) << 8) + ((value >> 56 & 0xFFL) << 0);
    }

    public static @UnknownKeyFor @NonNull @Initialized float swapFloat(@UnknownKeyFor @NonNull @Initialized float value) {
        return Float.intBitsToFloat(EndianUtils.swapInteger(Float.floatToIntBits(value)));
    }

    public static @UnknownKeyFor @NonNull @Initialized double swapDouble(@UnknownKeyFor @NonNull @Initialized double value) {
        return Double.longBitsToDouble(EndianUtils.swapLong(Double.doubleToLongBits(value)));
    }

    public static void writeSwappedShort(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] data, @UnknownKeyFor @NonNull @Initialized int offset, @UnknownKeyFor @NonNull @Initialized short value) {
        data[offset + 0] = (byte)(value >> 0 & 0xFF);
        data[offset + 1] = (byte)(value >> 8 & 0xFF);
    }

    public static @UnknownKeyFor @NonNull @Initialized short readSwappedShort(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] data, @UnknownKeyFor @NonNull @Initialized int offset) {
        return (short)(((data[offset + 0] & 0xFF) << 0) + ((data[offset + 1] & 0xFF) << 8));
    }

    public static @UnknownKeyFor @NonNull @Initialized int readSwappedUnsignedShort(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] data, @UnknownKeyFor @NonNull @Initialized int offset) {
        return ((data[offset + 0] & 0xFF) << 0) + ((data[offset + 1] & 0xFF) << 8);
    }

    public static void writeSwappedInteger(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] data, @UnknownKeyFor @NonNull @Initialized int offset, @UnknownKeyFor @NonNull @Initialized int value) {
        data[offset + 0] = (byte)(value >> 0 & 0xFF);
        data[offset + 1] = (byte)(value >> 8 & 0xFF);
        data[offset + 2] = (byte)(value >> 16 & 0xFF);
        data[offset + 3] = (byte)(value >> 24 & 0xFF);
    }

    public static @UnknownKeyFor @NonNull @Initialized int readSwappedInteger(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] data, @UnknownKeyFor @NonNull @Initialized int offset) {
        return ((data[offset + 0] & 0xFF) << 0) + ((data[offset + 1] & 0xFF) << 8) + ((data[offset + 2] & 0xFF) << 16) + ((data[offset + 3] & 0xFF) << 24);
    }

    public static @UnknownKeyFor @NonNull @Initialized long readSwappedUnsignedInteger(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] data, @UnknownKeyFor @NonNull @Initialized int offset) {
        long low = ((data[offset + 0] & 0xFF) << 0) + ((data[offset + 1] & 0xFF) << 8) + ((data[offset + 2] & 0xFF) << 16);
        long high = data[offset + 3] & 0xFF;
        return (high << 24) + (0xFFFFFFFFL & low);
    }

    public static void writeSwappedLong(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] data, @UnknownKeyFor @NonNull @Initialized int offset, @UnknownKeyFor @NonNull @Initialized long value) {
        data[offset + 0] = (byte)(value >> 0 & 0xFFL);
        data[offset + 1] = (byte)(value >> 8 & 0xFFL);
        data[offset + 2] = (byte)(value >> 16 & 0xFFL);
        data[offset + 3] = (byte)(value >> 24 & 0xFFL);
        data[offset + 4] = (byte)(value >> 32 & 0xFFL);
        data[offset + 5] = (byte)(value >> 40 & 0xFFL);
        data[offset + 6] = (byte)(value >> 48 & 0xFFL);
        data[offset + 7] = (byte)(value >> 56 & 0xFFL);
    }

    public static @UnknownKeyFor @NonNull @Initialized long readSwappedLong(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] data, @UnknownKeyFor @NonNull @Initialized int offset) {
        long low = EndianUtils.readSwappedInteger(data, offset);
        long high = EndianUtils.readSwappedInteger(data, offset + 4);
        return (high << 32) + (0xFFFFFFFFL & low);
    }

    public static void writeSwappedFloat(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] data, @UnknownKeyFor @NonNull @Initialized int offset, @UnknownKeyFor @NonNull @Initialized float value) {
        EndianUtils.writeSwappedInteger(data, offset, Float.floatToIntBits(value));
    }

    public static @UnknownKeyFor @NonNull @Initialized float readSwappedFloat(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] data, @UnknownKeyFor @NonNull @Initialized int offset) {
        return Float.intBitsToFloat(EndianUtils.readSwappedInteger(data, offset));
    }

    public static void writeSwappedDouble(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] data, @UnknownKeyFor @NonNull @Initialized int offset, @UnknownKeyFor @NonNull @Initialized double value) {
        EndianUtils.writeSwappedLong(data, offset, Double.doubleToLongBits(value));
    }

    public static @UnknownKeyFor @NonNull @Initialized double readSwappedDouble(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] data, @UnknownKeyFor @NonNull @Initialized int offset) {
        return Double.longBitsToDouble(EndianUtils.readSwappedLong(data, offset));
    }

    public static void writeSwappedShort(@UnknownKeyFor @NonNull @Initialized OutputStream output, @UnknownKeyFor @NonNull @Initialized short value) throws @UnknownKeyFor @NonNull @Initialized IOException {
        output.write((byte)(value >> 0 & 0xFF));
        output.write((byte)(value >> 8 & 0xFF));
    }

    public static @UnknownKeyFor @NonNull @Initialized short readSwappedShort(@UnknownKeyFor @NonNull @Initialized InputStream input) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return (short)(((EndianUtils.read(input) & 0xFF) << 0) + ((EndianUtils.read(input) & 0xFF) << 8));
    }

    public static @UnknownKeyFor @NonNull @Initialized int readSwappedUnsignedShort(@UnknownKeyFor @NonNull @Initialized InputStream input) throws @UnknownKeyFor @NonNull @Initialized IOException {
        int value1 = EndianUtils.read(input);
        int value2 = EndianUtils.read(input);
        return ((value1 & 0xFF) << 0) + ((value2 & 0xFF) << 8);
    }

    public static void writeSwappedInteger(@UnknownKeyFor @NonNull @Initialized OutputStream output, @UnknownKeyFor @NonNull @Initialized int value) throws @UnknownKeyFor @NonNull @Initialized IOException {
        output.write((byte)(value >> 0 & 0xFF));
        output.write((byte)(value >> 8 & 0xFF));
        output.write((byte)(value >> 16 & 0xFF));
        output.write((byte)(value >> 24 & 0xFF));
    }

    public static @UnknownKeyFor @NonNull @Initialized int readSwappedInteger(@UnknownKeyFor @NonNull @Initialized InputStream input) throws @UnknownKeyFor @NonNull @Initialized IOException {
        int value1 = EndianUtils.read(input);
        int value2 = EndianUtils.read(input);
        int value3 = EndianUtils.read(input);
        int value4 = EndianUtils.read(input);
        return ((value1 & 0xFF) << 0) + ((value2 & 0xFF) << 8) + ((value3 & 0xFF) << 16) + ((value4 & 0xFF) << 24);
    }

    public static @UnknownKeyFor @NonNull @Initialized long readSwappedUnsignedInteger(@UnknownKeyFor @NonNull @Initialized InputStream input) throws @UnknownKeyFor @NonNull @Initialized IOException {
        int value1 = EndianUtils.read(input);
        int value2 = EndianUtils.read(input);
        int value3 = EndianUtils.read(input);
        int value4 = EndianUtils.read(input);
        long low = ((value1 & 0xFF) << 0) + ((value2 & 0xFF) << 8) + ((value3 & 0xFF) << 16);
        long high = value4 & 0xFF;
        return (high << 24) + (0xFFFFFFFFL & low);
    }

    public static void writeSwappedLong(@UnknownKeyFor @NonNull @Initialized OutputStream output, @UnknownKeyFor @NonNull @Initialized long value) throws @UnknownKeyFor @NonNull @Initialized IOException {
        output.write((byte)(value >> 0 & 0xFFL));
        output.write((byte)(value >> 8 & 0xFFL));
        output.write((byte)(value >> 16 & 0xFFL));
        output.write((byte)(value >> 24 & 0xFFL));
        output.write((byte)(value >> 32 & 0xFFL));
        output.write((byte)(value >> 40 & 0xFFL));
        output.write((byte)(value >> 48 & 0xFFL));
        output.write((byte)(value >> 56 & 0xFFL));
    }

    public static @UnknownKeyFor @NonNull @Initialized long readSwappedLong(@UnknownKeyFor @NonNull @Initialized InputStream input) throws @UnknownKeyFor @NonNull @Initialized IOException {
        byte[] bytes = new byte[8];
        for (int i = 0; i < 8; ++i) {
            bytes[i] = (byte)EndianUtils.read(input);
        }
        return EndianUtils.readSwappedLong(bytes, 0);
    }

    public static void writeSwappedFloat(@UnknownKeyFor @NonNull @Initialized OutputStream output, @UnknownKeyFor @NonNull @Initialized float value) throws @UnknownKeyFor @NonNull @Initialized IOException {
        EndianUtils.writeSwappedInteger(output, Float.floatToIntBits(value));
    }

    public static @UnknownKeyFor @NonNull @Initialized float readSwappedFloat(@UnknownKeyFor @NonNull @Initialized InputStream input) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return Float.intBitsToFloat(EndianUtils.readSwappedInteger(input));
    }

    public static void writeSwappedDouble(@UnknownKeyFor @NonNull @Initialized OutputStream output, @UnknownKeyFor @NonNull @Initialized double value) throws @UnknownKeyFor @NonNull @Initialized IOException {
        EndianUtils.writeSwappedLong(output, Double.doubleToLongBits(value));
    }

    public static @UnknownKeyFor @NonNull @Initialized double readSwappedDouble(@UnknownKeyFor @NonNull @Initialized InputStream input) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return Double.longBitsToDouble(EndianUtils.readSwappedLong(input));
    }

    private static @UnknownKeyFor @NonNull @Initialized int read(@UnknownKeyFor @NonNull @Initialized InputStream input) throws @UnknownKeyFor @NonNull @Initialized IOException {
        int value = input.read();
        if (-1 == value) {
            throw new EOFException("Unexpected EOF reached");
        }
        return value;
    }
}

