/*
 * Decompiled with CFR 0.152.
 */
package coveredclass.org.apache.commons.io;

import coveredclass.org.checkerframework.checker.initialization.qual.Initialized;
import coveredclass.org.checkerframework.checker.nullness.qual.NonNull;
import coveredclass.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import java.nio.ByteOrder;

public final class ByteOrderParser {
    private ByteOrderParser() {
    }

    public static @UnknownKeyFor @NonNull @Initialized ByteOrder parseByteOrder(@UnknownKeyFor @NonNull @Initialized String value) {
        if (ByteOrder.BIG_ENDIAN.toString().equals(value)) {
            return ByteOrder.BIG_ENDIAN;
        }
        if (ByteOrder.LITTLE_ENDIAN.toString().equals(value)) {
            return ByteOrder.LITTLE_ENDIAN;
        }
        throw new IllegalArgumentException("Unsupported byte order setting: " + value + ", expected one of " + ByteOrder.LITTLE_ENDIAN + ", " + ByteOrder.BIG_ENDIAN);
    }
}

