/*
 * Decompiled with CFR 0.152.
 */
package coveredclass.org.apache.bcel.verifier.statics;

import coveredclass.org.apache.bcel.Repository;
import coveredclass.org.apache.bcel.classfile.ClassFormatException;
import coveredclass.org.apache.bcel.classfile.JavaClass;
import coveredclass.org.apache.bcel.verifier.PassVerifier;
import coveredclass.org.apache.bcel.verifier.VerificationResult;
import coveredclass.org.apache.bcel.verifier.Verifier;
import coveredclass.org.apache.bcel.verifier.exc.LoadingException;
import coveredclass.org.apache.bcel.verifier.exc.Utility;
import coveredclass.org.checkerframework.checker.initialization.qual.Initialized;
import coveredclass.org.checkerframework.checker.interning.qual.UnknownInterned;
import coveredclass.org.checkerframework.checker.nullness.qual.NonNull;
import coveredclass.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;

public final class Pass1Verifier
extends PassVerifier {
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass jc;
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Verifier myOwner;

    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass getJavaClass() {
        if (this.jc == null) {
            try {
                this.jc = Repository.lookupClass(this.myOwner.getClassName());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return this.jc;
    }

    public Pass1Verifier(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Verifier owner) {
        this.myOwner = owner;
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown VerificationResult do_verify() {
        JavaClass jc;
        try {
            jc = this.getJavaClass();
            if (jc != null && !this.myOwner.getClassName().equals(jc.getClassName())) {
                throw new LoadingException("Wrong name: the internal name of the .class file '" + jc.getClassName() + "' does not match the file's name '" + this.myOwner.getClassName() + "'.");
            }
        }
        catch (LoadingException e) {
            return new VerificationResult(2, e.getMessage());
        }
        catch (ClassFormatException e) {
            return new VerificationResult(2, e.getMessage());
        }
        catch (RuntimeException e) {
            return new VerificationResult(2, "Parsing via BCEL did not succeed. " + e.getClass().getName() + " occured:\n" + Utility.getStackTrace(e));
        }
        if (jc != null) {
            return VerificationResult.VR_OK;
        }
        return new VerificationResult(2, "Repository.lookup() failed. FILE NOT FOUND?");
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getMessages() {
        return super.getMessages();
    }
}

