/*
 * Decompiled with CFR 0.152.
 */
package coveredclass.org.apache.bcel.generic;

import coveredclass.org.apache.bcel.generic.CompoundInstruction;
import coveredclass.org.apache.bcel.generic.Instruction;
import coveredclass.org.apache.bcel.generic.InstructionHandle;
import coveredclass.org.apache.bcel.generic.InstructionList;
import coveredclass.org.apache.bcel.generic.LOOKUPSWITCH;
import coveredclass.org.apache.bcel.generic.Select;
import coveredclass.org.apache.bcel.generic.TABLESWITCH;
import coveredclass.org.checkerframework.checker.initialization.qual.Initialized;
import coveredclass.org.checkerframework.checker.interning.qual.Interned;
import coveredclass.org.checkerframework.checker.interning.qual.UnknownInterned;
import coveredclass.org.checkerframework.checker.nullness.qual.NonNull;
import coveredclass.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;

public final class SWITCH
implements CompoundInstruction {
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] match;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] targets;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Select instruction;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int match_length;

    public SWITCH(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] match, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] targets, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle target, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int max_gap) {
        this.match = (int[])match.clone();
        this.targets = (InstructionHandle[])targets.clone();
        this.match_length = match.length;
        if (this.match_length < 2) {
            this.instruction = new TABLESWITCH(match, targets, target);
        } else {
            this.sort(0, this.match_length - 1);
            if (this.matchIsOrdered(max_gap)) {
                this.fillup(max_gap, target);
                this.instruction = new TABLESWITCH(this.match, this.targets, target);
            } else {
                this.instruction = new LOOKUPSWITCH(this.match, this.targets, target);
            }
        }
    }

    public SWITCH(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] match, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] targets, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle target) {
        this(match, targets, target, 1);
    }

    private void fillup(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int max_gap, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle target) {
        int max_size = this.match_length + this.match_length * max_gap;
        int[] m_vec = new int[max_size];
        InstructionHandle[] t_vec = new InstructionHandle[max_size];
        int count = 1;
        m_vec[0] = this.match[0];
        t_vec[0] = this.targets[0];
        for (int i = 1; i < this.match_length; ++i) {
            int prev = this.match[i - 1];
            int gap = this.match[i] - prev;
            for (int j = 1; j < gap; ++j) {
                m_vec[count] = prev + j;
                t_vec[count] = target;
                ++count;
            }
            m_vec[count] = this.match[i];
            t_vec[count] = this.targets[i];
            ++count;
        }
        this.match = new int[count];
        this.targets = new InstructionHandle[count];
        System.arraycopy(m_vec, 0, this.match, 0, count);
        System.arraycopy(t_vec, 0, this.targets, 0, count);
    }

    private void sort(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int l, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int r) {
        int i = l;
        int j = r;
        int m3 = this.match[l + r >>> 1];
        while (true) {
            if (this.match[i] < m3) {
                ++i;
                continue;
            }
            while (m3 < this.match[j]) {
                --j;
            }
            if (i <= j) {
                int h2 = this.match[i];
                this.match[i] = this.match[j];
                this.match[j] = h2;
                InstructionHandle h22 = this.targets[i];
                this.targets[i] = this.targets[j];
                this.targets[j] = h22;
                ++i;
                --j;
            }
            if (i > j) break;
        }
        if (l < j) {
            this.sort(l, j);
        }
        if (i < r) {
            this.sort(i, r);
        }
    }

    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean matchIsOrdered(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int max_gap) {
        for (int i = 1; i < this.match_length; ++i) {
            if (this.match[i] - this.match[i - 1] <= max_gap) continue;
            return false;
        }
        return true;
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionList getInstructionList() {
        return new InstructionList(this.instruction);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Instruction getInstruction() {
        return this.instruction;
    }
}

